/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.BaseComplexTypesPredicatePushDownTest;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveParquetComplexTypePredicatePushDown
extends BaseComplexTypesPredicatePushDownTest {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.builder().addHiveProperty("hive.storage-format", "PARQUET").build();
    }

    @Test
    public void ensureFormatParquet() {
        String tableName = "test_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (colTest BIGINT)");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + tableName))).contains(new CharSequence[]{"PARQUET"});
        this.assertUpdate("DROP TABLE " + tableName);
    }
}

