/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.base.Joiner;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.testing.BaseTestParquetWithBloomFilters;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.List;

public class TestHiveParquetWithBloomFilters
extends BaseTestParquetWithBloomFilters {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.builder().build();
    }

    protected CatalogSchemaTableName createParquetTableWithBloomFilter(String columnName, List<Integer> testValues) {
        String tableName = "parquet_with_bloom_filters_" + TestingNames.randomNameSuffix();
        CatalogSchemaTableName catalogSchemaTableName = new CatalogSchemaTableName("hive", new SchemaTableName("tpch", tableName));
        this.assertUpdate(String.format("CREATE TABLE %s WITH (format = 'PARQUET', parquet_bloom_filter_columns = ARRAY['%s']) AS SELECT * FROM (VALUES %s) t(%s)", catalogSchemaTableName, columnName, Joiner.on((String)", ").join(testValues), columnName), testValues.size());
        return catalogSchemaTableName;
    }
}

