/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.parquet.ParquetUtil;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOnlyNulls {
    @Test
    public void testOnlyNulls() throws Exception {
        MaterializedResult result;
        File parquetFile = new File(Resources.getResource((String)"issue-10873.parquet").toURI());
        String columnName = "x";
        IntegerType columnType = IntegerType.INTEGER;
        HiveColumnHandle column = HiveColumnHandle.createBaseColumn((String)columnName, (int)0, (HiveType)HiveTypeTranslator.toHiveType((Type)columnType), (Type)columnType, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        try (ConnectorPageSource pageSource = ParquetUtil.createPageSource(HiveTestUtils.SESSION, parquetFile, (List<HiveColumnHandle>)ImmutableList.of((Object)column), (TupleDomain<HiveColumnHandle>)TupleDomain.withColumnDomains(Map.of(column, Domain.notNull((Type)columnType))));){
            result = MaterializedResult.materializeSourceDataStream((ConnectorSession)HiveTestUtils.getHiveSession(new HiveConfig()), (ConnectorPageSource)pageSource, List.of(columnType)).toTestTypes();
            Assertions.assertThat((List)result.getMaterializedRows()).isEmpty();
        }
        pageSource = ParquetUtil.createPageSource(HiveTestUtils.SESSION, parquetFile, (List<HiveColumnHandle>)ImmutableList.of((Object)column), (TupleDomain<HiveColumnHandle>)TupleDomain.withColumnDomains(Map.of(column, Domain.onlyNull((Type)columnType))));
        try {
            result = MaterializedResult.materializeSourceDataStream((ConnectorSession)HiveTestUtils.getHiveSession(new HiveConfig()), (ConnectorPageSource)pageSource, List.of(columnType)).toTestTypes();
            Assertions.assertThat((List)result.getMaterializedRows()).isEqualTo(List.of(new MaterializedRow(Collections.singletonList(null)), new MaterializedRow(Collections.singletonList(null)), new MaterializedRow(Collections.singletonList(null)), new MaterializedRow(Collections.singletonList(null))));
        }
        finally {
            if (pageSource != null) {
                pageSource.close();
            }
        }
    }
}

