/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.TestHiveReaderProjectionsUtil;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class TestParquetPageSourceFactory {
    private static final List<String> TEST_COLUMN_NAMES = ImmutableList.of((Object)"col_bigint", (Object)"col_struct_of_primitives", (Object)"col_struct_of_non_primitives", (Object)"col_partition_key_1", (Object)"col_partition_key_2");
    private static final Map<String, io.trino.spi.type.Type> TEST_COLUMN_TYPES = ImmutableMap.builder().put((Object)"col_bigint", (Object)BigintType.BIGINT).put((Object)"col_struct_of_primitives", (Object)TestHiveReaderProjectionsUtil.ROWTYPE_OF_PRIMITIVES).put((Object)"col_struct_of_non_primitives", (Object)TestHiveReaderProjectionsUtil.ROWTYPE_OF_ROW_AND_PRIMITIVES).put((Object)"col_partition_key_1", (Object)BigintType.BIGINT).put((Object)"col_partition_key_2", (Object)BigintType.BIGINT).buildOrThrow();
    private static final Map<String, HiveColumnHandle> TEST_FULL_COLUMNS = TestHiveReaderProjectionsUtil.createTestFullColumns(TEST_COLUMN_NAMES, TEST_COLUMN_TYPES);

    @Test
    public void testGetNestedMixedRepetitionColumnType() {
        this.testGetNestedMixedRepetitionColumnType(true);
        this.testGetNestedMixedRepetitionColumnType(false);
    }

    private void testGetNestedMixedRepetitionColumnType(boolean useColumnNames) {
        RowType rowType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"optional_level2", (io.trino.spi.type.Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"required_level3", (io.trino.spi.type.Type)IntegerType.INTEGER)}))});
        HiveColumnHandle columnHandle = new HiveColumnHandle("optional_level1", 0, HiveType.valueOf((String)"struct<optional_level2:struct<required_level3:int>>"), (io.trino.spi.type.Type)rowType, Optional.of(new HiveColumnProjectionInfo((List)ImmutableList.of((Object)1, (Object)1), (List)ImmutableList.of((Object)"optional_level2", (Object)"required_level3"), HiveTypeTranslator.toHiveType((io.trino.spi.type.Type)IntegerType.INTEGER), (io.trino.spi.type.Type)IntegerType.INTEGER)), HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "optional_level1", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "optional_level2", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "required_level3")})})});
        Assertions.assertThat((Object)((Type)ParquetPageSourceFactory.getColumnType((HiveColumnHandle)columnHandle, (MessageType)fileSchema, (boolean)useColumnNames).get())).isEqualTo((Object)fileSchema.getType("optional_level1"));
    }

    @Test
    void testNoProjections() {
        ArrayList<HiveColumnHandle> columns = new ArrayList<HiveColumnHandle>(TEST_FULL_COLUMNS.values());
        List sufficientColumns = ParquetPageSourceFactory.projectSufficientColumns(columns);
        ((ListAssert)Assertions.assertThat((List)sufficientColumns).describedAs("Full columns should not require any adaptation", new Object[0])).isEqualTo(columns);
    }

    @Test
    void testProjectSufficientColumns() {
        ImmutableList columns = ImmutableList.of((Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_primitives"), (List<Integer>)ImmutableList.of((Object)0)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_primitives"), (List<Integer>)ImmutableList.of((Object)1)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_bigint"), (List<Integer>)ImmutableList.of()), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_non_primitives"), (List<Integer>)ImmutableList.of((Object)0, (Object)1)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_non_primitives"), (List<Integer>)ImmutableList.of((Object)0)));
        List sufficientColumns = ParquetPageSourceFactory.projectSufficientColumns((List)columns);
        Assertions.assertThat((Object)((HiveColumnHandle)sufficientColumns.get(0))).isEqualTo(columns.get(0));
        Assertions.assertThat((Object)((HiveColumnHandle)sufficientColumns.get(1))).isEqualTo(columns.get(1));
        Assertions.assertThat((Object)((HiveColumnHandle)sufficientColumns.get(2))).isEqualTo(columns.get(2));
        Assertions.assertThat((Object)((HiveColumnHandle)sufficientColumns.get(3))).isEqualTo(columns.get(4));
    }
}

