/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.io.Resources;
import io.trino.Session;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import java.io.OutputStream;
import java.net.URL;
import java.util.UUID;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestReadingTimeLogicalAnnotation {
    @Test
    public void testReadingTimeLogicalAnnotationAsBigInt() throws Exception {
        try (DistributedQueryRunner queryRunner = HiveQueryRunner.builder().build();
             QueryAssertions assertions = new QueryAssertions((QueryRunner)queryRunner);){
            URL resourceLocation = Resources.getResource((String)"parquet_file_with_time_logical_annotation/time-micros.parquet");
            TrinoFileSystem fileSystem = TestingHiveUtils.getConnectorService((QueryRunner)queryRunner, TrinoFileSystemFactory.class).create(ConnectorIdentity.ofUser((String)"test"));
            Location tempDir = Location.of((String)("local:///temp_" + String.valueOf(UUID.randomUUID())));
            fileSystem.createDirectory(tempDir);
            Location dataFile = tempDir.appendPath("data.parquet");
            try (OutputStream out = fileSystem.newOutputFile(dataFile).create();){
                Resources.copy((URL)resourceLocation, (OutputStream)out);
            }
            queryRunner.execute("CREATE TABLE table_with_time_logical_annotation (\n    \"opens\" row(member0 bigint, member_1 varchar))\nWITH (\n    external_location = '%s',\n    format = 'PARQUET')\n".formatted(dataFile.parentDirectory()));
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)assertions.query("SELECT opens.member0 FROM table_with_time_logical_annotation GROUP BY 1 ORDER BY 1 LIMIT 5"))).result().matches(MaterializedResult.resultBuilder((Session)queryRunner.getDefaultSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{0L}).row(new Object[]{21600000000L}).row(new Object[]{25200000000L}).row(new Object[]{28800000000L}).row(new Object[]{32400000000L}).build());
            queryRunner.execute("DROP TABLE table_with_time_logical_annotation");
        }
    }
}

