/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.parquet.ParquetTester;
import io.trino.plugin.hive.parquet.ParquetUtil;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.Test;

public class TestTimestamp {
    @Test
    public void testTimestampBackedByInt64WithDifferentTimezone() throws Exception {
        this.testTimestampBackedByInt64(DateTimeZone.forID((String)"America/New_York"));
        this.testTimestampBackedByInt64(DateTimeZone.forID((String)"UTC"));
    }

    private void testTimestampBackedByInt64(DateTimeZone dateTimeZone) throws Exception {
        for (HiveTimestampPrecision timestamp : HiveTimestampPrecision.values()) {
            String logicalAnnotation = switch (timestamp) {
                default -> throw new MatchException(null, null);
                case HiveTimestampPrecision.MILLISECONDS -> "TIMESTAMP(MILLIS,true)";
                case HiveTimestampPrecision.MICROSECONDS -> "TIMESTAMP(MICROS,true)";
                case HiveTimestampPrecision.NANOSECONDS -> "TIMESTAMP(NANOS,true)";
            };
            MessageType parquetSchema = MessageTypeParser.parseMessageType((String)("message hive_timestamp { optional int64 test (" + logicalAnnotation + "); }"));
            Iterable writeNullableDictionaryValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1L, null, 3L, 5L, null, null, null, 7L, 11L, null, 13L, 17L)), (int)30000);
            TestTimestamp.testRoundTrip(parquetSchema, writeNullableDictionaryValues, timestamp, dateTimeZone);
            Iterable writeDictionaryValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1L, 3L, 5L, 7L, 11L, 13L, 17L)), (int)30000);
            TestTimestamp.testRoundTrip(parquetSchema, writeDictionaryValues, timestamp, dateTimeZone);
            ContiguousSet writeValues = ContiguousSet.create((Range)Range.closedOpen((Comparable)Long.valueOf(-1000L), (Comparable)Long.valueOf(1000L)), (DiscreteDomain)DiscreteDomain.longs());
            TestTimestamp.testRoundTrip(parquetSchema, (Iterable<Long>)writeValues, timestamp, dateTimeZone);
        }
    }

    private static void testRoundTrip(MessageType parquetSchema, Iterable<Long> writeValues, HiveTimestampPrecision timestamp, DateTimeZone dateTimeZone) throws Exception {
        Iterable timestampReadValues = Iterables.transform(writeValues, value -> {
            if (value == null) {
                return null;
            }
            return switch (timestamp) {
                default -> throw new MatchException(null, null);
                case HiveTimestampPrecision.MILLISECONDS -> SqlTimestamp.fromMillis((int)timestamp.getPrecision(), (long)dateTimeZone.convertUTCToLocal(value.longValue()));
                case HiveTimestampPrecision.MICROSECONDS -> SqlTimestamp.newInstance((int)timestamp.getPrecision(), (long)(dateTimeZone.convertUTCToLocal(Math.floorDiv((long)value, 1000)) * 1000L + (long)Math.floorMod((long)value, 1000)), (int)0);
                case HiveTimestampPrecision.NANOSECONDS -> {
                    long localMicros = dateTimeZone.convertUTCToLocal(Math.floorDiv((long)value, 1000000));
                    yield SqlTimestamp.newInstance((int)timestamp.getPrecision(), (long)(localMicros * 1000L + (long)(Math.floorMod((long)value, 1000000) / 1000)), (int)(Math.floorMod((long)value, 1000) * 1000));
                }
            };
        });
        List<JavaLongObjectInspector> objectInspectors = Collections.singletonList(PrimitiveObjectInspectorFactory.javaLongObjectInspector);
        ImmutableList columnNames = ImmutableList.of((Object)"test");
        try (ParquetTester.TempFile tempFile = new ParquetTester.TempFile("test", "parquet");){
            JobConf jobConf = new JobConf(false);
            jobConf.setEnum("parquet.writer.version", (Enum)ParquetProperties.WriterVersion.PARQUET_1_0);
            ParquetTester.writeParquetColumn(jobConf, tempFile.getFile(), CompressionCodec.SNAPPY, ParquetTester.createTableProperties((List<String>)columnNames, objectInspectors), (SettableStructObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)columnNames, objectInspectors), new Iterator[]{writeValues.iterator()}, Optional.of(parquetSchema), false, DateTimeZone.getDefault());
            ConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig());
            TestTimestamp.testReadingAs((Type)TimestampType.createTimestampType((int)timestamp.getPrecision()), session, tempFile, (List<String>)columnNames, timestampReadValues, dateTimeZone);
            TestTimestamp.testReadingAs((Type)BigintType.BIGINT, session, tempFile, (List<String>)columnNames, writeValues, dateTimeZone);
        }
    }

    private static void testReadingAs(Type type, ConnectorSession session, ParquetTester.TempFile tempFile, List<String> columnNames, Iterable<?> expectedValues, DateTimeZone dateTimeZone) throws IOException {
        Iterator<?> expected = expectedValues.iterator();
        try (ConnectorPageSource pageSource = ParquetUtil.createPageSource(session, tempFile.getFile(), columnNames, (List<Type>)ImmutableList.of((Object)type), dateTimeZone);){
            SourcePage firstPage = pageSource.getNextSourcePage();
            ((AbstractBooleanAssert)Assertions.assertThat((firstPage.getPositionCount() > 0 ? 1 : 0) != 0).describedAs("Expected first page to have at least 1 row", new Object[0])).isTrue();
            for (int i = 0; i < firstPage.getPositionCount(); ++i) {
                expected.next();
            }
            int pageCount = 1;
            while (!pageSource.isFinished()) {
                SourcePage page = pageSource.getNextSourcePage();
                if (page == null) continue;
                ++pageCount;
                Block block = page.getBlock(0);
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    Assertions.assertThat((Object)type.getObjectValue(session, block, i)).isEqualTo(expected.next());
                }
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)pageCount).withFailMessage("Expected more than one page but processed %s", new Object[]{pageCount})).isGreaterThan(1);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)expected.hasNext()).describedAs("Read fewer values than expected", new Object[0])).isFalse();
        }
    }
}

