/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet.predicate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.metastore.HiveType;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TypeOperators;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestParquetPredicateUtils {
    @Test
    public void testParquetTupleDomainPrimitiveArray() {
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)"my_array", (int)0, (HiveType)HiveType.valueOf((String)"array<int>"), (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)IntegerType.INTEGER), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)IntegerType.INTEGER))));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_array", new Type[]{new GroupType(Type.Repetition.REPEATED, "bag", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "array_element")})})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        Assertions.assertThat((boolean)ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain, (MessageType)fileSchema, (boolean)true).isAll()).isTrue();
        Assertions.assertThat((boolean)ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain, (MessageType)fileSchema, (boolean)false).isAll()).isTrue();
    }

    @Test
    public void testParquetTupleDomainStructArray() {
        RowType.Field rowField = new RowType.Field(Optional.of("a"), (io.trino.spi.type.Type)IntegerType.INTEGER);
        RowType rowType = RowType.from((List)ImmutableList.of((Object)rowField));
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)"my_array_struct", (int)0, (HiveType)HiveType.valueOf((String)"array<struct<a:int>>"), (io.trino.spi.type.Type)rowType, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)rowType))));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_array_struct", new Type[]{new GroupType(Type.Repetition.REPEATED, "bag", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "array_element", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a")})})})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        Assertions.assertThat((boolean)ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain, (MessageType)fileSchema, (boolean)true).isAll()).isTrue();
        Assertions.assertThat((boolean)ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain, (MessageType)fileSchema, (boolean)false).isAll()).isTrue();
    }

    @Test
    public void testParquetTupleDomainPrimitive() {
        this.testParquetTupleDomainPrimitive(true);
        this.testParquetTupleDomainPrimitive(false);
    }

    private void testParquetTupleDomainPrimitive(boolean useColumnNames) {
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)"my_primitive", (int)0, (HiveType)HiveType.valueOf((String)"bigint"), (io.trino.spi.type.Type)BigintType.BIGINT, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        Domain singleValueDomain = Domain.singleValue((io.trino.spi.type.Type)BigintType.BIGINT, (Object)123L);
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)singleValueDomain));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "my_primitive")});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain, (MessageType)fileSchema, (boolean)useColumnNames);
        Assertions.assertThat((Map)((Map)tupleDomain.getDomains().get())).hasSize(1);
        ColumnDescriptor descriptor = (ColumnDescriptor)((Map)tupleDomain.getDomains().get()).keySet().iterator().next();
        Assertions.assertThat((int)descriptor.getPath().length).isEqualTo(1);
        Assertions.assertThat((String)descriptor.getPath()[0]).isEqualTo("my_primitive");
        Domain predicateDomain = (Domain)Iterables.getOnlyElement(((Map)tupleDomain.getDomains().get()).values());
        Assertions.assertThat((Object)predicateDomain).isEqualTo((Object)singleValueDomain);
    }

    @Test
    public void testParquetTupleDomainStruct() {
        RowType rowType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"b", (io.trino.spi.type.Type)IntegerType.INTEGER)});
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)"my_struct", (int)0, (HiveType)HiveType.valueOf((String)"struct<a:int,b:int>"), (io.trino.spi.type.Type)rowType, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((io.trino.spi.type.Type)rowType)));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_struct", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "b"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "c")})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        Assertions.assertThat((boolean)ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain, (MessageType)fileSchema, (boolean)true).isAll()).isTrue();
        Assertions.assertThat((boolean)ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain, (MessageType)fileSchema, (boolean)false).isAll()).isTrue();
    }

    @Test
    public void testParquetTupleDomainStructWithPrimitiveColumnPredicate() {
        this.testParquetTupleDomainStructWithPrimitiveColumnPredicate(true);
        this.testParquetTupleDomainStructWithPrimitiveColumnPredicate(false);
    }

    private void testParquetTupleDomainStructWithPrimitiveColumnPredicate(boolean useColumNames) {
        RowType baseType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"b", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"c", (io.trino.spi.type.Type)IntegerType.INTEGER)});
        HiveColumnProjectionInfo columnProjectionInfo = new HiveColumnProjectionInfo((List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)"b"), HiveType.HIVE_INT, (io.trino.spi.type.Type)IntegerType.INTEGER);
        HiveColumnHandle projectedColumn = new HiveColumnHandle("row_field", 0, HiveTypeTranslator.toHiveType((io.trino.spi.type.Type)baseType), (io.trino.spi.type.Type)baseType, Optional.of(columnProjectionInfo), HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        Domain predicateDomain = Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)123L);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)projectedColumn, (Object)predicateDomain));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "row_field", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "b"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "c")})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain calculatedTupleDomain = ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)tupleDomain, (MessageType)fileSchema, (boolean)useColumNames);
        Assertions.assertThat((Map)((Map)calculatedTupleDomain.getDomains().get())).hasSize(1);
        ColumnDescriptor selectedColumnDescriptor = (ColumnDescriptor)descriptorsByPath.get(ImmutableList.of((Object)"row_field", (Object)"b"));
        Assertions.assertThat((Map)((Map)calculatedTupleDomain.getDomains().get())).containsEntry((Object)selectedColumnDescriptor, (Object)predicateDomain);
    }

    @Test
    public void testParquetTupleDomainStructWithComplexColumnPredicate() {
        RowType c1Type = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c1", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"c2", (io.trino.spi.type.Type)IntegerType.INTEGER)});
        RowType baseType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"b", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"c", (io.trino.spi.type.Type)c1Type)});
        HiveColumnProjectionInfo columnProjectionInfo = new HiveColumnProjectionInfo((List)ImmutableList.of((Object)2), (List)ImmutableList.of((Object)"C"), HiveTypeTranslator.toHiveType((io.trino.spi.type.Type)c1Type), (io.trino.spi.type.Type)c1Type);
        HiveColumnHandle projectedColumn = new HiveColumnHandle("row_field", 0, HiveTypeTranslator.toHiveType((io.trino.spi.type.Type)baseType), (io.trino.spi.type.Type)baseType, Optional.of(columnProjectionInfo), HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        Domain predicateDomain = Domain.onlyNull((io.trino.spi.type.Type)c1Type);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)projectedColumn, (Object)predicateDomain));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "row_field", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "b"), new GroupType(Type.Repetition.OPTIONAL, "c", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "c1"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "c2")})})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        Assertions.assertThat((boolean)ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)tupleDomain, (MessageType)fileSchema, (boolean)true).isAll()).isTrue();
        Assertions.assertThat((boolean)ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)tupleDomain, (MessageType)fileSchema, (boolean)false).isAll()).isTrue();
    }

    @Test
    public void testParquetTupleDomainStructWithMissingPrimitiveColumn() {
        RowType baseType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"b", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"non_exist", (io.trino.spi.type.Type)IntegerType.INTEGER)});
        HiveColumnProjectionInfo columnProjectionInfo = new HiveColumnProjectionInfo((List)ImmutableList.of((Object)2), (List)ImmutableList.of((Object)"non_exist"), HiveType.HIVE_INT, (io.trino.spi.type.Type)IntegerType.INTEGER);
        HiveColumnHandle projectedColumn = new HiveColumnHandle("row_field", 0, HiveTypeTranslator.toHiveType((io.trino.spi.type.Type)baseType), (io.trino.spi.type.Type)baseType, Optional.of(columnProjectionInfo), HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        Domain predicateDomain = Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)123L);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)projectedColumn, (Object)predicateDomain));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "row_field", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "b")})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        Assertions.assertThat((boolean)ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)tupleDomain, (MessageType)fileSchema, (boolean)true).isAll()).isTrue();
        Assertions.assertThat((boolean)ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)tupleDomain, (MessageType)fileSchema, (boolean)false).isAll()).isTrue();
    }

    @Test
    public void testParquetTupleDomainMap() {
        MapType mapType = new MapType((io.trino.spi.type.Type)IntegerType.INTEGER, (io.trino.spi.type.Type)IntegerType.INTEGER, new TypeOperators());
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)"my_map", (int)0, (HiveType)HiveType.valueOf((String)"map<int,int>"), (io.trino.spi.type.Type)mapType, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((io.trino.spi.type.Type)mapType)));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_map", new Type[]{new GroupType(Type.Repetition.REPEATED, "map", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "key"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "value")})})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        Assertions.assertThat((boolean)ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain, (MessageType)fileSchema, (boolean)true).isAll()).isTrue();
        Assertions.assertThat((boolean)ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain, (MessageType)fileSchema, (boolean)false).isAll()).isTrue();
    }
}

