/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet.write;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public final class MapKeyValuesSchemaConverter {
    private MapKeyValuesSchemaConverter() {
    }

    public static MessageType convert(List<String> columnNames, List<TypeInfo> columnTypes) {
        return new MessageType("hive_schema", MapKeyValuesSchemaConverter.convertTypes(columnNames, columnTypes));
    }

    private static Type[] convertTypes(List<String> columnNames, List<TypeInfo> columnTypes) {
        Preconditions.checkState((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (String)"Mismatched Hive columns %s and types %s", columnNames, columnTypes);
        Type[] types = new Type[columnNames.size()];
        for (int i = 0; i < columnNames.size(); ++i) {
            types[i] = MapKeyValuesSchemaConverter.convertType(columnNames.get(i), columnTypes.get(i));
        }
        return types;
    }

    private static Type convertType(String name, TypeInfo typeInfo) {
        return MapKeyValuesSchemaConverter.convertType(name, typeInfo, Type.Repetition.OPTIONAL);
    }

    private static Type convertType(String name, TypeInfo typeInfo, Type.Repetition repetition) {
        if (typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            if (typeInfo.equals((Object)TypeInfoFactory.stringTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.intTypeInfo) || typeInfo.equals((Object)TypeInfoFactory.shortTypeInfo) || typeInfo.equals((Object)TypeInfoFactory.byteTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.longTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.doubleTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.floatTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.booleanTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.binaryTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.timestampTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.voidTypeInfo)) {
                throw new UnsupportedOperationException("Void type not implemented");
            }
            if (typeInfo.getTypeName().toLowerCase(Locale.ENGLISH).startsWith("char")) {
                return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(name);
            }
            if (typeInfo.getTypeName().toLowerCase(Locale.ENGLISH).startsWith("varchar")) {
                return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(name);
            }
            if (typeInfo instanceof DecimalTypeInfo) {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                int prec = decimalTypeInfo.precision();
                int scale = decimalTypeInfo.scale();
                int bytes = ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[prec - 1];
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(bytes)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)prec))).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.dateTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType())).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.unknownTypeInfo)) {
                throw new UnsupportedOperationException("Unknown type not implemented");
            }
            throw new IllegalArgumentException("Unknown type: " + String.valueOf(typeInfo));
        }
        if (typeInfo.getCategory() == ObjectInspector.Category.LIST) {
            return MapKeyValuesSchemaConverter.convertArrayType(name, (ListTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory() == ObjectInspector.Category.STRUCT) {
            return MapKeyValuesSchemaConverter.convertStructType(name, (StructTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory() == ObjectInspector.Category.MAP) {
            return MapKeyValuesSchemaConverter.convertMapType(name, (MapTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory() == ObjectInspector.Category.UNION) {
            throw new UnsupportedOperationException("Union type not implemented");
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(typeInfo));
    }

    private static GroupType convertArrayType(String name, ListTypeInfo typeInfo) {
        TypeInfo subType = typeInfo.getListElementTypeInfo();
        return MapKeyValuesSchemaConverter.listWrapper(name, new GroupType(Type.Repetition.REPEATED, ParquetHiveSerDe.ARRAY.toString(), new Type[]{MapKeyValuesSchemaConverter.convertType("array_element", subType)}));
    }

    private static GroupType convertStructType(String name, StructTypeInfo typeInfo) {
        ArrayList columnNames = typeInfo.getAllStructFieldNames();
        ArrayList columnTypes = typeInfo.getAllStructFieldTypeInfos();
        return new GroupType(Type.Repetition.OPTIONAL, name, MapKeyValuesSchemaConverter.convertTypes(columnNames, columnTypes));
    }

    private static GroupType convertMapType(String name, MapTypeInfo typeInfo) {
        Type keyType = MapKeyValuesSchemaConverter.convertType(ParquetHiveSerDe.MAP_KEY.toString(), typeInfo.getMapKeyTypeInfo(), Type.Repetition.REQUIRED);
        Type valueType = MapKeyValuesSchemaConverter.convertType(ParquetHiveSerDe.MAP_VALUE.toString(), typeInfo.getMapValueTypeInfo());
        return MapKeyValuesSchemaConverter.mapType(Type.Repetition.OPTIONAL, name, "map", keyType, valueType);
    }

    public static GroupType mapType(Type.Repetition repetition, String alias, String mapAlias, Type keyType, Type valueType) {
        if (valueType == null) {
            return MapKeyValuesSchemaConverter.mapKeyValueWrapper(repetition, alias, (Type)new GroupType(Type.Repetition.REPEATED, mapAlias, new Type[]{keyType}));
        }
        if (!valueType.getName().equals("value")) {
            throw new RuntimeException(valueType.getName() + " should be value");
        }
        return MapKeyValuesSchemaConverter.mapKeyValueWrapper(repetition, alias, (Type)new GroupType(Type.Repetition.REPEATED, mapAlias, new Type[]{keyType, valueType}));
    }

    private static GroupType mapKeyValueWrapper(Type.Repetition repetition, String alias, Type nested) {
        if (!nested.isRepetition(Type.Repetition.REPEATED)) {
            throw new IllegalArgumentException("Nested type should be repeated: " + String.valueOf(nested));
        }
        return (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.MapKeyValueTypeAnnotation.getInstance())).addField(nested)).named(alias);
    }

    private static GroupType listWrapper(String name, GroupType groupType) {
        return (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)Types.optionalGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)groupType)).named(name);
    }
}

