/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.projection;

import io.airlift.slice.Slices;
import io.trino.plugin.hive.projection.InjectedProjection;
import io.trino.plugin.hive.projection.InvalidProjectionException;
import io.trino.plugin.hive.projection.Projection;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestInjectedProjectionFactory {
    TestInjectedProjectionFactory() {
    }

    @Test
    void testIsSupported() {
        new InjectedProjection("test", (Type)VarcharType.VARCHAR);
        new InjectedProjection("test", (Type)CharType.createCharType((int)10));
        new InjectedProjection("test", (Type)BigintType.BIGINT);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new InjectedProjection("test", (Type)TimestampType.TIMESTAMP_SECONDS)).isInstanceOf(InvalidProjectionException.class)).hasMessage("Column projection for column 'test' failed. Unsupported column type: timestamp(0)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new InjectedProjection("test", (Type)TimestampType.TIMESTAMP_PICOS)).isInstanceOf(InvalidProjectionException.class)).hasMessage("Column projection for column 'test' failed. Unsupported column type: timestamp(12)");
    }

    @Test
    void testCreate() {
        InjectedProjection projection = new InjectedProjection("test", (Type)VarcharType.VARCHAR);
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b"))))).containsExactly((Object[])new String[]{"b"});
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"x"))))).containsExactly((Object[])new String[]{"x"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestInjectedProjectionFactory.lambda$testCreate$0((Projection)projection)).isInstanceOf(InvalidProjectionException.class)).hasMessage("Column projection for column 'test' failed. Injected projection requires single predicate for it's column in where clause");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestInjectedProjectionFactory.lambda$testCreate$1((Projection)projection)).isInstanceOf(InvalidProjectionException.class)).hasMessage("Column projection for column 'test' failed. Injected projection requires single predicate for it's column in where clause. Currently provided can't be converted to single partition.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestInjectedProjectionFactory.lambda$testCreate$2((Projection)projection)).isInstanceOf(InvalidProjectionException.class)).hasMessage("Column projection for column 'test' failed. Injected projection requires single predicate for it's column in where clause. Currently provided can't be converted to single partition.");
    }

    private static /* synthetic */ void lambda$testCreate$2(Projection projection) throws Throwable {
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.none((Type)VarcharType.VARCHAR)))).isEmpty();
    }

    private static /* synthetic */ void lambda$testCreate$1(Projection projection) throws Throwable {
        Assertions.assertThat((List)projection.getProjectedValues(Optional.of(Domain.all((Type)VarcharType.VARCHAR)))).containsExactly((Object[])new String[]{"a", "b", "c"});
    }

    private static /* synthetic */ void lambda$testCreate$0(Projection projection) throws Throwable {
        Assertions.assertThat((List)projection.getProjectedValues(Optional.empty())).containsExactly((Object[])new String[]{"a", "b", "c"});
    }
}

