/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import io.airlift.units.DataSize;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.trino.Session;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.containers.Minio;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestS3FileSystemAccessOperations
extends AbstractTestQueryFramework {
    private static final String BUCKET = "test-bucket";
    private Minio minio;

    protected QueryRunner createQueryRunner() throws Exception {
        this.minio = (Minio)this.closeAfterClass((AutoCloseable)Minio.builder().build());
        this.minio.start();
        this.minio.createBucket(BUCKET);
        return ((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder().setHiveProperties((Map<String, String>)ImmutableMap.builder().put((Object)"hive.metastore.disable-location-checks", (Object)"true").put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)this.minio.getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"hive.non-managed-table-writes-enabled", (Object)"true").put((Object)"hive.metastore", (Object)"file").put((Object)"hive.metastore.catalog.dir", (Object)"s3://%s/catalog".formatted(BUCKET)).buildOrThrow()).setInitialSchemasLocationBase("s3://test-bucket"))).build();
    }

    @AfterAll
    public void tearDown() {
        this.minio = null;
    }

    @Test
    public void testSelectWithFilter() {
        for (StorageFormat format : StorageFormat.values()) {
            this.assertUpdate("DROP TABLE IF EXISTS test_select_from_where");
            String tableLocation = TestS3FileSystemAccessOperations.randomTableLocation("test_select_from_where");
            this.assertUpdate("CREATE TABLE test_select_from_where WITH (format = '" + String.valueOf((Object)format) + "', external_location = '" + tableLocation + "') AS SELECT 2 AS age", 1L);
            this.assertFileSystemAccesses(TestS3FileSystemAccessOperations.withSmallFileThreshold(this.getSession(), DataSize.valueOf((String)"1MB")), "SELECT * FROM test_select_from_where WHERE age = 2", (Multiset<String>)ImmutableMultiset.builder().add((Object)"S3.GetObject").add((Object)"S3.ListObjectsV2").build());
            this.assertFileSystemAccesses(TestS3FileSystemAccessOperations.withSmallFileThreshold(this.getSession(), DataSize.valueOf((String)"10B")), "SELECT * FROM test_select_from_where WHERE age = 2", (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"S3.GetObject", TestS3FileSystemAccessOperations.occurrences(format, 3, 2)).add((Object)"S3.ListObjectsV2").build());
            this.assertUpdate("DROP TABLE test_select_from_where");
        }
    }

    @Test
    public void testSelectPartitionTable() {
        for (StorageFormat format : StorageFormat.values()) {
            this.assertUpdate("DROP TABLE IF EXISTS test_select_from_partition");
            String tableLocation = TestS3FileSystemAccessOperations.randomTableLocation("test_select_from_partition");
            this.assertUpdate("CREATE TABLE test_select_from_partition (data int, key varchar)WITH (partitioned_by = ARRAY['key'], format = '" + String.valueOf((Object)format) + "', external_location = '" + tableLocation + "')");
            this.assertUpdate("INSERT INTO test_select_from_partition VALUES (1, 'part1'), (2, 'part2')", 2L);
            this.assertFileSystemAccesses("SELECT * FROM test_select_from_partition", (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"S3.GetObject", 2).addCopies((Object)"S3.ListObjectsV2", 2).build());
            this.assertFileSystemAccesses("SELECT * FROM test_select_from_partition WHERE key = 'part1'", (Multiset<String>)ImmutableMultiset.builder().add((Object)"S3.GetObject").add((Object)"S3.ListObjectsV2").build());
            this.assertUpdate("INSERT INTO test_select_from_partition VALUES (11, 'part1')", 1L);
            this.assertFileSystemAccesses("SELECT * FROM test_select_from_partition WHERE key = 'part1'", (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"S3.GetObject", 2).addCopies((Object)"S3.ListObjectsV2", 1).build());
            this.assertUpdate("DROP TABLE test_select_from_partition");
        }
    }

    private static String randomTableLocation(String tableName) {
        return "s3://%s/%s/%s-%s".formatted(BUCKET, "tpch", tableName, TestingNames.randomNameSuffix());
    }

    private void assertFileSystemAccesses(@Language(value="SQL") String query, Multiset<String> expectedAccesses) {
        this.assertFileSystemAccesses(this.getDistributedQueryRunner().getDefaultSession(), query, expectedAccesses);
    }

    private void assertFileSystemAccesses(Session session, @Language(value="SQL") String query, Multiset<String> expectedAccesses) {
        DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
        queryRunner.executeWithPlan(session, query);
        MultisetAssertions.assertMultisetsEqual(TestS3FileSystemAccessOperations.getOperations(queryRunner.getSpans()), expectedAccesses);
    }

    private static Multiset<String> getOperations(List<SpanData> items) {
        ImmutableMap spansById = Maps.uniqueIndex(items, SpanData::getSpanId);
        return (Multiset)items.stream().filter(span -> span.getName().startsWith("S3.")).filter(arg_0 -> TestS3FileSystemAccessOperations.lambda$getOperations$1((Map)spansById, arg_0)).map(SpanData::getName).collect(Collectors.toCollection(HashMultiset::create));
    }

    private static boolean hasAncestor(SpanData span, Map<String, SpanData> spansById, Predicate<SpanData> predicate) {
        SpanData parent;
        while ((parent = spansById.get(span.getParentSpanId())) != null) {
            if (predicate.test(parent)) {
                return true;
            }
            span = parent;
        }
        return false;
    }

    private static int occurrences(StorageFormat tableType, int orcValue, int parquetValue) {
        Preconditions.checkArgument((orcValue != parquetValue ? 1 : 0) != 0, (Object)"No need to use Occurrences when ORC and Parquet");
        return switch (tableType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> orcValue;
            case 1 -> parquetValue;
        };
    }

    private static Session withSmallFileThreshold(Session session, DataSize sizeThreshold) {
        String catalog = (String)session.getCatalog().orElseThrow();
        return Session.builder((Session)session).setCatalogSessionProperty(catalog, "parquet_small_file_threshold", sizeThreshold.toString()).setCatalogSessionProperty(catalog, "orc_tiny_stripe_threshold", sizeThreshold.toString()).build();
    }

    private static /* synthetic */ boolean lambda$getOperations$1(Map spansById, SpanData span) {
        return !TestS3FileSystemAccessOperations.hasAncestor(span, spansById, parent -> parent.getName().startsWith("HiveMetastore."));
    }

    static enum StorageFormat {
        ORC,
        PARQUET;

    }
}

