/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.statistics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metastore.DateStatistics;
import io.trino.metastore.DecimalStatistics;
import io.trino.metastore.DoubleStatistics;
import io.trino.metastore.HiveBasicStatistics;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.HivePartition;
import io.trino.metastore.HiveType;
import io.trino.metastore.IntegerStatistics;
import io.trino.metastore.PartitionStatistics;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.statistics.AbstractHiveStatisticsProvider;
import io.trino.plugin.hive.statistics.HiveStatisticsProvider;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.DoubleRange;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMetastoreHiveStatisticsProvider {
    private static final SchemaTableName TABLE = new SchemaTableName("schema", "table");
    private static final String PARTITION = "partition";
    private static final String COLUMN = "column";
    private static final DecimalType DECIMAL = DecimalType.createDecimalType((int)5, (int)3);
    private static final HiveColumnHandle PARTITION_COLUMN_1 = HiveColumnHandle.createBaseColumn((String)"p1", (int)0, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
    private static final HiveColumnHandle PARTITION_COLUMN_2 = HiveColumnHandle.createBaseColumn((String)"p2", (int)1, (HiveType)HiveType.HIVE_LONG, (Type)BigintType.BIGINT, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());

    @Test
    public void testGetPartitionsSample() {
        HivePartition p1 = TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234");
        HivePartition p2 = TestMetastoreHiveStatisticsProvider.partition("p1=string2/p2=2345");
        HivePartition p3 = TestMetastoreHiveStatisticsProvider.partition("p1=string3/p2=3456");
        HivePartition p4 = TestMetastoreHiveStatisticsProvider.partition("p1=string4/p2=4567");
        HivePartition p5 = TestMetastoreHiveStatisticsProvider.partition("p1=string5/p2=5678");
        Assertions.assertThat((List)AbstractHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1), (int)1)).isEqualTo((Object)ImmutableList.of((Object)p1));
        Assertions.assertThat((List)AbstractHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1), (int)2)).isEqualTo((Object)ImmutableList.of((Object)p1));
        Assertions.assertThat((List)AbstractHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1, (Object)p2), (int)2)).isEqualTo((Object)ImmutableList.of((Object)p1, (Object)p2));
        Assertions.assertThat((List)AbstractHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1, (Object)p2, (Object)p3), (int)2)).isEqualTo((Object)ImmutableList.of((Object)p1, (Object)p3));
        Assertions.assertThat((List)AbstractHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1, (Object)p2, (Object)p3, (Object)p4), (int)1)).isEqualTo((Object)AbstractHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1, (Object)p2, (Object)p3, (Object)p4), (int)1));
        Assertions.assertThat((List)AbstractHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1, (Object)p2, (Object)p3, (Object)p4), (int)3)).isEqualTo((Object)AbstractHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1, (Object)p2, (Object)p3, (Object)p4), (int)3));
        Assertions.assertThat((List)AbstractHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1, (Object)p2, (Object)p3, (Object)p4, (Object)p5), (int)3)).isEqualTo((Object)ImmutableList.of((Object)p1, (Object)p5, (Object)p4));
    }

    @Test
    public void testValidatePartitionStatistics() {
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(-1L, 0L, 0L, 0L)).build(), TestMetastoreHiveStatisticsProvider.invalidPartitionStatistics("fileCount must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, -1L, 0L, 0L)).build(), TestMetastoreHiveStatisticsProvider.invalidPartitionStatistics("rowCount must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, -1L, 0L)).build(), TestMetastoreHiveStatisticsProvider.invalidPartitionStatistics("inMemoryDataSizeInBytes must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, -1L)).build(), TestMetastoreHiveStatisticsProvider.invalidPartitionStatistics("onDiskDataSizeInBytes must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setMaxValueSizeInBytes(-1L).build())).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("maxValueSizeInBytes must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setAverageColumnLength(-1.0).build())).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("averageColumnLength must be greater than or equal to zero: -1.0"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setNullsCount(-1L).build())).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("nullsCount must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setNullsCount(1L).build())).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("nullsCount must be less than or equal to rowCount. nullsCount: 1. rowCount: 0."));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setDistinctValuesWithNullCount(-1L).build())).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("distinctValuesCount must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(-1L), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("integerStatistics.min must be less than or equal to integerStatistics.max. integerStatistics.min: 1. integerStatistics.max: -1."));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(1.0), (OptionalDouble)OptionalDouble.of(-1.0), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("doubleStatistics.min must be less than or equal to doubleStatistics.max. doubleStatistics.min: 1.0. doubleStatistics.max: -1.0."));
        AbstractHiveStatisticsProvider.validatePartitionStatistics((SchemaTableName)TABLE, (Map)ImmutableMap.of((Object)PARTITION, (Object)PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(Double.NaN), (OptionalDouble)OptionalDouble.of(Double.NaN), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build()));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createDecimalColumnStatistics(Optional.of(BigDecimal.valueOf(1L)), Optional.of(BigDecimal.valueOf(-1L)), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("decimalStatistics.min must be less than or equal to decimalStatistics.max. decimalStatistics.min: 1. decimalStatistics.max: -1."));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createDateColumnStatistics(Optional.of(LocalDate.ofEpochDay(1L)), Optional.of(LocalDate.ofEpochDay(-1L)), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("dateStatistics.min must be less than or equal to dateStatistics.max. dateStatistics.min: 1970-01-02. dateStatistics.max: 1969-12-31."));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(-1L), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("trueCount must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(-1L), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("falseCount must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("booleanStatistics.trueCount must be less than or equal to rowCount. booleanStatistics.trueCount: 1. rowCount: 0."));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("booleanStatistics.falseCount must be less than or equal to rowCount. booleanStatistics.falseCount: 1. rowCount: 0."));
    }

    @Test
    public void testCalculatePartitionsRowCount() {
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculatePartitionsRowCount((Collection)ImmutableList.of(), (int)0)).isEmpty();
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculatePartitionsRowCount((Collection)ImmutableList.of((Object)PartitionStatistics.empty()), (int)1)).isEmpty();
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculatePartitionsRowCount((Collection)ImmutableList.of((Object)PartitionStatistics.empty(), (Object)PartitionStatistics.empty()), (int)2)).isEmpty();
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculatePartitionsRowCount((Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(10L)), (int)1)).isEqualTo(Optional.of(new AbstractHiveStatisticsProvider.PartitionsRowCount(10.0, 10.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculatePartitionsRowCount((Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(10L)), (int)2)).isEqualTo(Optional.of(new AbstractHiveStatisticsProvider.PartitionsRowCount(10.0, 20.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculatePartitionsRowCount((Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(10L), (Object)PartitionStatistics.empty()), (int)2)).isEqualTo(Optional.of(new AbstractHiveStatisticsProvider.PartitionsRowCount(10.0, 20.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculatePartitionsRowCount((Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(10L), (Object)TestMetastoreHiveStatisticsProvider.rowsCount(20L)), (int)2)).isEqualTo(Optional.of(new AbstractHiveStatisticsProvider.PartitionsRowCount(15.0, 30.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculatePartitionsRowCount((Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(10L), (Object)TestMetastoreHiveStatisticsProvider.rowsCount(20L)), (int)3)).isEqualTo(Optional.of(new AbstractHiveStatisticsProvider.PartitionsRowCount(15.0, 45.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculatePartitionsRowCount((Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(10L), (Object)TestMetastoreHiveStatisticsProvider.rowsCount(20L), (Object)PartitionStatistics.empty()), (int)3)).isEqualTo(Optional.of(new AbstractHiveStatisticsProvider.PartitionsRowCount(15.0, 45.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculatePartitionsRowCount((Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(10L), (Object)TestMetastoreHiveStatisticsProvider.rowsCount(100L), (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (int)3)).isEqualTo(Optional.of(new AbstractHiveStatisticsProvider.PartitionsRowCount(370.0, 1110.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculatePartitionsRowCount((Collection)ImmutableList.builder().addAll(Collections.nCopies(10, TestMetastoreHiveStatisticsProvider.rowsCount(100L))).add((Object)TestMetastoreHiveStatisticsProvider.rowsCount(1L)).add((Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)).build(), (int)50)).isEqualTo(Optional.of(new AbstractHiveStatisticsProvider.PartitionsRowCount(100.0, 5801.0)));
    }

    @Test
    public void testCalculateDistinctPartitionKeys() {
        Assertions.assertThat((long)AbstractHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of())).isEqualTo(0L);
        Assertions.assertThat((long)AbstractHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234")))).isEqualTo(1L);
        Assertions.assertThat((long)AbstractHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string2/p2=1234")))).isEqualTo(2L);
        Assertions.assertThat((long)AbstractHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_2, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string2/p2=1234")))).isEqualTo(1L);
        Assertions.assertThat((long)AbstractHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_2, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1235")))).isEqualTo(2L);
        Assertions.assertThat((long)AbstractHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1235")))).isEqualTo(1L);
        Assertions.assertThat((long)AbstractHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_2, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=123/p2=__HIVE_DEFAULT_PARTITION__"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1235")))).isEqualTo(1L);
        Assertions.assertThat((long)AbstractHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_2, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=123/p2=__HIVE_DEFAULT_PARTITION__"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=__HIVE_DEFAULT_PARTITION__")))).isEqualTo(0L);
    }

    @Test
    public void testCalculateNullsFractionForPartitioningKey() {
        Assertions.assertThat((double)AbstractHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234")), (Map)ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (double)2000.0, (double)0.0)).isEqualTo(0.0);
        Assertions.assertThat((double)AbstractHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234")), (Map)ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (double)2000.0, (double)4000.0)).isEqualTo(0.0);
        Assertions.assertThat((double)AbstractHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234")), (Map)ImmutableMap.of((Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (double)2000.0, (double)4000.0)).isEqualTo(0.25);
        Assertions.assertThat((double)AbstractHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234")), (Map)ImmutableMap.of((Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=1234", (Object)PartitionStatistics.empty()), (double)2000.0, (double)4000.0)).isEqualTo(0.5);
        Assertions.assertThat((double)AbstractHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234")), (Map)ImmutableMap.of(), (double)2000.0, (double)4000.0)).isEqualTo(0.5);
        Assertions.assertThat((double)AbstractHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=4321")), (Map)ImmutableMap.of((Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L), (Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=4321", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(2000L)), (double)3000.0, (double)4000.0)).isEqualTo(0.75);
        Assertions.assertThat((double)AbstractHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=4321")), (Map)ImmutableMap.of((Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L), (Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=4321", (Object)PartitionStatistics.empty()), (double)3000.0, (double)4000.0)).isEqualTo(1.0);
        Assertions.assertThat((double)AbstractHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=4321")), (Map)ImmutableMap.of((Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L), (Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=4321", (Object)PartitionStatistics.empty()), (double)4000.0, (double)4000.0)).isEqualTo(1.0);
    }

    @Test
    public void testCalculateDataSizeForPartitioningKey() {
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSizeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_2, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234")), (Map)ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (double)2000.0)).isEqualTo((Object)Estimate.unknown());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSizeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234")), (Map)ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (double)2000.0)).isEqualTo((Object)Estimate.of((double)7000.0));
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSizeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234")), (Map)ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)PartitionStatistics.empty()), (double)2000.0)).isEqualTo((Object)Estimate.of((double)14000.0));
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSizeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=str2/p2=1234")), (Map)ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L), (Object)"p1=str2/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(2000L)), (double)3000.0)).isEqualTo((Object)Estimate.of((double)15000.0));
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSizeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=str2/p2=1234")), (Map)ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L), (Object)"p1=str2/p2=1234", (Object)PartitionStatistics.empty()), (double)3000.0)).isEqualTo((Object)Estimate.of((double)19000.0));
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSizeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=str2/p2=1234")), (Map)ImmutableMap.of(), (double)3000.0)).isEqualTo((Object)Estimate.of((double)33000.0));
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSizeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=str2/p2=1234")), (Map)ImmutableMap.of(), (double)3000.0)).isEqualTo((Object)Estimate.of((double)12000.0));
    }

    @Test
    public void testCalculateRangeForPartitioningKey() {
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRangeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234")))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRangeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_2, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=__HIVE_DEFAULT_PARTITION__")))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRangeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_2, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=__HIVE_DEFAULT_PARTITION__"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=__HIVE_DEFAULT_PARTITION__")))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRangeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_2, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=__HIVE_DEFAULT_PARTITION__"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1")))).isEqualTo(Optional.of(new DoubleRange(1.0, 1.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRangeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_2, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=2"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1")))).isEqualTo(Optional.of(new DoubleRange(1.0, 2.0)));
    }

    @Test
    public void testConvertPartitionValueToDouble() {
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)BigintType.BIGINT, "123456", 123456.0);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)IntegerType.INTEGER, "12345", 12345.0);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)SmallintType.SMALLINT, "1234", 1234.0);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)TinyintType.TINYINT, "123", 123.0);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)DoubleType.DOUBLE, "0.1", 0.1);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)RealType.REAL, "0.2", 0.2f);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)DecimalType.createDecimalType((int)5, (int)2), "123.45", 123.45);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)DecimalType.createDecimalType((int)25, (int)5), "12345678901234567890.12345", 1.2345678901234567E19);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)DateType.DATE, "1970-01-02", 1.0);
    }

    private static void assertConvertPartitionValueToDouble(Type type, String value, double expected) {
        Object trinoValue = HiveUtil.parsePartitionValue((String)String.format("p=%s", value), (String)value, (Type)type).getValue();
        Assertions.assertThat((OptionalDouble)AbstractHiveStatisticsProvider.convertPartitionValueToDouble((Type)type, (Object)trinoValue)).isEqualTo((Object)OptionalDouble.of(expected));
    }

    @Test
    public void testCreateDataColumnStatistics() {
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.createDataColumnStatistics((String)COLUMN, (Type)BigintType.BIGINT, (double)1000.0, (Collection)ImmutableList.of())).isEqualTo((Object)ColumnStatistics.empty());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.createDataColumnStatistics((String)COLUMN, (Type)BigintType.BIGINT, (double)1000.0, (Collection)ImmutableList.of((Object)PartitionStatistics.empty(), (Object)PartitionStatistics.empty()))).isEqualTo((Object)ColumnStatistics.empty());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.createDataColumnStatistics((String)COLUMN, (Type)BigintType.BIGINT, (double)1000.0, (Collection)ImmutableList.of((Object)new PartitionStatistics(HiveBasicStatistics.createZeroStatistics(), (Map)ImmutableMap.of((Object)"column2", (Object)HiveColumnStatistics.empty()))))).isEqualTo((Object)ColumnStatistics.empty());
    }

    @Test
    public void testCalculateDistinctValuesCount() {
        Assertions.assertThat((OptionalLong)AbstractHiveStatisticsProvider.getDistinctValuesCount((String)COLUMN, (PartitionStatistics)PartitionStatistics.empty())).isEmpty();
        Assertions.assertThat((OptionalLong)AbstractHiveStatisticsProvider.getDistinctValuesCount((String)COLUMN, (PartitionStatistics)TestMetastoreHiveStatisticsProvider.distinctValuesCount(1L))).hasValue(1L);
        Assertions.assertThat((OptionalLong)AbstractHiveStatisticsProvider.getDistinctValuesCount((String)COLUMN, (PartitionStatistics)new PartitionStatistics(new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(10L), OptionalLong.empty(), OptionalLong.empty()), (Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setNullsCount(3L).setDistinctValuesWithNullCount(5L).build())))).hasValue(4L);
        Assertions.assertThat((OptionalLong)AbstractHiveStatisticsProvider.getDistinctValuesCount((String)COLUMN, (PartitionStatistics)new PartitionStatistics(new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(10L), OptionalLong.empty(), OptionalLong.empty()), (Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setNullsCount(3L).setDistinctValuesWithNullCount(1L).build())))).hasValue(1L);
        Assertions.assertThat((OptionalLong)AbstractHiveStatisticsProvider.getDistinctValuesCount((String)COLUMN, (PartitionStatistics)new PartitionStatistics(new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(5L), OptionalLong.empty(), OptionalLong.empty()), (Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setDistinctValuesWithNullCount(10L).build())))).hasValue(5L);
        Assertions.assertThat((OptionalLong)AbstractHiveStatisticsProvider.getDistinctValuesCount((String)COLUMN, (PartitionStatistics)new PartitionStatistics(new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(5L), OptionalLong.empty(), OptionalLong.empty()), (Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setNullsCount(3L).setDistinctValuesWithNullCount(10L).build())))).hasValue(2L);
        Assertions.assertThat((OptionalLong)AbstractHiveStatisticsProvider.getDistinctValuesCount((String)COLUMN, (PartitionStatistics)TestMetastoreHiveStatisticsProvider.booleanDistinctValuesCount(OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty()))).isEmpty();
        Assertions.assertThat((OptionalLong)AbstractHiveStatisticsProvider.getDistinctValuesCount((String)COLUMN, (PartitionStatistics)TestMetastoreHiveStatisticsProvider.booleanDistinctValuesCount(OptionalLong.of(1L), OptionalLong.of(0L), OptionalLong.empty()))).hasValue(1L);
        Assertions.assertThat((OptionalLong)AbstractHiveStatisticsProvider.getDistinctValuesCount((String)COLUMN, (PartitionStatistics)TestMetastoreHiveStatisticsProvider.booleanDistinctValuesCount(OptionalLong.of(10L), OptionalLong.empty(), OptionalLong.empty()))).isEmpty();
        Assertions.assertThat((OptionalLong)AbstractHiveStatisticsProvider.getDistinctValuesCount((String)COLUMN, (PartitionStatistics)TestMetastoreHiveStatisticsProvider.booleanDistinctValuesCount(OptionalLong.of(10L), OptionalLong.of(10L), OptionalLong.empty()))).hasValue(2L);
        Assertions.assertThat((OptionalLong)AbstractHiveStatisticsProvider.getDistinctValuesCount((String)COLUMN, (PartitionStatistics)TestMetastoreHiveStatisticsProvider.booleanDistinctValuesCount(OptionalLong.empty(), OptionalLong.of(10L), OptionalLong.empty()))).isEmpty();
        Assertions.assertThat((OptionalLong)AbstractHiveStatisticsProvider.getDistinctValuesCount((String)COLUMN, (PartitionStatistics)TestMetastoreHiveStatisticsProvider.booleanDistinctValuesCount(OptionalLong.of(0L), OptionalLong.of(10L), OptionalLong.empty()))).hasValue(1L);
        Assertions.assertThat((OptionalLong)AbstractHiveStatisticsProvider.getDistinctValuesCount((String)COLUMN, (PartitionStatistics)TestMetastoreHiveStatisticsProvider.booleanDistinctValuesCount(OptionalLong.of(0L), OptionalLong.of(0L), OptionalLong.empty()))).hasValue(0L);
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDistinctValuesCount((String)COLUMN, (Collection)ImmutableList.of())).isEqualTo((Object)Estimate.unknown());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDistinctValuesCount((String)COLUMN, (Collection)ImmutableList.of((Object)PartitionStatistics.empty(), (Object)PartitionStatistics.empty()))).isEqualTo((Object)Estimate.unknown());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDistinctValuesCount((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.distinctValuesCount(1L), (Object)TestMetastoreHiveStatisticsProvider.distinctValuesCount(2L)))).isEqualTo((Object)Estimate.of((double)2.0));
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDistinctValuesCount((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.distinctValuesCount(1L), (Object)PartitionStatistics.empty()))).isEqualTo((Object)Estimate.of((double)1.0));
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDistinctValuesCount((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.booleanDistinctValuesCount(OptionalLong.of(0L), OptionalLong.of(10L), OptionalLong.empty()), (Object)TestMetastoreHiveStatisticsProvider.booleanDistinctValuesCount(OptionalLong.of(1L), OptionalLong.of(10L), OptionalLong.empty())))).isEqualTo((Object)Estimate.of((double)2.0));
    }

    @Test
    public void testCalculateNullsFraction() {
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateNullsFraction((String)COLUMN, (Collection)ImmutableList.of())).isEqualTo((Object)Estimate.unknown());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateNullsFraction((String)COLUMN, (Collection)ImmutableList.of((Object)PartitionStatistics.empty()))).isEqualTo((Object)Estimate.unknown());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateNullsFraction((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)))).isEqualTo((Object)Estimate.unknown());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateNullsFraction((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L), (Object)TestMetastoreHiveStatisticsProvider.nullsCount(500L)))).isEqualTo((Object)Estimate.unknown());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateNullsFraction((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L), (Object)TestMetastoreHiveStatisticsProvider.nullsCount(500L), (Object)TestMetastoreHiveStatisticsProvider.rowsCountAndNullsCount(1000L, 500L)))).isEqualTo((Object)Estimate.of((double)0.5));
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateNullsFraction((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCountAndNullsCount(2000L, 200L), (Object)TestMetastoreHiveStatisticsProvider.rowsCountAndNullsCount(1000L, 100L)))).isEqualTo((Object)Estimate.of((double)0.1));
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateNullsFraction((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCountAndNullsCount(0L, 0L), (Object)TestMetastoreHiveStatisticsProvider.rowsCountAndNullsCount(0L, 0L)))).isEqualTo((Object)Estimate.of((double)0.0));
    }

    @Test
    public void testCalculateDataSize() {
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of(), (double)0.0)).isEqualTo((Object)Estimate.unknown());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of(), (double)1000.0)).isEqualTo((Object)Estimate.unknown());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)PartitionStatistics.empty()), (double)1000.0)).isEqualTo((Object)Estimate.unknown());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (double)1000.0)).isEqualTo((Object)Estimate.unknown());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.dataSize(1000L)), (double)1000.0)).isEqualTo((Object)Estimate.unknown());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.dataSize(1000L), (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (double)1000.0)).isEqualTo((Object)Estimate.unknown());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(500L, 2L)), (double)2000.0)).isEqualTo((Object)Estimate.of((double)4000.0));
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(0L, 0L)), (double)2000.0)).isEqualTo((Object)Estimate.unknown());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(0L, 0L)), (double)0.0)).isEqualTo((Object)Estimate.zero());
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(1000L, 0L)), (double)2000.0)).isEqualTo((Object)Estimate.of((double)0.0));
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(500L, 2L), (Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(1000L, 5L)), (double)5000.0)).isEqualTo((Object)Estimate.of((double)20000.0));
        Assertions.assertThat((Object)AbstractHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.dataSize(1000L), (Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(500L, 2L), (Object)TestMetastoreHiveStatisticsProvider.rowsCount(3000L), (Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(1000L, 5L)), (double)5000.0)).isEqualTo((Object)Estimate.of((double)20000.0));
    }

    @Test
    public void testCalculateRange() {
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)VarcharType.VARCHAR, (List)ImmutableList.of())).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(OptionalLong.empty(), OptionalLong.empty())))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(1L, 2L)))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(1L, 2L)))).isEqualTo(Optional.of(new DoubleRange(1.0, 2.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(Long.MIN_VALUE, Long.MAX_VALUE)))).isEqualTo(Optional.of(new DoubleRange(-9.223372036854776E18, 9.223372036854776E18)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(Long.MIN_VALUE, Long.MAX_VALUE)))).isEqualTo(Optional.of(new DoubleRange(-2.147483648E9, 2.147483647E9)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)SmallintType.SMALLINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(Long.MIN_VALUE, Long.MAX_VALUE)))).isEqualTo(Optional.of(new DoubleRange(-32768.0, 32767.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)TinyintType.TINYINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(Long.MIN_VALUE, Long.MAX_VALUE)))).isEqualTo(Optional.of(new DoubleRange(-128.0, 127.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(1L, 5L), (Object)TestMetastoreHiveStatisticsProvider.integerRange(3L, 7L)))).isEqualTo(Optional.of(new DoubleRange(1.0, 7.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(OptionalLong.empty(), OptionalLong.empty()), (Object)TestMetastoreHiveStatisticsProvider.integerRange(3L, 7L)))).isEqualTo(Optional.of(new DoubleRange(3.0, 7.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(OptionalLong.empty(), OptionalLong.of(8L)), (Object)TestMetastoreHiveStatisticsProvider.integerRange(3L, 7L)))).isEqualTo(Optional.of(new DoubleRange(3.0, 7.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(1L, 2L)))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)RealType.REAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(1L, 2L)))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(OptionalDouble.empty(), OptionalDouble.empty())))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, 0.2)))).isEqualTo(Optional.of(new DoubleRange(0.1, 0.2)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, 0.2)))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, 0.2), (Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.15, 0.25)))).isEqualTo(Optional.of(new DoubleRange(0.1, 0.25)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)RealType.REAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, 0.2), (Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.15, 0.25)))).isEqualTo(Optional.of(new DoubleRange(0.1, 0.25)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)RealType.REAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(OptionalDouble.empty(), OptionalDouble.of(0.2)), (Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.15, 0.25)))).isEqualTo(Optional.of(new DoubleRange(0.15, 0.25)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(Double.NaN, 0.2)))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, Double.NaN)))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(Double.NaN, Double.NaN)))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)))).isEqualTo(Optional.of(new DoubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)RealType.REAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)))).isEqualTo(Optional.of(new DoubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)))).isEqualTo(Optional.of(new DoubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), (Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, 0.2)))).isEqualTo(Optional.of(new DoubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DateType.DATE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, 0.2)))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DateType.DATE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.dateRange("1970-01-01", "1970-01-02")))).isEqualTo(Optional.of(new DoubleRange(0.0, 1.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DateType.DATE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.dateRange(Optional.empty(), Optional.empty())))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DateType.DATE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.dateRange(Optional.of("1970-01-01"), Optional.empty())))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DateType.DATE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.dateRange("1970-01-01", "1970-01-05"), (Object)TestMetastoreHiveStatisticsProvider.dateRange("1970-01-03", "1970-01-07")))).isEqualTo(Optional.of(new DoubleRange(0.0, 6.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DECIMAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, 0.2)))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DECIMAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.decimalRange(BigDecimal.valueOf(1L), BigDecimal.valueOf(5L))))).isEqualTo(Optional.of(new DoubleRange(1.0, 5.0)));
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DECIMAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.decimalRange(Optional.empty(), Optional.empty())))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DECIMAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.decimalRange(Optional.of(BigDecimal.valueOf(1L)), Optional.empty())))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)AbstractHiveStatisticsProvider.calculateRange((Type)DECIMAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.decimalRange(BigDecimal.valueOf(1L), BigDecimal.valueOf(5L)), (Object)TestMetastoreHiveStatisticsProvider.decimalRange(BigDecimal.valueOf(3L), BigDecimal.valueOf(7L))))).isEqualTo(Optional.of(new DoubleRange(1.0, 7.0)));
    }

    @Test
    public void testGetTableStatistics() {
        final String partitionName = "p1=string1/p2=1234";
        final PartitionStatistics statistics = PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(1000L), OptionalLong.empty(), OptionalLong.empty())).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(-100L), (OptionalLong)OptionalLong.of(100L), (OptionalLong)OptionalLong.of(500L), (OptionalLong)OptionalLong.of(301L)))).build();
        AbstractHiveStatisticsProvider statisticsProvider = new AbstractHiveStatisticsProvider(this){

            protected Map<String, PartitionStatistics> getPartitionsStatistics(ConnectorSession session, SchemaTableName table, List<HivePartition> hivePartitions, Set<String> columns) {
                return ImmutableMap.of((Object)partitionName, (Object)statistics);
            }
        };
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)COLUMN, (int)2, (HiveType)HiveType.HIVE_LONG, (Type)BigintType.BIGINT, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TableStatistics expected = TableStatistics.builder().setRowCount(Estimate.of((double)1000.0)).setColumnStatistics((ColumnHandle)PARTITION_COLUMN_1, ColumnStatistics.builder().setDataSize(Estimate.of((double)7000.0)).setNullsFraction(Estimate.of((double)0.0)).setDistinctValuesCount(Estimate.of((double)1.0)).build()).setColumnStatistics((ColumnHandle)PARTITION_COLUMN_2, ColumnStatistics.builder().setRange(new DoubleRange(1234.0, 1234.0)).setNullsFraction(Estimate.of((double)0.0)).setDistinctValuesCount(Estimate.of((double)1.0)).build()).setColumnStatistics((ColumnHandle)columnHandle, ColumnStatistics.builder().setRange(new DoubleRange(-100.0, 100.0)).setNullsFraction(Estimate.of((double)0.5)).setDistinctValuesCount(Estimate.of((double)300.0)).build()).build();
        Assertions.assertThat((Object)statisticsProvider.getTableStatistics(HiveTestUtils.SESSION, TABLE, (Map)ImmutableMap.of((Object)"p1", (Object)PARTITION_COLUMN_1, (Object)"p2", (Object)PARTITION_COLUMN_2, (Object)COLUMN, (Object)columnHandle), (Map)ImmutableMap.of((Object)"p1", (Object)VarcharType.VARCHAR, (Object)"p2", (Object)BigintType.BIGINT, (Object)COLUMN, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition(partitionName)))).isEqualTo((Object)expected);
    }

    @Test
    public void testGetTableStatisticsUnpartitioned() {
        final PartitionStatistics statistics = PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(1000L), OptionalLong.empty(), OptionalLong.empty())).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(-100L), (OptionalLong)OptionalLong.of(100L), (OptionalLong)OptionalLong.of(500L), (OptionalLong)OptionalLong.of(301L)))).build();
        AbstractHiveStatisticsProvider statisticsProvider = new AbstractHiveStatisticsProvider(this){

            protected Map<String, PartitionStatistics> getPartitionsStatistics(ConnectorSession session, SchemaTableName table, List<HivePartition> hivePartitions, Set<String> columns) {
                return ImmutableMap.of((Object)"<UNPARTITIONED>", (Object)statistics);
            }
        };
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)COLUMN, (int)2, (HiveType)HiveType.HIVE_LONG, (Type)BigintType.BIGINT, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TableStatistics expected = TableStatistics.builder().setRowCount(Estimate.of((double)1000.0)).setColumnStatistics((ColumnHandle)columnHandle, ColumnStatistics.builder().setRange(new DoubleRange(-100.0, 100.0)).setNullsFraction(Estimate.of((double)0.5)).setDistinctValuesCount(Estimate.of((double)300.0)).build()).build();
        Assertions.assertThat((Object)statisticsProvider.getTableStatistics(HiveTestUtils.SESSION, TABLE, (Map)ImmutableMap.of((Object)COLUMN, (Object)columnHandle), (Map)ImmutableMap.of((Object)COLUMN, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)new HivePartition(TABLE)))).isEqualTo((Object)expected);
    }

    @Test
    public void testGetTableStatisticsEmpty() {
        final String partitionName = "p1=string1/p2=1234";
        AbstractHiveStatisticsProvider statisticsProvider = new AbstractHiveStatisticsProvider(this){

            protected Map<String, PartitionStatistics> getPartitionsStatistics(ConnectorSession session, SchemaTableName table, List<HivePartition> hivePartitions, Set<String> columns) {
                return ImmutableMap.of((Object)partitionName, (Object)PartitionStatistics.empty());
            }
        };
        Assertions.assertThat((Object)statisticsProvider.getTableStatistics(HiveTestUtils.SESSION, TABLE, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition(partitionName)))).isEqualTo((Object)TableStatistics.empty());
    }

    @Test
    public void testGetTableStatisticsSampling() {
        AbstractHiveStatisticsProvider statisticsProvider = new AbstractHiveStatisticsProvider(this){

            protected Map<String, PartitionStatistics> getPartitionsStatistics(ConnectorSession session, SchemaTableName table, List<HivePartition> hivePartitions, Set<String> columns) {
                Assertions.assertThat((Object)table).isEqualTo((Object)TABLE);
                Assertions.assertThat(hivePartitions).hasSize(1);
                return ImmutableMap.of();
            }
        };
        ConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig().setPartitionStatisticsSampleSize(1));
        statisticsProvider.getTableStatistics(session, TABLE, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1235")));
    }

    @Test
    public void testGetTableStatisticsValidationFailure() {
        final PartitionStatistics corruptedStatistics = PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(-1L, 0L, 0L, 0L)).build();
        final String partitionName = "p1=string1/p2=1234";
        AbstractHiveStatisticsProvider statisticsProvider = new AbstractHiveStatisticsProvider(this){

            protected Map<String, PartitionStatistics> getPartitionsStatistics(ConnectorSession session, SchemaTableName table, List<HivePartition> hivePartitions, Set<String> columns) {
                return ImmutableMap.of((Object)partitionName, (Object)corruptedStatistics);
            }
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestMetastoreHiveStatisticsProvider.lambda$testGetTableStatisticsValidationFailure$0((HiveStatisticsProvider)statisticsProvider, partitionName)).isInstanceOf(TrinoException.class)).hasFieldOrPropertyWithValue("errorCode", (Object)HiveErrorCode.HIVE_CORRUPTED_COLUMN_STATISTICS.toErrorCode());
        Assertions.assertThat((Object)statisticsProvider.getTableStatistics(HiveTestUtils.getHiveSession(new HiveConfig().setIgnoreCorruptedStatistics(true)), TABLE, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition(partitionName)))).isEqualTo((Object)TableStatistics.empty());
    }

    @Test
    public void testEmptyTableStatisticsForPartitionColumnsWhenStatsAreEmpty() {
        AbstractHiveStatisticsProvider statisticsProvider = new AbstractHiveStatisticsProvider(this){

            protected Map<String, PartitionStatistics> getPartitionsStatistics(ConnectorSession session, SchemaTableName table, List<HivePartition> hivePartitions, Set<String> columns) {
                return ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)PartitionStatistics.empty());
            }
        };
        this.testEmptyTableStatisticsForPartitionColumns((HiveStatisticsProvider)statisticsProvider);
    }

    @Test
    public void testEmptyTableStatisticsForPartitionColumnsWhenStatsAreMissing() {
        AbstractHiveStatisticsProvider statisticsProvider = new AbstractHiveStatisticsProvider(this){

            protected Map<String, PartitionStatistics> getPartitionsStatistics(ConnectorSession session, SchemaTableName table, List<HivePartition> hivePartitions, Set<String> columns) {
                return ImmutableMap.of();
            }
        };
        this.testEmptyTableStatisticsForPartitionColumns((HiveStatisticsProvider)statisticsProvider);
    }

    private void testEmptyTableStatisticsForPartitionColumns(HiveStatisticsProvider statisticsProvider) {
        String partitionName1 = "p1=string1/p2=1234";
        String partitionName2 = "p1=string2/p2=1235";
        String partitionName3 = "p1=string3/p2=1236";
        String partitionName4 = "p1=string4/p2=1237";
        String partitionName5 = String.format("p1=%s/p2=1237", "__HIVE_DEFAULT_PARTITION__");
        String partitionName6 = String.format("p1=string5/p2=%s", "__HIVE_DEFAULT_PARTITION__");
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)COLUMN, (int)2, (HiveType)HiveType.HIVE_LONG, (Type)BigintType.BIGINT, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TableStatistics expected = TableStatistics.builder().setColumnStatistics((ColumnHandle)PARTITION_COLUMN_1, ColumnStatistics.builder().setNullsFraction(Estimate.of((double)0.16666666666666666)).setDistinctValuesCount(Estimate.of((double)5.0)).build()).setColumnStatistics((ColumnHandle)PARTITION_COLUMN_2, ColumnStatistics.builder().setRange(new DoubleRange(1234.0, 1237.0)).setNullsFraction(Estimate.of((double)0.16666666666666666)).setDistinctValuesCount(Estimate.of((double)4.0)).build()).build();
        Assertions.assertThat((Object)statisticsProvider.getTableStatistics(HiveTestUtils.getHiveSession(new HiveConfig().setIgnoreCorruptedStatistics(true)), TABLE, (Map)ImmutableMap.of((Object)"p1", (Object)PARTITION_COLUMN_1, (Object)"p2", (Object)PARTITION_COLUMN_2, (Object)COLUMN, (Object)columnHandle), (Map)ImmutableMap.of((Object)"p1", (Object)VarcharType.VARCHAR, (Object)"p2", (Object)BigintType.BIGINT, (Object)COLUMN, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition(partitionName1), (Object)TestMetastoreHiveStatisticsProvider.partition(partitionName2), (Object)TestMetastoreHiveStatisticsProvider.partition(partitionName3), (Object)TestMetastoreHiveStatisticsProvider.partition(partitionName4), (Object)TestMetastoreHiveStatisticsProvider.partition(partitionName5), (Object)TestMetastoreHiveStatisticsProvider.partition(partitionName6)))).isEqualTo((Object)expected);
    }

    private static void assertInvalidStatistics(PartitionStatistics partitionStatistics, String expectedMessage) {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AbstractHiveStatisticsProvider.validatePartitionStatistics((SchemaTableName)TABLE, (Map)ImmutableMap.of((Object)PARTITION, (Object)partitionStatistics))).isInstanceOf(TrinoException.class)).hasFieldOrPropertyWithValue("errorCode", (Object)HiveErrorCode.HIVE_CORRUPTED_COLUMN_STATISTICS.toErrorCode())).hasMessage(expectedMessage);
    }

    private static String invalidPartitionStatistics(String message) {
        return String.format("Corrupted partition statistics (Table: %s Partition: [%s]): %s", TABLE, PARTITION, message);
    }

    private static String invalidColumnStatistics(String message) {
        return String.format("Corrupted partition statistics (Table: %s Partition: [%s] Column: %s): %s", TABLE, PARTITION, COLUMN, message);
    }

    private static HivePartition partition(String name) {
        return HivePartitionManager.parsePartition((SchemaTableName)TABLE, (String)name, (List)ImmutableList.of((Object)PARTITION_COLUMN_1, (Object)PARTITION_COLUMN_2));
    }

    private static PartitionStatistics rowsCount(long rowsCount) {
        return new PartitionStatistics(new HiveBasicStatistics(0L, rowsCount, 0L, 0L), (Map)ImmutableMap.of());
    }

    private static PartitionStatistics nullsCount(long nullsCount) {
        return new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setNullsCount(nullsCount).build()));
    }

    private static PartitionStatistics dataSize(long dataSize) {
        return new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setAverageColumnLength((double)dataSize).build()));
    }

    private static PartitionStatistics rowsCountAndNullsCount(long rowsCount, long nullsCount) {
        return new PartitionStatistics(new HiveBasicStatistics(0L, rowsCount, 0L, 0L), (Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setNullsCount(nullsCount).build()));
    }

    private static PartitionStatistics rowsCountAndDataSize(long rowsCount, long averageColumnLength) {
        return new PartitionStatistics(new HiveBasicStatistics(0L, rowsCount, 0L, 0L), (Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setAverageColumnLength((double)averageColumnLength).build()));
    }

    private static PartitionStatistics distinctValuesCount(long count) {
        return new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setDistinctValuesWithNullCount(count).build()));
    }

    private static PartitionStatistics booleanDistinctValuesCount(OptionalLong trueCount, OptionalLong falseCount, OptionalLong nullsCount) {
        return new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)trueCount, (OptionalLong)falseCount, (OptionalLong)nullsCount)));
    }

    private static HiveColumnStatistics integerRange(long min, long max) {
        return TestMetastoreHiveStatisticsProvider.integerRange(OptionalLong.of(min), OptionalLong.of(max));
    }

    private static HiveColumnStatistics integerRange(OptionalLong min, OptionalLong max) {
        return HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(min, max)).build();
    }

    private static HiveColumnStatistics doubleRange(double min, double max) {
        return TestMetastoreHiveStatisticsProvider.doubleRange(OptionalDouble.of(min), OptionalDouble.of(max));
    }

    private static HiveColumnStatistics doubleRange(OptionalDouble min, OptionalDouble max) {
        return HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(min, max)).build();
    }

    private static HiveColumnStatistics dateRange(String min, String max) {
        return TestMetastoreHiveStatisticsProvider.dateRange(Optional.of(min), Optional.of(max));
    }

    private static HiveColumnStatistics dateRange(Optional<String> min, Optional<String> max) {
        return HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(min.map(TestMetastoreHiveStatisticsProvider::parseDate), max.map(TestMetastoreHiveStatisticsProvider::parseDate))).build();
    }

    private static LocalDate parseDate(String date) {
        return LocalDate.parse(date);
    }

    private static HiveColumnStatistics decimalRange(BigDecimal min, BigDecimal max) {
        return TestMetastoreHiveStatisticsProvider.decimalRange(Optional.of(min), Optional.of(max));
    }

    private static HiveColumnStatistics decimalRange(Optional<BigDecimal> min, Optional<BigDecimal> max) {
        return HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(min, max)).build();
    }

    private static /* synthetic */ void lambda$testGetTableStatisticsValidationFailure$0(HiveStatisticsProvider statisticsProvider, String partitionName) throws Throwable {
        statisticsProvider.getTableStatistics(HiveTestUtils.getHiveSession(new HiveConfig().setIgnoreCorruptedStatistics(false)), TABLE, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition(partitionName)));
    }
}

