/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.util.Progressable;

public class FileSystemTesting {

    public static final class MockFileSystem
    extends FileSystem {
        private final List<MockFile> files = new ArrayList<MockFile>();
        private final Map<MockFile, FileStatus> fileStatusMap = new HashMap<MockFile, FileStatus>();
        private Path workingDir = new Path("/");
        private final List<MockFile> globalFiles = new ArrayList<MockFile>();

        public void initialize(URI uri, Configuration conf) {
            this.setConf(conf);
        }

        public MockFileSystem(Configuration conf, MockFile ... files) {
            this.setConf(conf);
            this.files.addAll(Arrays.asList(files));
        }

        public URI getUri() {
            return URI.create("mock:///");
        }

        public String getScheme() {
            return "mock";
        }

        public FSDataInputStream open(Path path, int i) throws IOException {
            MockFile file = this.findFile(path);
            if (file != null) {
                return new FSDataInputStream((InputStream)((Object)new MockInputStream(file)));
            }
            throw new FileNotFoundException("File not found: " + String.valueOf(path));
        }

        private MockFile findFile(Path path) {
            for (MockFile file : this.files) {
                if (!file.path.equals((Object)path)) continue;
                return file;
            }
            for (MockFile file : this.globalFiles) {
                if (!file.path.equals((Object)path)) continue;
                return file;
            }
            return null;
        }

        public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progressable) throws IOException {
            MockFile file = this.findFile(path);
            if (file == null) {
                file = new MockFile(path.toString(), Math.toIntExact(blockSize), new byte[0], new MockBlock[0]);
                this.files.add(file);
            }
            return new MockOutputStream(file);
        }

        public FSDataOutputStream append(Path path, int bufferSize, Progressable progressable) throws IOException {
            return this.create(path, FsPermission.getDefault(), true, bufferSize, (short)3, 262144L, progressable);
        }

        public boolean rename(Path path, Path path2) throws IOException {
            return false;
        }

        public boolean delete(Path path) throws IOException {
            MockFile mf;
            int i;
            int removed = 0;
            for (i = 0; i < this.files.size(); ++i) {
                mf = this.files.get(i);
                if (!path.equals((Object)mf.path)) continue;
                this.files.remove(i);
                ++removed;
                break;
            }
            for (i = 0; i < this.globalFiles.size(); ++i) {
                mf = this.files.get(i);
                if (!path.equals((Object)mf.path)) continue;
                this.globalFiles.remove(i);
                ++removed;
                break;
            }
            return removed > 0;
        }

        public boolean delete(Path path, boolean recursive) throws IOException {
            if (recursive) {
                throw new UnsupportedOperationException();
            }
            return this.delete(path);
        }

        public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f) {
            return new RemoteIterator<LocatedFileStatus>(this){
                private final Iterator<LocatedFileStatus> iterator;
                final /* synthetic */ MockFileSystem this$0;
                {
                    this.this$0 = this$0;
                    this.iterator = this.this$0.listLocatedFileStatuses(f).iterator();
                }

                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                public LocatedFileStatus next() {
                    return this.iterator.next();
                }
            };
        }

        private List<LocatedFileStatus> listLocatedFileStatuses(Path path) {
            path = path.makeQualified((FileSystem)this);
            ArrayList<LocatedFileStatus> result = new ArrayList<LocatedFileStatus>();
            String pathname = path.toString();
            String pathnameAsDir = pathname + "/";
            TreeSet<String> dirs = new TreeSet<String>();
            MockFile file = this.findFile(path);
            if (file != null) {
                result.add(this.createLocatedStatus(file));
                return result;
            }
            this.findMatchingLocatedFiles(this.files, pathnameAsDir, dirs, result);
            this.findMatchingLocatedFiles(this.globalFiles, pathnameAsDir, dirs, result);
            for (String dir : dirs) {
                result.add(this.createLocatedDirectory(new MockPath(this, pathnameAsDir + dir)));
            }
            return result;
        }

        public FileStatus[] listStatus(Path path) {
            path = path.makeQualified((FileSystem)this);
            ArrayList<FileStatus> result = new ArrayList<FileStatus>();
            String pathname = path.toString();
            String pathnameAsDir = pathname + "/";
            TreeSet<String> dirs = new TreeSet<String>();
            MockFile file = this.findFile(path);
            if (file != null) {
                return new FileStatus[]{this.createStatus(file)};
            }
            this.findMatchingFiles(this.files, pathnameAsDir, dirs, result);
            this.findMatchingFiles(this.globalFiles, pathnameAsDir, dirs, result);
            for (String dir : dirs) {
                result.add(MockFileSystem.createDirectory(new MockPath(this, pathnameAsDir + dir)));
            }
            return result.toArray(new FileStatus[0]);
        }

        private void findMatchingFiles(List<MockFile> files, String pathnameAsDir, Set<String> dirs, List<FileStatus> result) {
            for (MockFile file : files) {
                String filename = file.path.toString();
                if (!filename.startsWith(pathnameAsDir)) continue;
                String tail = filename.substring(pathnameAsDir.length());
                int nextSlash = tail.indexOf(47);
                if (nextSlash > 0) {
                    dirs.add(tail.substring(0, nextSlash));
                    continue;
                }
                result.add(this.createStatus(file));
            }
        }

        private void findMatchingLocatedFiles(List<MockFile> files, String pathnameAsDir, Set<String> dirs, List<LocatedFileStatus> result) {
            for (MockFile file : files) {
                String filename = file.path.toString();
                if (!filename.startsWith(pathnameAsDir)) continue;
                String tail = filename.substring(pathnameAsDir.length());
                int nextSlash = tail.indexOf(47);
                if (nextSlash > 0) {
                    dirs.add(tail.substring(0, nextSlash));
                    continue;
                }
                result.add(this.createLocatedStatus(file));
            }
        }

        public void setWorkingDirectory(Path path) {
            this.workingDir = path;
        }

        public Path getWorkingDirectory() {
            return this.workingDir;
        }

        public boolean mkdirs(Path path, FsPermission fsPermission) {
            return false;
        }

        private FileStatus createStatus(MockFile file) {
            if (this.fileStatusMap.containsKey(file)) {
                return this.fileStatusMap.get(file);
            }
            FileStatus fileStatus = new FileStatus((long)file.length, false, 1, (long)file.blockSize, 0L, 0L, FsPermission.createImmutable((short)644), "owen", "group", file.path);
            this.fileStatusMap.put(file, fileStatus);
            return fileStatus;
        }

        private static FileStatus createDirectory(Path dir) {
            return new FileStatus(0L, true, 0, 0L, 0L, 0L, FsPermission.createImmutable((short)755), "owen", "group", dir);
        }

        private LocatedFileStatus createLocatedStatus(MockFile file) {
            FileStatus fileStatus = this.createStatus(file);
            return new LocatedFileStatus(fileStatus, this.getFileBlockLocationsImpl(fileStatus));
        }

        private LocatedFileStatus createLocatedDirectory(Path dir) {
            FileStatus fileStatus = MockFileSystem.createDirectory(dir);
            return new LocatedFileStatus(fileStatus, this.getFileBlockLocationsImpl(fileStatus));
        }

        public FileStatus getFileStatus(Path path) throws IOException {
            path = path.makeQualified((FileSystem)this);
            String pathnameAsDir = path.toString() + "/";
            MockFile file = this.findFile(path);
            if (file != null) {
                return this.createStatus(file);
            }
            for (MockFile dir : this.files) {
                if (!dir.path.toString().startsWith(pathnameAsDir)) continue;
                return MockFileSystem.createDirectory(path);
            }
            for (MockFile dir : this.globalFiles) {
                if (!dir.path.toString().startsWith(pathnameAsDir)) continue;
                return MockFileSystem.createDirectory(path);
            }
            throw new FileNotFoundException("File does not exist: " + String.valueOf(path));
        }

        public BlockLocation[] getFileBlockLocations(FileStatus stat, long start, long len) {
            return this.getFileBlockLocationsImpl(stat);
        }

        private BlockLocation[] getFileBlockLocationsImpl(FileStatus stat) {
            ArrayList<BlockLocation> result = new ArrayList<BlockLocation>();
            MockFile file = this.findFile(stat.getPath());
            if (file != null) {
                for (MockBlock block : file.blocks) {
                    String[] topology = new String[block.hosts.length];
                    for (int i = 0; i < topology.length; ++i) {
                        topology[i] = "/rack/ " + block.hosts[i];
                    }
                    result.add(new BlockLocation(block.hosts, block.hosts, topology, (long)block.offset, (long)block.length));
                }
                return result.toArray(new BlockLocation[0]);
            }
            return new BlockLocation[0];
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("mockFs{files:[");
            for (int i = 0; i < this.files.size(); ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.files.get(i));
            }
            buffer.append("]}");
            return buffer.toString();
        }
    }

    public static class MockOutputStream
    extends FSDataOutputStream {
        private final MockFile file;

        public MockOutputStream(MockFile file) {
            super((OutputStream)new DataOutputBuffer(), null);
            this.file = file;
        }

        public void setBlocks(MockBlock ... blocks) {
            this.file.blocks = blocks;
            int offset = 0;
            for (int i = 0; offset < this.file.length && i < blocks.length; offset += blocks[i].length, ++i) {
                blocks[i].offset = offset;
                blocks[i].length = Math.min(this.file.length - offset, this.file.blockSize);
            }
        }

        public void close() throws IOException {
            super.close();
            DataOutputBuffer buf = (DataOutputBuffer)this.getWrappedStream();
            this.file.length = buf.getLength();
            this.file.content = new byte[this.file.length];
            MockBlock block = new MockBlock("host1");
            block.setLength(this.file.length);
            this.setBlocks(block);
            System.arraycopy(buf.getData(), 0, this.file.content, 0, this.file.length);
        }

        public String toString() {
            return "Out stream to " + this.file.toString();
        }
    }

    public static class MockPath
    extends Path {
        private final FileSystem fs;

        public MockPath(FileSystem fs, String path) {
            super(path);
            this.fs = fs;
        }

        public FileSystem getFileSystem(Configuration conf) {
            return this.fs;
        }
    }

    static class MockInputStream
    extends FSInputStream {
        private final MockFile file;
        private int offset;

        public MockInputStream(MockFile file) {
            this.file = file;
        }

        public void seek(long offset) {
            this.offset = Math.toIntExact(offset);
        }

        public long getPos() {
            return this.offset;
        }

        public boolean seekToNewSource(long l) {
            return false;
        }

        public int read() throws IOException {
            if (this.offset < this.file.length) {
                int i = this.file.content[this.offset] & 0xFF;
                ++this.offset;
                return i;
            }
            return -1;
        }

        public int available() {
            return this.file.length - this.offset;
        }
    }

    public static class MockFile {
        private final Path path;
        private final int blockSize;
        private int length;
        private MockBlock[] blocks;
        private byte[] content;

        public MockFile(String path, int blockSize, byte[] content, MockBlock ... blocks) {
            this.path = new Path(path);
            this.blockSize = blockSize;
            this.blocks = blocks;
            this.content = content;
            this.length = content.length;
            int offset = 0;
            for (MockBlock block : blocks) {
                block.offset = offset;
                block.length = Math.min(this.length - offset, blockSize);
                offset += block.length;
            }
        }

        public int hashCode() {
            return this.path.hashCode() + 31 * this.length;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MockFile)) {
                return false;
            }
            MockFile that = (MockFile)obj;
            return that.path.equals((Object)this.path) && that.length == this.length;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("mockFile{path: ");
            buffer.append(this.path.toString());
            buffer.append(", blkSize: ");
            buffer.append(this.blockSize);
            buffer.append(", len: ");
            buffer.append(this.length);
            buffer.append(", blocks: [");
            for (int i = 0; i < this.blocks.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.blocks[i]);
            }
            buffer.append("]}");
            return buffer.toString();
        }
    }

    public static class MockBlock {
        private int offset;
        private int length;
        private final String[] hosts;

        public MockBlock(String ... hosts) {
            this.hosts = hosts;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("block{offset: ");
            buffer.append(this.offset);
            buffer.append(", length: ");
            buffer.append(this.length);
            buffer.append(", hosts: [");
            for (int i = 0; i < this.hosts.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.hosts[i]);
            }
            buffer.append("]}");
            return buffer.toString();
        }
    }
}

