/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.trino.filesystem.FileEntry;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.memory.MemoryFileSystem;
import io.trino.plugin.hive.util.AcidTables;
import io.trino.plugin.hive.util.ValidWriteIdList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAcidTables {
    private static final byte[] FAKE_DATA = new byte[]{65, 66, 67};

    @Test
    public void testParseBase() {
        AcidTables.ParsedBase base = AcidTables.parseBase((String)"base_000123");
        Assertions.assertThat((long)base.writeId()).isEqualTo(123L);
        Assertions.assertThat((long)base.visibilityId()).isEqualTo(0L);
        base = AcidTables.parseBase((String)"base_123_v456");
        Assertions.assertThat((long)base.writeId()).isEqualTo(123L);
        Assertions.assertThat((long)base.visibilityId()).isEqualTo(456L);
    }

    @Test
    public void testParseDelta() {
        AcidTables.ParsedDelta delta = AcidTables.parseDelta((String)"/tbl/part1/delta_12_34", (String)"delta_", List.of());
        Assertions.assertThat((int)12).isEqualTo(delta.min());
        Assertions.assertThat((int)34).isEqualTo(delta.max());
        Assertions.assertThat((int)-1).isEqualTo(delta.statementId());
        delta = AcidTables.parseDelta((String)"/tbl/part1/delete_delta_12_34", (String)"delete_delta_", List.of());
        Assertions.assertThat((int)12).isEqualTo(delta.min());
        Assertions.assertThat((int)34).isEqualTo(delta.max());
        Assertions.assertThat((int)-1).isEqualTo(delta.statementId());
        delta = AcidTables.parseDelta((String)"/tbl/part1/delta_12_34_56", (String)"delta_", List.of());
        Assertions.assertThat((int)12).isEqualTo(delta.min());
        Assertions.assertThat((int)34).isEqualTo(delta.max());
        Assertions.assertThat((int)56).isEqualTo(delta.statementId());
        delta = AcidTables.parseDelta((String)"/tbl/part1/delete_delta_12_34_56", (String)"delete_delta_", List.of());
        Assertions.assertThat((int)12).isEqualTo(delta.min());
        Assertions.assertThat((int)34).isEqualTo(delta.max());
        Assertions.assertThat((int)56).isEqualTo(delta.statementId());
        delta = AcidTables.parseDelta((String)"/tbl/part1/delta_12_34_v78", (String)"delta_", List.of());
        Assertions.assertThat((int)12).isEqualTo(delta.min());
        Assertions.assertThat((int)34).isEqualTo(delta.max());
        Assertions.assertThat((int)-1).isEqualTo(delta.statementId());
        delta = AcidTables.parseDelta((String)"/tbl/part1/delete_delta_12_34_v78", (String)"delete_delta_", List.of());
        Assertions.assertThat((int)12).isEqualTo(delta.min());
        Assertions.assertThat((int)34).isEqualTo(delta.max());
        Assertions.assertThat((int)-1).isEqualTo(delta.statementId());
        delta = AcidTables.parseDelta((String)"/tbl/part1/delta_12_34_56_v78", (String)"delta_", List.of());
        Assertions.assertThat((int)12).isEqualTo(delta.min());
        Assertions.assertThat((int)34).isEqualTo(delta.max());
        Assertions.assertThat((int)56).isEqualTo(delta.statementId());
        delta = AcidTables.parseDelta((String)"/tbl/part1/delete_delta_12_34_56_v78", (String)"delete_delta_", List.of());
        Assertions.assertThat((int)12).isEqualTo(delta.min());
        Assertions.assertThat((int)34).isEqualTo(delta.max());
        Assertions.assertThat((int)56).isEqualTo(delta.statementId());
    }

    @Test
    public void testOriginal() throws Exception {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/000000_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/000000_0_copy_1", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/000000_0_copy_2", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/000001_1", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/000002_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/random", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/_done", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/_tmp/000000_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/_tmp/abc/000000_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/subdir/000000_0", FAKE_DATA);
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)fileSystem, (Location)Location.of((String)"memory:///tbl/part1"), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).isEmpty();
        Assertions.assertThat((List)state.deltas()).isEmpty();
        List files = state.originalFiles();
        Assertions.assertThat((List)files).hasSize(7);
        Assertions.assertThat((Object)((FileEntry)files.get(0)).location()).isEqualTo((Object)Location.of((String)"memory:///tbl/part1/000000_0"));
        Assertions.assertThat((Object)((FileEntry)files.get(1)).location()).isEqualTo((Object)Location.of((String)"memory:///tbl/part1/000000_0_copy_1"));
        Assertions.assertThat((Object)((FileEntry)files.get(2)).location()).isEqualTo((Object)Location.of((String)"memory:///tbl/part1/000000_0_copy_2"));
        Assertions.assertThat((Object)((FileEntry)files.get(3)).location()).isEqualTo((Object)Location.of((String)"memory:///tbl/part1/000001_1"));
        Assertions.assertThat((Object)((FileEntry)files.get(4)).location()).isEqualTo((Object)Location.of((String)"memory:///tbl/part1/000002_0"));
        Assertions.assertThat((Object)((FileEntry)files.get(5)).location()).isEqualTo((Object)Location.of((String)"memory:///tbl/part1/random"));
        Assertions.assertThat((Object)((FileEntry)files.get(6)).location()).isEqualTo((Object)Location.of((String)"memory:///tbl/part1/subdir/000000_0"));
    }

    @Test
    public void testOriginalDeltas() throws Exception {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/000000_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/000001_1", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/000002_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/random", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/_done", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/_tmp/000000_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/_tmp/delta_025_025/000000_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/subdir/000000_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_025_025/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_029_029/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_025_030/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_050_100/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_101_101/bucket_0", FAKE_DATA);
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)fileSystem, (Location)Location.of((String)"memory:///tbl/part1"), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).isEmpty();
        List files = state.originalFiles();
        Assertions.assertThat((List)files).hasSize(5);
        Assertions.assertThat((Object)((FileEntry)files.get(0)).location()).isEqualTo((Object)Location.of((String)"memory:///tbl/part1/000000_0"));
        Assertions.assertThat((Object)((FileEntry)files.get(1)).location()).isEqualTo((Object)Location.of((String)"memory:///tbl/part1/000001_1"));
        Assertions.assertThat((Object)((FileEntry)files.get(2)).location()).isEqualTo((Object)Location.of((String)"memory:///tbl/part1/000002_0"));
        Assertions.assertThat((Object)((FileEntry)files.get(3)).location()).isEqualTo((Object)Location.of((String)"memory:///tbl/part1/random"));
        Assertions.assertThat((Object)((FileEntry)files.get(4)).location()).isEqualTo((Object)Location.of((String)"memory:///tbl/part1/subdir/000000_0"));
        List deltas = state.deltas();
        Assertions.assertThat((List)deltas).hasSize(2);
        AcidTables.ParsedDelta delta = (AcidTables.ParsedDelta)deltas.get(0);
        Assertions.assertThat((String)delta.path()).isEqualTo("memory:///tbl/part1/delta_025_030");
        Assertions.assertThat((long)delta.min()).isEqualTo(25L);
        Assertions.assertThat((long)delta.max()).isEqualTo(30L);
        delta = (AcidTables.ParsedDelta)deltas.get(1);
        Assertions.assertThat((String)delta.path()).isEqualTo("memory:///tbl/part1/delta_050_100");
        Assertions.assertThat((long)delta.min()).isEqualTo(50L);
        Assertions.assertThat((long)delta.max()).isEqualTo(100L);
    }

    @Test
    public void testBaseDeltas() throws Exception {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/_tmp/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/_tmp/base_5/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/base_5/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/base_10/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/base_49/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_025_025/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_029_029/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_025_030/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_050_105/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_90_120/bucket_0", FAKE_DATA);
        AcidTables.AcidState dir = AcidTables.getAcidState((TrinoFileSystem)fileSystem, (Location)Location.of((String)"memory:///tbl/part1"), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)dir.baseDirectory()).contains((Object)Location.of((String)"memory:///tbl/part1/base_49"));
        Assertions.assertThat((List)dir.originalFiles()).isEmpty();
        List deltas = dir.deltas();
        Assertions.assertThat((List)deltas).hasSize(1);
        AcidTables.ParsedDelta delta = (AcidTables.ParsedDelta)deltas.get(0);
        Assertions.assertThat((String)delta.path()).isEqualTo("memory:///tbl/part1/delta_050_105");
        Assertions.assertThat((long)delta.min()).isEqualTo(50L);
        Assertions.assertThat((long)delta.max()).isEqualTo(105L);
    }

    @Test
    public void testObsoleteOriginals() throws Exception {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/base_10/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/base_5/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/000000_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/000001_1", FAKE_DATA);
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)fileSystem, (Location)Location.of((String)"memory:///tbl/part1"), (ValidWriteIdList)new ValidWriteIdList("tbl:150:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).contains((Object)Location.of((String)"memory:///tbl/part1/base_10"));
    }

    @Test
    public void testOverlapingDelta() throws Exception {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_0000063_63/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_000062_62/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_00061_61/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_40_60/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_0060_60/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_052_55/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/base_50/bucket_0", FAKE_DATA);
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)fileSystem, (Location)Location.of((String)"memory:///tbl/part1"), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).contains((Object)Location.of((String)"memory:///tbl/part1/base_50"));
        List deltas = state.deltas();
        Assertions.assertThat((List)deltas).hasSize(4);
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(0)).path()).isEqualTo("memory:///tbl/part1/delta_40_60");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(1)).path()).isEqualTo("memory:///tbl/part1/delta_00061_61");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(2)).path()).isEqualTo("memory:///tbl/part1/delta_000062_62");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(3)).path()).isEqualTo("memory:///tbl/part1/delta_0000063_63");
    }

    @Test
    public void testOverlapingDelta2() throws Exception {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_0000063_63_0/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_000062_62_0/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_000062_62_3/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_00061_61_0/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_40_60/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_0060_60_1/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_0060_60_4/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_0060_60_7/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_052_55/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_058_58/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/base_50/bucket_0", FAKE_DATA);
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)fileSystem, (Location)Location.of((String)"memory:///tbl/part1"), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).contains((Object)Location.of((String)"memory:///tbl/part1/base_50"));
        List deltas = state.deltas();
        Assertions.assertThat((List)deltas).hasSize(5);
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(0)).path()).isEqualTo("memory:///tbl/part1/delta_40_60");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(1)).path()).isEqualTo("memory:///tbl/part1/delta_00061_61_0");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(2)).path()).isEqualTo("memory:///tbl/part1/delta_000062_62_0");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(3)).path()).isEqualTo("memory:///tbl/part1/delta_000062_62_3");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(4)).path()).isEqualTo("memory:///tbl/part1/delta_0000063_63_0");
    }

    @Test
    public void deltasWithOpenTxnInRead() throws Exception {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_1_1/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_2_5/bucket_0", FAKE_DATA);
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)fileSystem, (Location)Location.of((String)"memory:///tbl/part1"), (ValidWriteIdList)new ValidWriteIdList("tbl:100:4:4"));
        List deltas = state.deltas();
        Assertions.assertThat((List)deltas).hasSize(2);
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(0)).path()).isEqualTo("memory:///tbl/part1/delta_1_1");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(1)).path()).isEqualTo("memory:///tbl/part1/delta_2_5");
    }

    @Test
    public void deltasWithOpenTxnInRead2() throws Exception {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_1_1/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_2_5/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_4_4_1/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_4_4_3/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_101_101_1/bucket_0", FAKE_DATA);
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)fileSystem, (Location)Location.of((String)"memory:///tbl/part1"), (ValidWriteIdList)new ValidWriteIdList("tbl:100:4:4"));
        List deltas = state.deltas();
        Assertions.assertThat((List)deltas).hasSize(2);
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(0)).path()).isEqualTo("memory:///tbl/part1/delta_1_1");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(1)).path()).isEqualTo("memory:///tbl/part1/delta_2_5");
    }

    @Test
    public void testBaseWithDeleteDeltas() throws Exception {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/base_5/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/base_10/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/base_49/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_025_025/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_029_029/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delete_delta_029_029/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_025_030/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delete_delta_025_030/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_050_105/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delete_delta_050_105/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delete_delta_110_110/bucket_0", FAKE_DATA);
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)fileSystem, (Location)Location.of((String)"memory:///tbl/part1"), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).contains((Object)Location.of((String)"memory:///tbl/part1/base_49"));
        Assertions.assertThat((List)state.originalFiles()).isEmpty();
        List deltas = state.deltas();
        Assertions.assertThat((List)deltas).hasSize(2);
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(0)).path()).isEqualTo("memory:///tbl/part1/delete_delta_050_105");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(1)).path()).isEqualTo("memory:///tbl/part1/delta_050_105");
    }

    @Test
    public void testOverlapingDeltaAndDeleteDelta() throws Exception {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_0000063_63/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_000062_62/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_00061_61/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delete_delta_00064_64/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_40_60/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delete_delta_40_60/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_0060_60/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_052_55/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delete_delta_052_55/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/base_50/bucket_0", FAKE_DATA);
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)fileSystem, (Location)Location.of((String)"memory:///tbl/part1"), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).contains((Object)Location.of((String)"memory:///tbl/part1/base_50"));
        List deltas = state.deltas();
        Assertions.assertThat((List)deltas).hasSize(6);
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(0)).path()).isEqualTo("memory:///tbl/part1/delete_delta_40_60");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(1)).path()).isEqualTo("memory:///tbl/part1/delta_40_60");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(2)).path()).isEqualTo("memory:///tbl/part1/delta_00061_61");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(3)).path()).isEqualTo("memory:///tbl/part1/delta_000062_62");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(4)).path()).isEqualTo("memory:///tbl/part1/delta_0000063_63");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(5)).path()).isEqualTo("memory:///tbl/part1/delete_delta_00064_64");
    }

    @Test
    public void testMinorCompactedDeltaMakesInBetweenDelteDeltaObsolete() throws Exception {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_40_60/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delete_delta_50_50/bucket_0", FAKE_DATA);
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)fileSystem, (Location)Location.of((String)"memory:///tbl/part1"), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        List deltas = state.deltas();
        Assertions.assertThat((List)deltas).hasSize(1);
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(0)).path()).isEqualTo("memory:///tbl/part1/delta_40_60");
    }

    @Test
    public void deleteDeltasWithOpenTxnInRead() throws Exception {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_1_1/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_2_5/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delete_delta_2_5/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delete_delta_3_3/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_4_4_1/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_4_4_3/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_101_101_1/bucket_0", FAKE_DATA);
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)fileSystem, (Location)Location.of((String)"memory:///tbl/part1"), (ValidWriteIdList)new ValidWriteIdList("tbl:100:4:4"));
        List deltas = state.deltas();
        Assertions.assertThat((List)deltas).hasSize(3);
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(0)).path()).isEqualTo("memory:///tbl/part1/delta_1_1");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(1)).path()).isEqualTo("memory:///tbl/part1/delete_delta_2_5");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(2)).path()).isEqualTo("memory:///tbl/part1/delta_2_5");
    }

    @Test
    public void testDeleteDeltaSubdirPathGeneration() {
        String deleteDeltaSubdirPath = AcidTables.deleteDeltaSubdir((long)13L, (int)5);
        Assertions.assertThat((String)deleteDeltaSubdirPath).isEqualTo("delete_delta_0000013_0000013_0005");
    }

    @Test
    public void testSkippingSubDirectories() throws IOException {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/base_1/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/base_1/base_1/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_025_025/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delta_025_025/delta_025_025/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delete_delta_029_029/bucket_0", FAKE_DATA);
        TestAcidTables.createFile((TrinoFileSystem)fileSystem, "memory:///tbl/part1/delete_delta_029_029/delete_delta_029_029/bucket_0", FAKE_DATA);
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)fileSystem, (Location)Location.of((String)"memory:///tbl/part1"), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).contains((Object)Location.of((String)"memory:///tbl/part1/base_1"));
        Assertions.assertThat((List)state.originalFiles()).isEmpty();
        List deltas = state.deltas();
        Assertions.assertThat((List)deltas).hasSize(2);
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(0)).path()).isEqualTo("memory:///tbl/part1/delta_025_025");
        Assertions.assertThat((String)((AcidTables.ParsedDelta)deltas.get(1)).path()).isEqualTo("memory:///tbl/part1/delete_delta_029_029");
    }

    private static void createFile(TrinoFileSystem fileSystem, String location, byte[] data) throws IOException {
        try (OutputStream outputStream = fileSystem.newOutputFile(Location.of((String)location)).create();){
            outputStream.write(data);
        }
    }
}

