/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.trino.plugin.hive.util.AsyncQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestAsyncQueue {
    private ExecutorService executor;

    @BeforeAll
    public void setUpClass() {
        this.executor = Executors.newFixedThreadPool(8, Threads.daemonThreadsNamed((String)"test-async-queue-%s"));
    }

    @AfterAll
    public void tearDownClass() {
        this.executor.shutdownNow();
    }

    @Test
    @Timeout(value=10L)
    public void testGetPartial() throws Exception {
        AsyncQueue queue = new AsyncQueue(4, (Executor)this.executor);
        queue.offer((Object)"1");
        queue.offer((Object)"2");
        queue.offer((Object)"3");
        Assertions.assertThat((List)((List)queue.getBatchAsync(100).get())).isEqualTo((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        queue.finish();
        Assertions.assertThat((boolean)queue.isFinished()).isTrue();
    }

    @Test
    @Timeout(value=10L)
    public void testFullQueue() throws Exception {
        AsyncQueue queue = new AsyncQueue(4, (Executor)this.executor);
        Assertions.assertThat((boolean)queue.offer((Object)"1").isDone()).isTrue();
        Assertions.assertThat((boolean)queue.offer((Object)"2").isDone()).isTrue();
        Assertions.assertThat((boolean)queue.offer((Object)"3").isDone()).isTrue();
        Assertions.assertThat((boolean)queue.offer((Object)"4").isDone()).isFalse();
        Assertions.assertThat((boolean)queue.offer((Object)"5").isDone()).isFalse();
        ListenableFuture offerFuture = queue.offer((Object)"6");
        Assertions.assertThat((boolean)offerFuture.isDone()).isFalse();
        Assertions.assertThat((List)((List)queue.getBatchAsync(2).get())).isEqualTo((Object)ImmutableList.of((Object)"1", (Object)"2"));
        Assertions.assertThat((boolean)offerFuture.isDone()).isFalse();
        Assertions.assertThat((List)((List)queue.getBatchAsync(1).get())).isEqualTo((Object)ImmutableList.of((Object)"3"));
        offerFuture.get();
        offerFuture = queue.offer((Object)"7");
        Assertions.assertThat((boolean)offerFuture.isDone()).isFalse();
        queue.finish();
        offerFuture.get();
        Assertions.assertThat((boolean)queue.isFinished()).isFalse();
        Assertions.assertThat((List)((List)queue.getBatchAsync(4).get())).isEqualTo((Object)ImmutableList.of((Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        Assertions.assertThat((boolean)queue.isFinished()).isTrue();
    }

    @Test
    @Timeout(value=10L)
    public void testEmptyQueue() throws Exception {
        AsyncQueue queue = new AsyncQueue(4, (Executor)this.executor);
        Assertions.assertThat((boolean)queue.offer((Object)"1").isDone()).isTrue();
        Assertions.assertThat((boolean)queue.offer((Object)"2").isDone()).isTrue();
        Assertions.assertThat((boolean)queue.offer((Object)"3").isDone()).isTrue();
        Assertions.assertThat((List)((List)queue.getBatchAsync(2).get())).isEqualTo((Object)ImmutableList.of((Object)"1", (Object)"2"));
        Assertions.assertThat((List)((List)queue.getBatchAsync(2).get())).isEqualTo((Object)ImmutableList.of((Object)"3"));
        ListenableFuture batchFuture = queue.getBatchAsync(2);
        Assertions.assertThat((boolean)batchFuture.isDone()).isFalse();
        Assertions.assertThat((boolean)queue.offer((Object)"4").isDone()).isTrue();
        Assertions.assertThat((List)((List)batchFuture.get())).isEqualTo((Object)ImmutableList.of((Object)"4"));
        batchFuture = queue.getBatchAsync(2);
        Assertions.assertThat((boolean)batchFuture.isDone()).isFalse();
        queue.finish();
        batchFuture.get();
        Assertions.assertThat((boolean)queue.isFinished()).isTrue();
    }

    @Test
    @Timeout(value=10L)
    public void testOfferAfterFinish() throws Exception {
        AsyncQueue queue = new AsyncQueue(4, (Executor)this.executor);
        Assertions.assertThat((boolean)queue.offer((Object)"1").isDone()).isTrue();
        Assertions.assertThat((boolean)queue.offer((Object)"2").isDone()).isTrue();
        Assertions.assertThat((boolean)queue.offer((Object)"3").isDone()).isTrue();
        Assertions.assertThat((boolean)queue.offer((Object)"4").isDone()).isFalse();
        queue.finish();
        Assertions.assertThat((boolean)queue.offer((Object)"5").isDone()).isTrue();
        Assertions.assertThat((boolean)queue.offer((Object)"6").isDone()).isTrue();
        Assertions.assertThat((boolean)queue.offer((Object)"7").isDone()).isTrue();
        Assertions.assertThat((boolean)queue.isFinished()).isFalse();
        Assertions.assertThat((List)((List)queue.getBatchAsync(100).get())).isEqualTo((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        Assertions.assertThat((boolean)queue.isFinished()).isTrue();
    }

    @Test
    public void testBorrow() throws Exception {
        AsyncQueue queue = new AsyncQueue(4, (Executor)this.executor);
        queue.offer((Object)1);
        queue.offer((Object)2);
        queue.offer((Object)3);
        queue.offer((Object)4);
        queue.offer((Object)5);
        Runnable runnable = () -> {
            for (int i = 0; i < 700; ++i) {
                MoreFutures.getFutureValue((Future)queue.borrowBatchAsync(3, elements -> new AsyncQueue.BorrowResult(elements, null)));
            }
        };
        Future<?> future1 = this.executor.submit(runnable);
        Future<?> future2 = this.executor.submit(runnable);
        Future<?> future3 = this.executor.submit(runnable);
        future1.get();
        future2.get();
        future3.get();
        queue.finish();
        Assertions.assertThat((boolean)queue.isFinished()).isFalse();
        AtomicBoolean done = new AtomicBoolean();
        this.executor.submit(() -> {
            while (!done.get()) {
                Assertions.assertThat((queue.isFinished() || done.get() ? 1 : 0) != 0).isFalse();
            }
        });
        future1 = this.executor.submit(runnable);
        future2 = this.executor.submit(runnable);
        future3 = this.executor.submit(runnable);
        future1.get();
        future2.get();
        future3.get();
        done.set(true);
        Assertions.assertThat((boolean)queue.isFinished()).isFalse();
        ArrayList list = new ArrayList((Collection)queue.getBatchAsync(100).get());
        list.sort(Integer::compare);
        Assertions.assertThat(list).isEqualTo((Object)ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5));
        Assertions.assertThat((boolean)queue.isFinished()).isTrue();
    }

    @Test
    public void testBorrowThrows() throws Exception {
        AsyncQueue queue = new AsyncQueue(4, (Executor)this.executor);
        queue.offer((Object)1);
        queue.offer((Object)2);
        queue.offer((Object)3);
        queue.offer((Object)4);
        queue.offer((Object)5);
        ListenableFuture future1 = queue.offer((Object)6);
        Assertions.assertThat((boolean)future1.isDone()).isFalse();
        Runnable runnable = () -> MoreFutures.getFutureValue((Future)queue.borrowBatchAsync(1, elements -> {
            throw new RuntimeException("test fail");
        }));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executor.submit(runnable).get()).isInstanceOf(ExecutionException.class)).hasMessageContaining("test fail");
        ListenableFuture future2 = queue.offer((Object)7);
        Assertions.assertThat((boolean)future1.isDone()).isFalse();
        Assertions.assertThat((boolean)future2.isDone()).isFalse();
        queue.finish();
        future1.get();
        future2.get();
        Assertions.assertThat((boolean)queue.offer((Object)8).isDone()).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executor.submit(runnable).get()).isInstanceOf(ExecutionException.class)).hasMessageContaining("test fail");
        Assertions.assertThat((boolean)queue.offer((Object)9).isDone()).isTrue();
        Assertions.assertThat((boolean)queue.isFinished()).isFalse();
        ArrayList list = new ArrayList((Collection)queue.getBatchAsync(100).get());
        Assertions.assertThat(list).isEqualTo((Object)ImmutableList.of((Object)3, (Object)4, (Object)5, (Object)6, (Object)7));
        Assertions.assertThat((boolean)queue.isFinished()).isTrue();
    }
}

