/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.trino.plugin.hive.util.FileSystemTesting;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveAcidUtils {
    @Test
    public void testParsing() {
        Assertions.assertThat((long)AcidUtils.parseBase((Path)new Path("/tmp/base_000123"))).isEqualTo(123L);
    }

    @Test
    public void testOriginal() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0_copy_1", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0_copy_2", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000001_1", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000002_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/random", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_done", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_tmp/000000_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_tmp/abc/000000_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/subdir/000000_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]));
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)new FileSystemTesting.MockPath(fs, "/tbl/part1"), (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assertions.assertThat((Comparable)dir.getBaseDirectory()).isNull();
        Assertions.assertThat((List)dir.getCurrentDirectories()).isEmpty();
        Assertions.assertThat((List)dir.getObsolete()).isEmpty();
        List result = dir.getOriginalFiles();
        Assertions.assertThat((List)result).hasSize(7);
        Assertions.assertThat((String)((HadoopShims.HdfsFileStatusWithId)result.get(0)).getFileStatus().getPath().toString()).isEqualTo("mock:/tbl/part1/000000_0");
        Assertions.assertThat((String)((HadoopShims.HdfsFileStatusWithId)result.get(1)).getFileStatus().getPath().toString()).isEqualTo("mock:/tbl/part1/000000_0_copy_1");
        Assertions.assertThat((String)((HadoopShims.HdfsFileStatusWithId)result.get(2)).getFileStatus().getPath().toString()).isEqualTo("mock:/tbl/part1/000000_0_copy_2");
        Assertions.assertThat((String)((HadoopShims.HdfsFileStatusWithId)result.get(3)).getFileStatus().getPath().toString()).isEqualTo("mock:/tbl/part1/000001_1");
        Assertions.assertThat((String)((HadoopShims.HdfsFileStatusWithId)result.get(4)).getFileStatus().getPath().toString()).isEqualTo("mock:/tbl/part1/000002_0");
        Assertions.assertThat((String)((HadoopShims.HdfsFileStatusWithId)result.get(5)).getFileStatus().getPath().toString()).isEqualTo("mock:/tbl/part1/random");
        Assertions.assertThat((String)((HadoopShims.HdfsFileStatusWithId)result.get(6)).getFileStatus().getPath().toString()).isEqualTo("mock:/tbl/part1/subdir/000000_0");
    }

    @Test
    public void testOriginalDeltas() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000001_1", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000002_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/random", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_done", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_tmp/000000_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_tmp/delta_025_025/000000_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/subdir/000000_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_029_029/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_030/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_050_100/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_101_101/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]));
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)new FileSystemTesting.MockPath(fs, "mock:/tbl/part1"), (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assertions.assertThat((Comparable)dir.getBaseDirectory()).isNull();
        List obsolete = dir.getObsolete();
        Assertions.assertThat((List)obsolete).hasSize(2);
        Assertions.assertThat((String)((FileStatus)obsolete.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_025_025");
        Assertions.assertThat((String)((FileStatus)obsolete.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_029_029");
        List result = dir.getOriginalFiles();
        Assertions.assertThat((List)result).hasSize(5);
        Assertions.assertThat((String)((HadoopShims.HdfsFileStatusWithId)result.get(0)).getFileStatus().getPath().toString()).isEqualTo("mock:/tbl/part1/000000_0");
        Assertions.assertThat((String)((HadoopShims.HdfsFileStatusWithId)result.get(1)).getFileStatus().getPath().toString()).isEqualTo("mock:/tbl/part1/000001_1");
        Assertions.assertThat((String)((HadoopShims.HdfsFileStatusWithId)result.get(2)).getFileStatus().getPath().toString()).isEqualTo("mock:/tbl/part1/000002_0");
        Assertions.assertThat((String)((HadoopShims.HdfsFileStatusWithId)result.get(3)).getFileStatus().getPath().toString()).isEqualTo("mock:/tbl/part1/random");
        Assertions.assertThat((String)((HadoopShims.HdfsFileStatusWithId)result.get(4)).getFileStatus().getPath().toString()).isEqualTo("mock:/tbl/part1/subdir/000000_0");
        List deltas = dir.getCurrentDirectories();
        Assertions.assertThat((List)deltas).hasSize(2);
        AcidUtils.ParsedDelta delt = (AcidUtils.ParsedDelta)deltas.get(0);
        Assertions.assertThat((String)delt.getPath().toString()).isEqualTo("mock:/tbl/part1/delta_025_030");
        Assertions.assertThat((long)delt.getMinWriteId()).isEqualTo(25L);
        Assertions.assertThat((long)delt.getMaxWriteId()).isEqualTo(30L);
        delt = (AcidUtils.ParsedDelta)deltas.get(1);
        Assertions.assertThat((String)delt.getPath().toString()).isEqualTo("mock:/tbl/part1/delta_050_100");
        Assertions.assertThat((long)delt.getMinWriteId()).isEqualTo(50L);
        Assertions.assertThat((long)delt.getMaxWriteId()).isEqualTo(100L);
    }

    @Test
    public void testBaseDeltas() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/_tmp/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_tmp/base_5/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_49/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_029_029/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_030/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_050_105/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_90_120/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assertions.assertThat((String)dir.getBaseDirectory().toString()).isEqualTo("mock:/tbl/part1/base_49");
        List obsolete = dir.getObsolete();
        Assertions.assertThat((List)obsolete).hasSize(5);
        Assertions.assertThat((String)((FileStatus)obsolete.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/base_10");
        Assertions.assertThat((String)((FileStatus)obsolete.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/base_5");
        Assertions.assertThat((String)((FileStatus)obsolete.get(2)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_025_030");
        Assertions.assertThat((String)((FileStatus)obsolete.get(3)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_025_025");
        Assertions.assertThat((String)((FileStatus)obsolete.get(4)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_029_029");
        Assertions.assertThat((List)dir.getOriginalFiles()).isEmpty();
        List deltas = dir.getCurrentDirectories();
        Assertions.assertThat((List)deltas).hasSize(1);
        AcidUtils.ParsedDelta delt = (AcidUtils.ParsedDelta)deltas.get(0);
        Assertions.assertThat((String)delt.getPath().toString()).isEqualTo("mock:/tbl/part1/delta_050_105");
        Assertions.assertThat((long)delt.getMinWriteId()).isEqualTo(50L);
        Assertions.assertThat((long)delt.getMaxWriteId()).isEqualTo(105L);
    }

    @Test
    public void testObsoleteOriginals() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000001_1", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:150:9223372036854775807:"));
        List obsolete = dir.getObsolete();
        Assertions.assertThat((List)obsolete).hasSize(3);
        Assertions.assertThat((String)((FileStatus)obsolete.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/base_5");
        Assertions.assertThat((String)dir.getBaseDirectory().toString()).isEqualTo("mock:/tbl/part1/base_10");
    }

    @Test
    public void testOverlapingDelta() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0000063_63/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_000062_62/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_00061_61/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_052_55/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_50/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assertions.assertThat((String)dir.getBaseDirectory().toString()).isEqualTo("mock:/tbl/part1/base_50");
        List obsolete = dir.getObsolete();
        Assertions.assertThat((List)obsolete).hasSize(2);
        Assertions.assertThat((String)((FileStatus)obsolete.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_052_55");
        Assertions.assertThat((String)((FileStatus)obsolete.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_0060_60");
        List delts = dir.getCurrentDirectories();
        Assertions.assertThat((List)delts).hasSize(4);
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_40_60");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_00061_61");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(2)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_000062_62");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(3)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_0000063_63");
    }

    @Test
    public void testOverlapingDelta2() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0000063_63_0/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_000062_62_0/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_000062_62_3/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_00061_61_0/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60_4/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60_7/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_052_55/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_058_58/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_50/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assertions.assertThat((String)dir.getBaseDirectory().toString()).isEqualTo("mock:/tbl/part1/base_50");
        List obsolete = dir.getObsolete();
        Assertions.assertThat((List)obsolete).hasSize(5);
        Assertions.assertThat((String)((FileStatus)obsolete.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_052_55");
        Assertions.assertThat((String)((FileStatus)obsolete.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_058_58");
        Assertions.assertThat((String)((FileStatus)obsolete.get(2)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_0060_60_1");
        Assertions.assertThat((String)((FileStatus)obsolete.get(3)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_0060_60_4");
        Assertions.assertThat((String)((FileStatus)obsolete.get(4)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_0060_60_7");
        List delts = dir.getCurrentDirectories();
        Assertions.assertThat((List)delts).hasSize(5);
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_40_60");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_00061_61_0");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(2)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_000062_62_0");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(3)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_000062_62_3");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(4)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_0000063_63_0");
    }

    @Test
    public void deltasWithOpenTxnInRead() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:4:4"));
        List delts = dir.getCurrentDirectories();
        Assertions.assertThat((List)delts).hasSize(2);
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_1_1");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_2_5");
    }

    @Test
    public void deltasWithOpenTxnInRead2() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_4_4_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_4_4_3/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_101_101_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:4:4"));
        List delts = dir.getCurrentDirectories();
        Assertions.assertThat((List)delts).hasSize(2);
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_1_1");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_2_5");
    }

    @Test
    public void deltasWithOpenTxnsNotInCompact() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidCompactorWriteIdList("tbl:4:9223372036854775807"));
        List delts = dir.getCurrentDirectories();
        Assertions.assertThat((List)delts).hasSize(1);
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_1_1");
    }

    @Test
    public void deltasWithOpenTxnsNotInCompact2() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0_flush_length", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_6_10/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidCompactorWriteIdList("tbl:3:9223372036854775807"));
        List delts = dir.getCurrentDirectories();
        Assertions.assertThat((List)delts).hasSize(1);
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_1_1");
    }

    @Test
    public void testBaseWithDeleteDeltas() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_49/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_029_029/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_029_029/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_030/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_025_030/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_050_105/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_050_105/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_110_110/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assertions.assertThat((String)dir.getBaseDirectory().toString()).isEqualTo("mock:/tbl/part1/base_49");
        List obsolete = dir.getObsolete();
        Assertions.assertThat((List)obsolete).hasSize(7);
        Assertions.assertThat((String)((FileStatus)obsolete.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/base_10");
        Assertions.assertThat((String)((FileStatus)obsolete.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/base_5");
        Assertions.assertThat((String)((FileStatus)obsolete.get(2)).getPath().toString()).isEqualTo("mock:/tbl/part1/delete_delta_025_030");
        Assertions.assertThat((String)((FileStatus)obsolete.get(3)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_025_030");
        Assertions.assertThat((String)((FileStatus)obsolete.get(4)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_025_025");
        Assertions.assertThat((String)((FileStatus)obsolete.get(5)).getPath().toString()).isEqualTo("mock:/tbl/part1/delete_delta_029_029");
        Assertions.assertThat((String)((FileStatus)obsolete.get(6)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_029_029");
        Assertions.assertThat((List)dir.getOriginalFiles()).isEmpty();
        List deltas = dir.getCurrentDirectories();
        Assertions.assertThat((List)deltas).hasSize(2);
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)deltas.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delete_delta_050_105");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)deltas.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_050_105");
    }

    @Test
    public void testOverlapingDeltaAndDeleteDelta() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0000063_63/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_000062_62/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_00061_61/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_00064_64/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_40_60/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_052_55/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_052_55/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_50/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assertions.assertThat((String)dir.getBaseDirectory().toString()).isEqualTo("mock:/tbl/part1/base_50");
        List obsolete = dir.getObsolete();
        Assertions.assertThat((List)obsolete).hasSize(3);
        Assertions.assertThat((String)((FileStatus)obsolete.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delete_delta_052_55");
        Assertions.assertThat((String)((FileStatus)obsolete.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_052_55");
        Assertions.assertThat((String)((FileStatus)obsolete.get(2)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_0060_60");
        List delts = dir.getCurrentDirectories();
        Assertions.assertThat((List)delts).hasSize(6);
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delete_delta_40_60");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_40_60");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(2)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_00061_61");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(3)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_000062_62");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(4)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_0000063_63");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(5)).getPath().toString()).isEqualTo("mock:/tbl/part1/delete_delta_00064_64");
    }

    @Test
    public void testMinorCompactedDeltaMakesInBetweenDelteDeltaObsolete() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_50_50/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        List obsolete = dir.getObsolete();
        Assertions.assertThat((List)obsolete).hasSize(1);
        Assertions.assertThat((String)((FileStatus)obsolete.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delete_delta_50_50");
        List delts = dir.getCurrentDirectories();
        Assertions.assertThat((List)delts).hasSize(1);
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_40_60");
    }

    @Test
    public void deltasAndDeleteDeltasWithOpenTxnsNotInCompact() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_2_2/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0_flush_length", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_7_7/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_6_10/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidCompactorWriteIdList("tbl:4:9223372036854775807:"));
        List delts = dir.getCurrentDirectories();
        Assertions.assertThat((List)delts).hasSize(2);
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_1_1");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/delete_delta_2_2");
    }

    @Test
    public void deleteDeltasWithOpenTxnInRead() throws Exception {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_3_3/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_4_4_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_4_4_3/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_101_101_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:4:4"));
        List delts = dir.getCurrentDirectories();
        Assertions.assertThat((List)delts).hasSize(3);
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_1_1");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/delete_delta_2_5");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(2)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_2_5");
    }

    @Test
    public void testDeleteDeltaSubdirPathGeneration() {
        String deleteDeltaSubdirPath = AcidUtils.deleteDeltaSubdir((long)1L, (long)10L);
        Assertions.assertThat((String)deleteDeltaSubdirPath).isEqualTo("delete_delta_0000001_0000010");
        deleteDeltaSubdirPath = AcidUtils.deleteDeltaSubdir((long)1L, (long)10L, (int)5);
        Assertions.assertThat((String)deleteDeltaSubdirPath).isEqualTo("delete_delta_0000001_0000010_0005");
    }

    @Test
    public void testSkippingSubDirectories() throws IOException {
        Configuration conf = new Configuration(false);
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/base_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_1/base_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_025/delta_025_025/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_029_029/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_029_029/delete_delta_029_029/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assertions.assertThat((String)dir.getBaseDirectory().toString()).isEqualTo("mock:/tbl/part1/base_1");
        List obsolete = dir.getObsolete();
        Assertions.assertThat((List)obsolete).isEmpty();
        List delts = dir.getCurrentDirectories();
        Assertions.assertThat((List)delts).hasSize(2);
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString()).isEqualTo("mock:/tbl/part1/delta_025_025");
        Assertions.assertThat((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString()).isEqualTo("mock:/tbl/part1/delete_delta_029_029");
    }
}

