/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.trino.plugin.hive.util.HiveUtil;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.junit.jupiter.api.Test;

public class TestHiveUtil {
    @Test
    public void testParseHiveTimestamp() {
        DateTime time = new DateTime(2011, 5, 6, 7, 8, 9, 123, DateTimeZone.UTC);
        Assertions.assertThat((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss")).isEqualTo(TestHiveUtil.unixTime(time, 0));
        Assertions.assertThat((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.S")).isEqualTo(TestHiveUtil.unixTime(time, 1));
        Assertions.assertThat((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.SSS")).isEqualTo(TestHiveUtil.unixTime(time, 3));
        Assertions.assertThat((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.SSSSSSS")).isEqualTo(TestHiveUtil.unixTime(time, 6));
        Assertions.assertThat((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.SSSSSSSSS")).isEqualTo(TestHiveUtil.unixTime(time, 7));
    }

    @Test
    public void testEscapeDatabaseName() {
        Assertions.assertThat((String)HiveUtil.escapeSchemaName((String)"schema1")).isEqualTo("schema1");
        Assertions.assertThatThrownBy(() -> HiveUtil.escapeSchemaName(null)).hasMessage("The provided schemaName cannot be null or empty");
        Assertions.assertThatThrownBy(() -> HiveUtil.escapeSchemaName((String)"")).hasMessage("The provided schemaName cannot be null or empty");
        Assertions.assertThat((String)HiveUtil.escapeSchemaName((String)"../schema1")).isEqualTo("..%2Fschema1");
        Assertions.assertThat((String)HiveUtil.escapeSchemaName((String)"../../schema1")).isEqualTo("..%2F..%2Fschema1");
    }

    @Test
    public void testEscapeTableName() {
        Assertions.assertThat((String)HiveUtil.escapeTableName((String)"table1")).isEqualTo("table1");
        Assertions.assertThatThrownBy(() -> HiveUtil.escapeTableName(null)).hasMessage("The provided tableName cannot be null or empty");
        Assertions.assertThatThrownBy(() -> HiveUtil.escapeTableName((String)"")).hasMessage("The provided tableName cannot be null or empty");
        Assertions.assertThat((String)HiveUtil.escapeTableName((String)"../table1")).isEqualTo("..%2Ftable1");
        Assertions.assertThat((String)HiveUtil.escapeTableName((String)"../../table1")).isEqualTo("..%2F..%2Ftable1");
    }

    private static long parse(DateTime time, String pattern) {
        return HiveUtil.parseHiveTimestamp((String)DateTimeFormat.forPattern((String)pattern).print((ReadableInstant)time));
    }

    private static long unixTime(DateTime time, int factionalDigits) {
        int factor = (int)Math.pow(10.0, Math.max(0, 3 - factionalDigits));
        return time.getMillis() / (long)factor * (long)factor * 1000L;
    }

    public static DateTimeZone nonDefaultTimeZone() {
        String defaultId = DateTimeZone.getDefault().getID();
        for (String id : DateTimeZone.getAvailableIDs()) {
            DateTimeZone zone;
            if (id.equals(defaultId) || (zone = DateTimeZone.forID((String)id)).getStandardOffset(0L) == 0) continue;
            return zone;
        }
        throw new IllegalStateException("no non-default timezone");
    }
}

