/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.util.MergingPageIterator;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TypeOperators;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMergingPageIterator {
    @Test
    public void testMerging() {
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER);
        ImmutableList sortIndexes = ImmutableList.of((Object)1);
        ImmutableList sortOrders = ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST);
        ArrayList pageLists = new ArrayList();
        PageBuilder pageBuilder = new PageBuilder((List)types);
        for (int i = 0; i < 10; ++i) {
            Iterator values = IntStream.range(0, 1000).map(n -> ThreadLocalRandom.current().nextInt(100000)).mapToObj(n -> n % 100 == 0 ? null : Integer.valueOf(n)).sorted(Comparator.nullsFirst(Comparator.naturalOrder())).iterator();
            ArrayList<Page> pages = new ArrayList<Page>();
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 100; ++k) {
                    Integer n2 = (Integer)values.next();
                    pageBuilder.declarePosition();
                    if (n2 == null) {
                        pageBuilder.getBlockBuilder(0).appendNull();
                        pageBuilder.getBlockBuilder(1).appendNull();
                        continue;
                    }
                    IntegerType.INTEGER.writeLong(pageBuilder.getBlockBuilder(0), (long)n2.intValue());
                    IntegerType.INTEGER.writeLong(pageBuilder.getBlockBuilder(1), (long)n2.intValue() * 22L);
                }
                pages.add(pageBuilder.build());
                pageBuilder.reset();
            }
            pageLists.add(pages);
            Assertions.assertThat((boolean)values.hasNext()).isFalse();
        }
        List pages = pageLists.stream().map(List::iterator).collect(Collectors.toList());
        MergingPageIterator iterator = new MergingPageIterator(pages, (List)types, (List)sortIndexes, (List)sortOrders, new TypeOperators());
        ArrayList<Integer> values = new ArrayList<Integer>();
        while (iterator.hasNext()) {
            Page page = (Page)iterator.next();
            for (int i = 0; i < page.getPositionCount(); ++i) {
                if (page.getBlock(0).isNull(i)) {
                    Assertions.assertThat((boolean)page.getBlock(1).isNull(i)).isTrue();
                    values.add(null);
                    continue;
                }
                int x = IntegerType.INTEGER.getInt(page.getBlock(0), i);
                int y = IntegerType.INTEGER.getInt(page.getBlock(1), i);
                Assertions.assertThat((int)y).isEqualTo(x * 22);
                values.add(x);
            }
        }
        Assertions.assertThat(values).isSortedAccordingTo(Comparator.nullsFirst(Comparator.naturalOrder()));
    }
}

