/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.collect.ImmutableMap;
import io.trino.metastore.DoubleStatistics;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.util.Statistics;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import java.util.Map;
import java.util.OptionalDouble;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStatistics {
    @Test
    public void testCreateRealHiveColumnStatistics() {
        HiveColumnStatistics statistics = TestStatistics.createRealColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(-2391.0f)), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(42.0f))));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.of(-2391.0), OptionalDouble.of(42.0)));
        statistics = TestStatistics.createRealColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(Float.NEGATIVE_INFINITY)), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(Float.POSITIVE_INFINITY))));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty()));
        statistics = TestStatistics.createRealColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(Float.NaN)), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(Float.NaN))));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty()));
        statistics = TestStatistics.createRealColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(-15.0f)), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(-0.0f))));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.of(-15.0), OptionalDouble.of(-0.0)));
    }

    private static HiveColumnStatistics createRealColumnStatistics(Map<HiveColumnStatisticType, Block> computedStatistics) {
        return Statistics.createHiveColumnStatistics(computedStatistics, (Type)RealType.REAL, (long)1L);
    }

    @Test
    public void testCreateDoubleHiveColumnStatistics() {
        HiveColumnStatistics statistics = TestStatistics.createDoubleColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)-2391.0), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)42.0)));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.of(-2391.0), OptionalDouble.of(42.0)));
        statistics = TestStatistics.createDoubleColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)Double.NEGATIVE_INFINITY), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)Double.POSITIVE_INFINITY)));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty()));
        statistics = TestStatistics.createDoubleColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)Double.NaN), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)Double.NaN)));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty()));
        statistics = TestStatistics.createDoubleColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)-15.0), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)-0.0)));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.of(-15.0), OptionalDouble.of(-0.0)));
    }

    private static HiveColumnStatistics createDoubleColumnStatistics(Map<HiveColumnStatisticType, Block> computedStatistics) {
        return Statistics.createHiveColumnStatistics(computedStatistics, (Type)DoubleType.DOUBLE, (long)1L);
    }
}

