/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.metastore.StorageFormat;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveCompressionOption;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;

public final class HiveCompressionCodecs {
    private HiveCompressionCodecs() {
    }

    public static HiveCompressionCodec selectCompressionCodec(ConnectorSession session, StorageFormat storageFormat) {
        HiveCompressionOption compressionOption = HiveSessionProperties.getCompressionCodec(session);
        return HiveStorageFormat.getHiveStorageFormat(storageFormat).map(format -> HiveCompressionCodecs.selectCompressionCodec(compressionOption, format)).orElseGet(() -> HiveCompressionCodecs.toCompressionCodec(compressionOption));
    }

    public static HiveCompressionCodec selectCompressionCodec(ConnectorSession session, HiveStorageFormat storageFormat) {
        return HiveCompressionCodecs.selectCompressionCodec(HiveSessionProperties.getCompressionCodec(session), storageFormat);
    }

    private static HiveCompressionCodec selectCompressionCodec(HiveCompressionOption compressionOption, HiveStorageFormat storageFormat) {
        HiveCompressionCodec selectedCodec = HiveCompressionCodecs.toCompressionCodec(compressionOption);
        if (storageFormat == HiveStorageFormat.PARQUET && selectedCodec.getParquetCompressionCodec().isEmpty() || storageFormat == HiveStorageFormat.AVRO && selectedCodec.getAvroCompressionKind().isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Compression codec %s not supported for %s".formatted(new Object[]{selectedCodec, storageFormat.humanName()}));
        }
        return selectedCodec;
    }

    public static HiveCompressionCodec toCompressionCodec(HiveCompressionOption compressionOption) {
        return switch (compressionOption) {
            default -> throw new MatchException(null, null);
            case HiveCompressionOption.NONE -> HiveCompressionCodec.NONE;
            case HiveCompressionOption.SNAPPY -> HiveCompressionCodec.SNAPPY;
            case HiveCompressionOption.LZ4 -> HiveCompressionCodec.LZ4;
            case HiveCompressionOption.ZSTD -> HiveCompressionCodec.ZSTD;
            case HiveCompressionOption.GZIP -> HiveCompressionCodec.GZIP;
        };
    }
}

