/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.airlift.concurrent.Threads;
import io.trino.plugin.base.ClosingBinder;
import io.trino.plugin.hive.ForHiveMetadata;
import io.trino.plugin.hive.ForHiveSplitManager;
import io.trino.plugin.hive.ForHiveTransactionHeartbeats;
import io.trino.plugin.hive.HiveConfig;
import io.trino.spi.catalog.CatalogName;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class HiveExecutorModule
implements Module {
    public void configure(Binder binder) {
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, ForHiveMetadata.class));
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, ForHiveSplitManager.class));
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ScheduledExecutorService.class, ForHiveTransactionHeartbeats.class));
    }

    @Provides
    @Singleton
    @ForHiveMetadata
    public ExecutorService createMetadataExecutor(CatalogName catalogName) {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("hive-metadata-" + String.valueOf(catalogName) + "-%s")));
    }

    @Provides
    @Singleton
    @ForHiveSplitManager
    public ExecutorService createSplitSourceExecutor(CatalogName catalogName) {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("hive-split-source-" + String.valueOf(catalogName) + "-%s")));
    }

    @Provides
    @Singleton
    @ForHiveTransactionHeartbeats
    public ScheduledExecutorService createHiveTransactionHeartbeatExecutor(CatalogName catalogName, HiveConfig hiveConfig) {
        return Executors.newScheduledThreadPool(hiveConfig.getHiveTransactionHeartbeatThreads(), Threads.daemonThreadsNamed((String)("hive-heartbeat-" + String.valueOf(catalogName) + "-%s")));
    }
}

