/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.metastore.HiveType;
import io.trino.metastore.HiveTypeName;
import io.trino.metastore.type.TypeInfo;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.BucketAdapter;
import io.trino.plugin.hive.BucketValidator;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.Schema;
import io.trino.plugin.hive.TransformConnectorPageSource;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveTypeUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HivePageSourceProvider
implements ConnectorPageSourceProvider {
    public static final int ORIGINAL_TRANSACTION_CHANNEL = 0;
    public static final int BUCKET_CHANNEL = 1;
    public static final int ROW_ID_CHANNEL = 2;
    private static final Pattern ORIGINAL_FILE_PATH_MATCHER = Pattern.compile("(?s)(?<rootDir>.*)/(?<filename>(?<bucketNumber>\\d+)_(?<rest>.*)?)$");
    private final TypeManager typeManager;
    private final int domainCompactionThreshold;
    private final Set<HivePageSourceFactory> pageSourceFactories;

    @Inject
    public HivePageSourceProvider(TypeManager typeManager, HiveConfig hiveConfig, Set<HivePageSourceFactory> pageSourceFactories) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.domainCompactionThreshold = hiveConfig.getDomainCompactionThreshold();
        this.pageSourceFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(pageSourceFactories, "pageSourceFactories is null"));
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        HiveTableHandle hiveTable = (HiveTableHandle)tableHandle;
        HiveSplit hiveSplit = (HiveSplit)split;
        if (HivePageSourceProvider.shouldSkipBucket(hiveTable, hiveSplit, dynamicFilter)) {
            return new EmptyPageSource();
        }
        List<HiveColumnHandle> hiveColumns = columns.stream().map(HiveColumnHandle.class::cast).collect(Collectors.toList());
        boolean originalFile = ORIGINAL_FILE_PATH_MATCHER.matcher(hiveSplit.getPath()).matches();
        List<ColumnMapping> columnMappings = ColumnMapping.buildColumnMappings(hiveSplit.getPartitionName(), hiveSplit.getPartitionKeys(), hiveColumns, hiveSplit.getBucketConversion().map(HiveSplit.BucketConversion::bucketColumnHandles).orElse((List)ImmutableList.of()), hiveSplit.getHiveColumnCoercions(), hiveSplit.getPath(), hiveSplit.getTableBucketNumber(), hiveSplit.getEstimatedFileSize(), hiveSplit.getFileModifiedTime());
        if (HivePageSourceProvider.shouldSkipSplit(columnMappings, dynamicFilter)) {
            return new EmptyPageSource();
        }
        Optional<ConnectorPageSource> pageSource = HivePageSourceProvider.createHivePageSource(this.pageSourceFactories, session, Location.of((String)hiveSplit.getPath()), hiveSplit.getTableBucketNumber(), hiveSplit.getStart(), hiveSplit.getLength(), hiveSplit.getEstimatedFileSize(), hiveSplit.getFileModifiedTime(), hiveSplit.getSchema(), (TupleDomain<HiveColumnHandle>)hiveTable.getCompactEffectivePredicate().intersect(dynamicFilter.getCurrentPredicate().transformKeys(HiveColumnHandle.class::cast)).simplify(this.domainCompactionThreshold), this.typeManager, hiveSplit.getBucketConversion(), hiveSplit.getBucketValidation(), hiveSplit.getAcidInfo(), originalFile, hiveTable.getTransaction(), columnMappings);
        if (pageSource.isPresent()) {
            return pageSource.get();
        }
        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Unsupported input format: serde=%s, format=%s, partition=%s, path=%s".formatted(hiveSplit.getSchema().serializationLibraryName(), HiveUtil.getInputFormatName(hiveSplit.getSchema().serdeProperties()).orElse(null), hiveSplit.getPartitionName(), hiveSplit.getPath()));
    }

    public static Optional<ConnectorPageSource> createHivePageSource(Set<HivePageSourceFactory> pageSourceFactories, ConnectorSession session, Location path, OptionalInt tableBucketNumber, long start, long length, long estimatedFileSize, long fileModifiedTime, Schema schema, TupleDomain<HiveColumnHandle> effectivePredicate, TypeManager typeManager, Optional<HiveSplit.BucketConversion> bucketConversion, Optional<HiveSplit.BucketValidation> bucketValidation, Optional<AcidInfo> acidInfo, boolean originalFile, AcidTransaction transaction, List<ColumnMapping> columnMappings) {
        if (effectivePredicate.isNone()) {
            return Optional.of(new EmptyPageSource());
        }
        List<ColumnMapping> regularAndInterimColumnMappings = ColumnMapping.extractRegularAndInterimColumnMappings(columnMappings);
        Optional<BucketAdaptation> bucketAdaptation = HivePageSourceProvider.createBucketAdaptation(bucketConversion, tableBucketNumber, regularAndInterimColumnMappings);
        Optional<BucketValidator> bucketValidator = HivePageSourceProvider.createBucketValidator(path, bucketValidation, tableBucketNumber, regularAndInterimColumnMappings);
        CoercionUtils.CoercionContext coercionContext = new CoercionUtils.CoercionContext(HiveSessionProperties.getTimestampPrecision(session), CoercionUtils.extractHiveStorageFormat(schema.serializationLibraryName()));
        for (HivePageSourceFactory pageSourceFactory : pageSourceFactories) {
            List<HiveColumnHandle> desiredColumns;
            Optional<ConnectorPageSource> pageSource = pageSourceFactory.createPageSource(session, path, start, length, estimatedFileSize, fileModifiedTime, schema, desiredColumns = ColumnMapping.toColumnHandles(regularAndInterimColumnMappings, typeManager, coercionContext), effectivePredicate, acidInfo, tableBucketNumber, originalFile, transaction);
            if (!pageSource.isPresent()) continue;
            return Optional.of(HivePageSourceProvider.createHivePageSource(columnMappings, bucketAdaptation, bucketValidator, typeManager, coercionContext, pageSource.get()));
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static ConnectorPageSource createHivePageSource(List<ColumnMapping> columnMappings, Optional<BucketAdaptation> bucketAdaptation, Optional<BucketValidator> bucketValidator, TypeManager typeManager, CoercionUtils.CoercionContext coercionContext, ConnectorPageSource pageSource) {
        if (bucketAdaptation.isPresent()) {
            BucketAdapter bucketAdapter = new BucketAdapter(bucketAdaptation.get());
            pageSource = TransformConnectorPageSource.create(pageSource, bucketAdapter::filterPageToEligibleRowsOrDiscard);
        } else if (bucketValidator.isPresent()) {
            BucketValidator validator = bucketValidator.get();
            pageSource = TransformConnectorPageSource.create(pageSource, page -> {
                validator.validate((SourcePage)page);
                return page;
            });
        }
        TransformConnectorPageSource.Builder transforms = TransformConnectorPageSource.builder();
        for (ColumnMapping columnMapping : columnMappings) {
            HiveColumnHandle column = columnMapping.getHiveColumnHandle();
            Type type = column.getType();
            switch (columnMapping.getKind().ordinal()) {
                case 1: {
                    transforms.constantValue(Utils.nativeValueToBlock((Type)type, (Object)columnMapping.getPrefilledValue().getValue()));
                    break;
                }
                case 4: {
                    transforms.constantValue((Block)type.createNullBlock());
                    break;
                }
                case 0: 
                case 3: {
                    Optional<Object> coercer = Optional.empty();
                    if (columnMapping.getBaseTypeCoercionFrom().isPresent()) {
                        List dereferenceIndices = column.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
                        HiveType fromType = HiveTypeUtil.getHiveTypeForDereferences(columnMapping.getBaseTypeCoercionFrom().get(), dereferenceIndices).orElseThrow();
                        HiveType toType = columnMapping.getHiveColumnHandle().getHiveType();
                        coercer = CoercionUtils.createCoercer(typeManager, fromType, toType, coercionContext);
                    }
                    int inputChannel = columnMapping.getIndex();
                    if (coercer.isPresent()) {
                        transforms.transform(inputChannel, (Function)coercer.get());
                        break;
                    }
                    transforms.column(inputChannel);
                    break;
                }
            }
        }
        return transforms.build(pageSource);
    }

    private static boolean shouldSkipBucket(HiveTableHandle hiveTable, HiveSplit hiveSplit, DynamicFilter dynamicFilter) {
        if (hiveSplit.getTableBucketNumber().isEmpty()) {
            return false;
        }
        Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter = HiveBucketing.getHiveBucketFilter(hiveTable, (TupleDomain<ColumnHandle>)dynamicFilter.getCurrentPredicate());
        return hiveBucketFilter.map(filter -> !filter.getBucketsToKeep().contains(hiveSplit.getTableBucketNumber().getAsInt())).orElse(false);
    }

    private static boolean shouldSkipSplit(List<ColumnMapping> columnMappings, DynamicFilter dynamicFilter) {
        TupleDomain predicate = dynamicFilter.getCurrentPredicate();
        if (predicate.isNone()) {
            return true;
        }
        Map domains = (Map)predicate.getDomains().get();
        for (ColumnMapping columnMapping : columnMappings) {
            if (columnMapping.getKind() != ColumnMappingKind.PREFILLED) continue;
            Object value = columnMapping.getPrefilledValue().getValue();
            Domain allowedDomain = (Domain)domains.get(columnMapping.getHiveColumnHandle());
            if (allowedDomain == null || allowedDomain.includesNullableValue(value)) continue;
            return true;
        }
        return false;
    }

    public static ConnectorPageSource projectColumnDereferences(List<HiveColumnHandle> columns, Function<List<HiveColumnHandle>, ConnectorPageSource> pageSourceFactory) {
        ArrayList<HiveColumnHandle> baseColumns = new ArrayList<HiveColumnHandle>();
        TransformConnectorPageSource.Builder transforms = TransformConnectorPageSource.builder();
        HashMap<Integer, Integer> baseColumnOrdinalByColumnIndex = new HashMap<Integer, Integer>();
        for (HiveColumnHandle column : columns) {
            HiveColumnHandle baseColumn = column.getBaseColumn();
            Integer ordinal = (Integer)baseColumnOrdinalByColumnIndex.get(baseColumn.getBaseHiveColumnIndex());
            if (ordinal == null) {
                ordinal = baseColumns.size();
                baseColumnOrdinalByColumnIndex.put(baseColumn.getBaseHiveColumnIndex(), ordinal);
                baseColumns.add(baseColumn);
            }
            if (column.isBaseColumn()) {
                transforms.column(ordinal);
                continue;
            }
            transforms.dereferenceField((List<Integer>)ImmutableList.builder().add((Object)ordinal).addAll(HivePageSourceProvider.getProjection(column, baseColumn)).build());
        }
        ConnectorPageSource connectorPageSource = pageSourceFactory.apply(baseColumns);
        return transforms.build(connectorPageSource);
    }

    public static List<Integer> getProjection(ColumnHandle expected, ColumnHandle read) {
        HiveColumnHandle expectedColumn = (HiveColumnHandle)expected;
        HiveColumnHandle readColumn = (HiveColumnHandle)read;
        Preconditions.checkArgument((boolean)expectedColumn.getBaseColumn().equals(readColumn.getBaseColumn()), (Object)"reader column is not valid for expected column");
        List expectedDereferences = expectedColumn.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
        List readerDereferences = readColumn.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
        Preconditions.checkArgument((readerDereferences.size() <= expectedDereferences.size() ? 1 : 0) != 0, (Object)"Field returned by the reader should include expected field");
        Preconditions.checkArgument((boolean)expectedDereferences.subList(0, readerDereferences.size()).equals(readerDereferences), (Object)"Field returned by the reader should be a prefix of expected field");
        return expectedDereferences.subList(readerDereferences.size(), expectedDereferences.size());
    }

    private static Optional<BucketAdaptation> createBucketAdaptation(Optional<HiveSplit.BucketConversion> bucketConversion, OptionalInt bucketNumber, List<ColumnMapping> columnMappings) {
        return bucketConversion.map(conversion -> {
            List baseColumnMapping = columnMappings.stream().filter(mapping -> mapping.getHiveColumnHandle().isBaseColumn()).collect(Collectors.toList());
            ImmutableMap baseHiveColumnToBlockIndex = Maps.uniqueIndex(baseColumnMapping, mapping -> mapping.getHiveColumnHandle().getBaseHiveColumnIndex());
            int[] bucketColumnIndices = conversion.bucketColumnHandles().stream().mapToInt(arg_0 -> HivePageSourceProvider.lambda$createBucketAdaptation$3((Map)baseHiveColumnToBlockIndex, arg_0)).toArray();
            List bucketColumnHiveTypes = (List)conversion.bucketColumnHandles().stream().map(arg_0 -> HivePageSourceProvider.lambda$createBucketAdaptation$4((Map)baseHiveColumnToBlockIndex, arg_0)).collect(ImmutableList.toImmutableList());
            return new BucketAdaptation(bucketColumnIndices, bucketColumnHiveTypes, conversion.bucketingVersion(), conversion.tableBucketCount(), conversion.partitionBucketCount(), bucketNumber.getAsInt());
        });
    }

    static Optional<BucketValidator> createBucketValidator(Location path, Optional<HiveSplit.BucketValidation> bucketValidation, OptionalInt bucketNumber, List<ColumnMapping> columnMappings) {
        return bucketValidation.flatMap(validation -> {
            Map baseHiveColumnToBlockIndex = (Map)columnMappings.stream().filter(mapping -> mapping.getHiveColumnHandle().isBaseColumn()).collect(ImmutableMap.toImmutableMap(mapping -> mapping.getHiveColumnHandle().getBaseHiveColumnIndex(), Function.identity()));
            int[] bucketColumnIndices = new int[validation.bucketColumns().size()];
            ArrayList<TypeInfo> bucketColumnTypes = new ArrayList<TypeInfo>();
            for (int i = 0; i < validation.bucketColumns().size(); ++i) {
                HiveColumnHandle column = validation.bucketColumns().get(i);
                ColumnMapping mapping2 = (ColumnMapping)baseHiveColumnToBlockIndex.get(column.getBaseHiveColumnIndex());
                if (mapping2 == null) {
                    return Optional.empty();
                }
                bucketColumnIndices[i] = mapping2.getIndex();
                bucketColumnTypes.add(mapping2.getHiveColumnHandle().getHiveType().getTypeInfo());
            }
            return Optional.of(new BucketValidator(path, bucketColumnIndices, bucketColumnTypes, validation.bucketingVersion(), validation.bucketCount(), bucketNumber.orElseThrow()));
        });
    }

    private static /* synthetic */ HiveType lambda$createBucketAdaptation$4(Map baseHiveColumnToBlockIndex, HiveColumnHandle columnHandle) {
        return ((ColumnMapping)baseHiveColumnToBlockIndex.get(columnHandle.getBaseHiveColumnIndex())).getHiveColumnHandle().getHiveType();
    }

    private static /* synthetic */ int lambda$createBucketAdaptation$3(Map baseHiveColumnToBlockIndex, HiveColumnHandle columnHandle) {
        return ((ColumnMapping)baseHiveColumnToBlockIndex.get(columnHandle.getBaseHiveColumnIndex())).getIndex();
    }

    public static class ColumnMapping {
        private final ColumnMappingKind kind;
        private final HiveColumnHandle hiveColumnHandle;
        private final Optional<NullableValue> prefilledValue;
        private final OptionalInt index;
        private final Optional<HiveType> baseTypeCoercionFrom;

        public static ColumnMapping regular(HiveColumnHandle hiveColumnHandle, int index, Optional<HiveType> baseTypeCoercionFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.REGULAR, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), baseTypeCoercionFrom);
        }

        public static ColumnMapping synthesized(HiveColumnHandle hiveColumnHandle, int index, Optional<HiveType> baseTypeCoercionFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.SYNTHESIZED ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.SYNTHESIZED, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), baseTypeCoercionFrom);
        }

        public static ColumnMapping prefilled(HiveColumnHandle hiveColumnHandle, NullableValue prefilledValue, Optional<HiveType> baseTypeCoercionFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.PARTITION_KEY || hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.SYNTHESIZED ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)hiveColumnHandle.isBaseColumn(), (Object)"prefilled values not supported for projected columns");
            return new ColumnMapping(ColumnMappingKind.PREFILLED, hiveColumnHandle, Optional.of(prefilledValue), OptionalInt.empty(), baseTypeCoercionFrom);
        }

        public static ColumnMapping interim(HiveColumnHandle hiveColumnHandle, int index, Optional<HiveType> baseTypeCoercionFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.INTERIM, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), baseTypeCoercionFrom);
        }

        public static ColumnMapping empty(HiveColumnHandle hiveColumnHandle) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.EMPTY, hiveColumnHandle, Optional.empty(), OptionalInt.empty(), Optional.empty());
        }

        private ColumnMapping(ColumnMappingKind kind, HiveColumnHandle hiveColumnHandle, Optional<NullableValue> prefilledValue, OptionalInt index, Optional<HiveType> baseTypeCoercionFrom) {
            this.kind = Objects.requireNonNull(kind, "kind is null");
            this.hiveColumnHandle = Objects.requireNonNull(hiveColumnHandle, "hiveColumnHandle is null");
            this.prefilledValue = Objects.requireNonNull(prefilledValue, "prefilledValue is null");
            this.index = Objects.requireNonNull(index, "index is null");
            this.baseTypeCoercionFrom = Objects.requireNonNull(baseTypeCoercionFrom, "baseTypeCoercionFrom is null");
        }

        public ColumnMappingKind getKind() {
            return this.kind;
        }

        public NullableValue getPrefilledValue() {
            Preconditions.checkState((this.kind == ColumnMappingKind.PREFILLED ? 1 : 0) != 0);
            return this.prefilledValue.get();
        }

        public HiveColumnHandle getHiveColumnHandle() {
            return this.hiveColumnHandle;
        }

        public int getIndex() {
            Preconditions.checkState((this.kind == ColumnMappingKind.REGULAR || this.kind == ColumnMappingKind.INTERIM || HiveColumnHandle.isRowIdColumnHandle(this.hiveColumnHandle) ? 1 : 0) != 0);
            return this.index.getAsInt();
        }

        public Optional<HiveType> getBaseTypeCoercionFrom() {
            return this.baseTypeCoercionFrom;
        }

        public static List<ColumnMapping> buildColumnMappings(String partitionName, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, List<HiveColumnHandle> requiredInterimColumns, Map<Integer, HiveTypeName> hiveColumnCoercions, String path, OptionalInt bucketNumber, long estimatedFileSize, long fileModifiedTime) {
            Optional<HiveType> baseTypeCoercionFrom;
            ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey::name);
            HashSet<Integer> baseColumnHiveIndices = new HashSet<Integer>();
            HashMap<Integer, Set> projectionsForColumn = new HashMap<Integer, Set>();
            ImmutableList.Builder columnMappings = ImmutableList.builder();
            int regularIndex = 0;
            for (HiveColumnHandle column : columns) {
                baseTypeCoercionFrom = Optional.ofNullable(hiveColumnCoercions.get(column.getBaseHiveColumnIndex())).map(HiveTypeName::toHiveType);
                if (column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR) {
                    if (column.isBaseColumn()) {
                        baseColumnHiveIndices.add(column.getBaseHiveColumnIndex());
                    }
                    Preconditions.checkArgument((boolean)projectionsForColumn.computeIfAbsent(column.getBaseHiveColumnIndex(), columnIndex -> new HashSet()).add(column.getHiveColumnProjectionInfo()), (Object)"duplicate column in columns list");
                    if (baseTypeCoercionFrom.isEmpty() || ColumnMapping.projectionValidForType(baseTypeCoercionFrom.get(), column.getHiveColumnProjectionInfo())) {
                        columnMappings.add((Object)ColumnMapping.regular(column, regularIndex, baseTypeCoercionFrom));
                        ++regularIndex;
                        continue;
                    }
                    columnMappings.add((Object)ColumnMapping.empty(column));
                    continue;
                }
                if (HiveColumnHandle.isRowIdColumnHandle(column)) {
                    baseColumnHiveIndices.add(column.getBaseHiveColumnIndex());
                    Preconditions.checkArgument((boolean)projectionsForColumn.computeIfAbsent(column.getBaseHiveColumnIndex(), index -> new HashSet()).add(column.getHiveColumnProjectionInfo()), (Object)"duplicate column in columns list");
                    if (!baseTypeCoercionFrom.isEmpty() && !ColumnMapping.projectionValidForType(baseTypeCoercionFrom.get(), column.getHiveColumnProjectionInfo())) {
                        throw new RuntimeException("baseTypeCoercisionFrom was empty for the rowId column");
                    }
                    columnMappings.add((Object)ColumnMapping.synthesized(column, regularIndex, baseTypeCoercionFrom));
                    ++regularIndex;
                    continue;
                }
                columnMappings.add((Object)ColumnMapping.prefilled(column, HiveUtil.getPrefilledColumnValue(column, (HivePartitionKey)partitionKeysByName.get(column.getName()), path, bucketNumber, estimatedFileSize, fileModifiedTime, partitionName), baseTypeCoercionFrom));
            }
            for (HiveColumnHandle column : requiredInterimColumns) {
                Preconditions.checkArgument((column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
                Preconditions.checkArgument((boolean)column.isBaseColumn(), (Object)"bucketed columns should be base columns");
                if (baseColumnHiveIndices.contains(column.getBaseHiveColumnIndex())) continue;
                if (projectionsForColumn.containsKey(column.getBaseHiveColumnIndex())) {
                    baseTypeCoercionFrom = Optional.ofNullable(hiveColumnCoercions.get(column.getBaseHiveColumnIndex())).map(HiveTypeName::toHiveType);
                    columnMappings.add((Object)ColumnMapping.interim(column, regularIndex, baseTypeCoercionFrom));
                } else {
                    columnMappings.add((Object)ColumnMapping.interim(column, regularIndex, Optional.empty()));
                }
                ++regularIndex;
            }
            return columnMappings.build();
        }

        private static boolean projectionValidForType(HiveType baseType, Optional<HiveColumnProjectionInfo> projection) {
            List dereferences = projection.map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
            Optional<HiveType> targetType = HiveTypeUtil.getHiveTypeForDereferences(baseType, dereferences);
            return targetType.isPresent();
        }

        public static List<ColumnMapping> extractRegularAndInterimColumnMappings(List<ColumnMapping> columnMappings) {
            return (List)columnMappings.stream().filter(columnMapping -> columnMapping.getKind() == ColumnMappingKind.REGULAR || columnMapping.getKind() == ColumnMappingKind.INTERIM).collect(ImmutableList.toImmutableList());
        }

        public static List<HiveColumnHandle> toColumnHandles(List<ColumnMapping> regularColumnMappings, TypeManager typeManager, CoercionUtils.CoercionContext coercionContext) {
            return regularColumnMappings.stream().map(columnMapping -> {
                HiveColumnHandle columnHandle = columnMapping.getHiveColumnHandle();
                if (columnMapping.getBaseTypeCoercionFrom().isEmpty()) {
                    return columnHandle;
                }
                HiveType fromHiveTypeBase = columnMapping.getBaseTypeCoercionFrom().get();
                Optional<HiveColumnProjectionInfo> newColumnProjectionInfo = columnHandle.getHiveColumnProjectionInfo().map(projectedColumn -> {
                    HiveType fromHiveType = HiveTypeUtil.getHiveTypeForDereferences(fromHiveTypeBase, projectedColumn.getDereferenceIndices()).get();
                    return new HiveColumnProjectionInfo(projectedColumn.getDereferenceIndices(), projectedColumn.getDereferenceNames(), fromHiveType, CoercionUtils.createTypeFromCoercer(typeManager, fromHiveType, columnHandle.getHiveType(), coercionContext));
                });
                return new HiveColumnHandle(columnHandle.getBaseColumnName(), columnHandle.getBaseHiveColumnIndex(), fromHiveTypeBase, CoercionUtils.createTypeFromCoercer(typeManager, fromHiveTypeBase, columnHandle.getBaseHiveType(), coercionContext), newColumnProjectionInfo, columnHandle.getColumnType(), columnHandle.getComment());
            }).collect(Collectors.toList());
        }
    }

    public static class BucketAdaptation {
        private final int[] bucketColumnIndices;
        private final List<HiveType> bucketColumnHiveTypes;
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final int tableBucketCount;
        private final int partitionBucketCount;
        private final int bucketToKeep;

        public BucketAdaptation(int[] bucketColumnIndices, List<HiveType> bucketColumnHiveTypes, HiveBucketing.BucketingVersion bucketingVersion, int tableBucketCount, int partitionBucketCount, int bucketToKeep) {
            this.bucketColumnIndices = bucketColumnIndices;
            this.bucketColumnHiveTypes = bucketColumnHiveTypes;
            this.bucketingVersion = bucketingVersion;
            this.tableBucketCount = tableBucketCount;
            this.partitionBucketCount = partitionBucketCount;
            this.bucketToKeep = bucketToKeep;
        }

        public int[] getBucketColumnIndices() {
            return this.bucketColumnIndices;
        }

        public List<HiveType> getBucketColumnHiveTypes() {
            return this.bucketColumnHiveTypes;
        }

        public HiveBucketing.BucketingVersion getBucketingVersion() {
            return this.bucketingVersion;
        }

        public int getTableBucketCount() {
            return this.tableBucketCount;
        }

        public int getPartitionBucketCount() {
            return this.partitionBucketCount;
        }

        public int getBucketToKeep() {
            return this.bucketToKeep;
        }
    }

    public static enum ColumnMappingKind {
        REGULAR,
        PREFILLED,
        INTERIM,
        SYNTHESIZED,
        EMPTY;

    }
}

