/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.metastore.HivePartition;
import io.trino.metastore.HiveTypeName;
import io.trino.metastore.Partition;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HivePartitionMetadata {
    private final Optional<Partition> partition;
    private final HivePartition hivePartition;
    private final Map<Integer, HiveTypeName> hiveColumnCoercions;

    HivePartitionMetadata(HivePartition hivePartition, Optional<Partition> partition, Map<Integer, HiveTypeName> hiveColumnCoercions) {
        this.partition = Objects.requireNonNull(partition, "partition is null");
        this.hivePartition = Objects.requireNonNull(hivePartition, "hivePartition is null");
        this.hiveColumnCoercions = ImmutableMap.copyOf(Objects.requireNonNull(hiveColumnCoercions, "hiveColumnCoercions is null"));
    }

    public HivePartition getHivePartition() {
        return this.hivePartition;
    }

    public Optional<Partition> getPartition() {
        return this.partition;
    }

    public Map<Integer, HiveTypeName> getHiveColumnCoercions() {
        return this.hiveColumnCoercions;
    }
}

