/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import io.airlift.slice.SizeOf;
import io.trino.plugin.base.util.Closables;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.metrics.Metrics;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.ObjLongConsumer;

public final class TransformConnectorPageSource
implements ConnectorPageSource {
    private final ConnectorPageSource connectorPageSource;
    private final Function<SourcePage, SourcePage> transform;

    @CheckReturnValue
    public static TransformConnectorPageSource create(ConnectorPageSource connectorPageSource, Function<SourcePage, SourcePage> transform) {
        return new TransformConnectorPageSource(connectorPageSource, transform);
    }

    private TransformConnectorPageSource(ConnectorPageSource connectorPageSource, Function<SourcePage, SourcePage> transform) {
        this.connectorPageSource = Objects.requireNonNull(connectorPageSource, "connectorPageSource is null");
        this.transform = Objects.requireNonNull(transform, "transform is null");
    }

    public long getCompletedBytes() {
        return this.connectorPageSource.getCompletedBytes();
    }

    public OptionalLong getCompletedPositions() {
        return this.connectorPageSource.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.connectorPageSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.connectorPageSource.isFinished();
    }

    public SourcePage getNextSourcePage() {
        try {
            SourcePage page = this.connectorPageSource.getNextSourcePage();
            if (page == null) {
                return null;
            }
            return this.transform.apply(page);
        }
        catch (Throwable e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this.connectorPageSource});
            throw e;
        }
    }

    public long getMemoryUsage() {
        return this.connectorPageSource.getMemoryUsage();
    }

    public void close() throws IOException {
        this.connectorPageSource.close();
    }

    public CompletableFuture<?> isBlocked() {
        return this.connectorPageSource.isBlocked();
    }

    public Metrics getMetrics() {
        return this.connectorPageSource.getMetrics();
    }

    @CheckReturnValue
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<Function<SourcePage, Block>> transforms = new ArrayList<Function<SourcePage, Block>>();
        private boolean requiresTransform;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder constantValue(Block constantValue) {
            this.requiresTransform = true;
            this.transforms.add(new ConstantValue(constantValue));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder column(int inputField) {
            return this.column(inputField, Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder column(int inputField, Optional<Function<Block, Block>> transform) {
            if (transform.isPresent()) {
                return this.transform(inputField, transform.get());
            }
            if (inputField != this.transforms.size()) {
                this.requiresTransform = true;
            }
            this.transforms.add(new InputColumn(inputField));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder dereferenceField(List<Integer> path) {
            return this.dereferenceField(path, Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder dereferenceField(List<Integer> path, Optional<Function<Block, Block>> transform) {
            Objects.requireNonNull(path, "path is null");
            if (path.size() == 1) {
                return this.column(path.getFirst(), transform);
            }
            this.requiresTransform = true;
            this.transforms.add(new DereferenceFieldTransform(path, transform));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder transform(int inputColumn, Function<Block, Block> transform) {
            Objects.requireNonNull(transform, "transform is null");
            this.requiresTransform = true;
            this.transforms.add(new TransformBlock(transform, inputColumn));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder transform(Function<SourcePage, Block> transform) {
            this.requiresTransform = true;
            this.transforms.add(transform);
            return this;
        }

        @CheckReturnValue
        public ConnectorPageSource build(ConnectorPageSource pageSource) {
            if (!this.requiresTransform) {
                return pageSource;
            }
            List<Function<SourcePage, Block>> functions = List.copyOf(this.transforms);
            return new TransformConnectorPageSource(pageSource, new TransformPages(functions));
        }
    }

    private record TransformSourcePage(SourcePage sourcePage, List<Function<SourcePage, Block>> transforms, Block[] blocks) implements SourcePage
    {
        private static final long INSTANCE_SIZE = SizeOf.instanceSize(TransformSourcePage.class);

        private TransformSourcePage(SourcePage sourcePage, List<Function<SourcePage, Block>> transforms) {
            this(sourcePage, transforms, new Block[transforms.size()]);
        }

        private TransformSourcePage {
            Objects.requireNonNull(sourcePage, "sourcePage is null");
            transforms = List.copyOf((Collection)Objects.requireNonNull(transforms, "transforms is null"));
            Objects.requireNonNull(blocks, "blocks is null");
            Preconditions.checkArgument((transforms.size() == blocks.length ? 1 : 0) != 0, (Object)"transforms and blocks size mismatch");
        }

        public int getPositionCount() {
            return this.sourcePage.getPositionCount();
        }

        public long getSizeInBytes() {
            return this.sourcePage.getSizeInBytes();
        }

        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.blocks) + this.sourcePage.getRetainedSizeInBytes();
        }

        public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
            consumer.accept(this, INSTANCE_SIZE);
            consumer.accept(this.blocks, SizeOf.sizeOf((Object[])this.blocks));
            for (Block block : this.blocks) {
                if (block == null) continue;
                block.retainedBytesForEachPart(consumer);
            }
            this.sourcePage.retainedBytesForEachPart(consumer);
        }

        public int getChannelCount() {
            return this.blocks.length;
        }

        public Block getBlock(int channel) {
            Block block = this.blocks[channel];
            if (block == null) {
                this.blocks[channel] = block = this.transforms.get(channel).apply(this.sourcePage);
            }
            return block;
        }

        public Page getPage() {
            for (int i = 0; i < this.blocks.length; ++i) {
                this.getBlock(i);
            }
            return new Page(this.getPositionCount(), this.blocks);
        }

        public void selectPositions(int[] positions, int offset, int size) {
            this.sourcePage.selectPositions(positions, offset, size);
            for (int i = 0; i < this.blocks.length; ++i) {
                Block block = this.blocks[i];
                if (block == null) continue;
                this.blocks[i] = block.getPositions(positions, offset, size);
            }
        }
    }

    private record TransformPages(List<Function<SourcePage, Block>> functions) implements Function<SourcePage, SourcePage>
    {
        private TransformPages {
            functions = List.copyOf((Collection)Objects.requireNonNull(functions, "functions is null"));
        }

        @Override
        public SourcePage apply(SourcePage page) {
            return new TransformSourcePage(page, this.functions);
        }
    }

    private record TransformBlock(Function<Block, Block> transform, int inputColumn) implements Function<SourcePage, Block>
    {
        @Override
        public Block apply(SourcePage page) {
            return this.transform.apply(page.getBlock(this.inputColumn));
        }
    }

    private record DereferenceFieldTransform(List<Integer> path, Optional<Function<Block, Block>> transform) implements Function<SourcePage, Block>
    {
        private DereferenceFieldTransform {
            path = ImmutableList.copyOf((Collection)Objects.requireNonNull(path, "path is null"));
            Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (Object)"path is empty");
            Preconditions.checkArgument((boolean)path.stream().allMatch(element -> element >= 0), (Object)"path element is negative");
            Objects.requireNonNull(transform, "transform is null");
        }

        @Override
        public Block apply(SourcePage sourcePage) {
            Block block = sourcePage.getBlock(this.path.getFirst().intValue());
            for (int dereferenceIndex : this.path.subList(1, this.path.size())) {
                block = (Block)RowBlock.getRowFieldsFromBlock((Block)block).get(dereferenceIndex);
            }
            if (this.transform.isPresent()) {
                block = this.transform.get().apply(block);
            }
            return block;
        }
    }

    private record InputColumn(int inputField) implements Function<SourcePage, Block>
    {
        @Override
        public Block apply(SourcePage page) {
            return page.getBlock(this.inputField);
        }
    }

    private record ConstantValue(Block constantValue) implements Function<SourcePage, Block>
    {
        @Override
        public Block apply(SourcePage page) {
            return RunLengthEncodedBlock.create((Block)this.constantValue, (int)page.getPositionCount());
        }
    }
}

