/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import io.trino.filesystem.Location;
import io.trino.spi.connector.SchemaTableName;
import java.util.Objects;

public class TransactionDirectoryListingCacheKey {
    private static final long INSTANCE_SIZE = SizeOf.instanceSize(TransactionDirectoryListingCacheKey.class);
    private final long transactionId;
    private final Location path;
    private final SchemaTableName schemaTableName;

    public TransactionDirectoryListingCacheKey(long transactionId, Location path, SchemaTableName schemaTableName) {
        this.transactionId = transactionId;
        this.path = Objects.requireNonNull(path, "path is null");
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
    }

    public Location getPath() {
        return this.path;
    }

    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path.toString()) + this.schemaTableName.getRetainedSizeInBytes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionDirectoryListingCacheKey that = (TransactionDirectoryListingCacheKey)o;
        return this.transactionId == that.transactionId && this.path.equals((Object)that.path) && this.schemaTableName.equals((Object)that.schemaTableName);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.path, this.schemaTableName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("transactionId", this.transactionId).add("path", (Object)this.path).add("schemaTableName", (Object)this.schemaTableName).toString();
    }
}

