/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import io.trino.metastore.HiveMetastore;
import io.trino.metastore.Partition;
import io.trino.metastore.Table;
import io.trino.plugin.hive.metastore.HivePageSinkMetadata;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HivePageSinkMetadataProvider {
    private final HiveMetastore delegate;
    private final SchemaTableName schemaTableName;
    private final Optional<Table> table;
    private final Map<List<String>, Optional<Partition>> modifiedPartitions;

    public HivePageSinkMetadataProvider(HivePageSinkMetadata pageSinkMetadata, HiveMetastore delegate) {
        Objects.requireNonNull(pageSinkMetadata, "pageSinkMetadata is null");
        this.delegate = delegate;
        this.schemaTableName = pageSinkMetadata.getSchemaTableName();
        this.table = pageSinkMetadata.getTable();
        this.modifiedPartitions = pageSinkMetadata.getModifiedPartitions();
    }

    public Optional<Table> getTable() {
        return this.table;
    }

    public Optional<Partition> getPartition(List<String> partitionValues) {
        if (this.table.isEmpty() || this.table.get().getPartitionColumns().isEmpty()) {
            throw new IllegalArgumentException(String.format("Unexpected call to getPartition. Table name: %s", this.schemaTableName));
        }
        Optional<Partition> modifiedPartition = this.modifiedPartitions.get(partitionValues);
        if (modifiedPartition == null) {
            return this.delegate.getPartition(this.table.get(), partitionValues);
        }
        return modifiedPartition;
    }
}

