/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.inject.Inject;
import io.opentelemetry.api.trace.Tracer;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.tracing.TracingHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Optional;

public class GlueHiveMetastoreFactory
implements HiveMetastoreFactory {
    private final HiveMetastore metastore;

    @Inject
    public GlueHiveMetastoreFactory(GlueHiveMetastore metastore, Tracer tracer) {
        this.metastore = new TracingHiveMetastore(tracer, (HiveMetastore)metastore);
    }

    public boolean hasBuiltInCaching() {
        return true;
    }

    public boolean isImpersonationEnabled() {
        return false;
    }

    public HiveMetastore createMetastore(Optional<ConnectorIdentity> identity) {
        return this.metastore;
    }
}

