/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.alluxio.AlluxioFileSystem;
import io.trino.spi.security.ConnectorIdentity;

public class AlluxioFileSystemFactory
implements TrinoFileSystemFactory {
    private final AlluxioConfiguration conf;

    @Inject
    public AlluxioFileSystemFactory() {
        this(Configuration.global());
    }

    public AlluxioFileSystemFactory(AlluxioConfiguration conf) {
        this.conf = conf;
    }

    public TrinoFileSystem create(ConnectorIdentity identity) {
        FileSystemContext fsContext = FileSystemContext.create((AlluxioConfiguration)this.conf);
        FileSystem alluxioClient = FileSystem.Factory.create((FileSystemContext)fsContext);
        return new AlluxioFileSystem(alluxioClient);
    }
}

