/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.runtime.NotFoundRuntimeException;
import alluxio.grpc.OpenFilePOptions;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.alluxio.AlluxioFileSystemInput;
import io.trino.filesystem.alluxio.AlluxioTrinoInputStream;
import io.trino.filesystem.alluxio.AlluxioUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

public class AlluxioFileSystemInputFile
implements TrinoInputFile {
    private final Location location;
    private final FileSystem fileSystem;
    private final String mountRoot;
    private Optional<Instant> lastModified;
    private Long length;
    private URIStatus status;

    public AlluxioFileSystemInputFile(Location location, Long length, FileSystem fileSystem, String mountRoot, Optional<Instant> lastModified) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.mountRoot = Objects.requireNonNull(mountRoot, "mountRoot is null");
        this.length = length;
        this.lastModified = Objects.requireNonNull(lastModified, "lastModified is null");
    }

    public TrinoInput newInput() throws IOException {
        try {
            return new AlluxioFileSystemInput(this.openFile(), this);
        }
        catch (AlluxioException e) {
            throw new IOException("Error newInput() file: %s".formatted(this.location), e);
        }
    }

    public TrinoInputStream newStream() throws IOException {
        try {
            return new AlluxioTrinoInputStream(this.location, this.openFile(), this.getURIStatus());
        }
        catch (AlluxioException e) {
            throw new IOException("Error newStream() file: %s".formatted(this.location), e);
        }
    }

    private FileInStream openFile() throws IOException, AlluxioException {
        if (!this.exists()) {
            throw new FileNotFoundException("File does not exist: " + String.valueOf(this.location));
        }
        return this.fileSystem.openFile(this.getURIStatus(), OpenFilePOptions.getDefaultInstance());
    }

    private void loadFileStatus() throws IOException {
        if (this.status == null) {
            URIStatus fileStatus = this.getURIStatus();
            if (this.length == null) {
                this.length = fileStatus.getLength();
            }
            if (this.lastModified.isEmpty()) {
                this.lastModified = Optional.of(Instant.ofEpochMilli(fileStatus.getLastModificationTimeMs()));
            }
        }
    }

    private URIStatus getURIStatus() throws IOException {
        try {
            this.status = this.fileSystem.getStatus(AlluxioUtils.convertToAlluxioURI(this.location, this.mountRoot));
        }
        catch (FileDoesNotExistException | NotFoundRuntimeException e) {
            throw new FileNotFoundException("File does not exist: %s".formatted(this.location));
        }
        catch (AlluxioException | IOException e) {
            throw new IOException("Get status for file %s failed: %s".formatted(this.location, e.getMessage()), e);
        }
        return this.status;
    }

    public long length() throws IOException {
        if (this.length == null) {
            this.loadFileStatus();
        }
        return Objects.requireNonNull(this.length, "length is null");
    }

    public Instant lastModified() throws IOException {
        if (this.lastModified.isEmpty()) {
            this.loadFileStatus();
        }
        return this.lastModified.orElseThrow();
    }

    public boolean exists() throws IOException {
        try {
            return this.fileSystem.exists(AlluxioUtils.convertToAlluxioURI(this.location, this.mountRoot));
        }
        catch (AlluxioException e) {
            throw new IOException("fail to check file existence", e);
        }
    }

    public Location location() {
        return this.location;
    }

    public String toString() {
        return this.location().toString();
    }
}

