/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v3.gzip;

import io.airlift.compress.v3.gzip.JdkGzipHadoopInputStream;
import io.airlift.compress.v3.gzip.JdkGzipHadoopOutputStream;
import io.airlift.compress.v3.hadoop.HadoopInputStream;
import io.airlift.compress.v3.hadoop.HadoopOutputStream;
import io.airlift.compress.v3.hadoop.HadoopStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;

public class JdkGzipHadoopStreams
implements HadoopStreams {
    private static final int GZIP_BUFFER_SIZE = 8192;

    @Override
    public String getDefaultFileExtension() {
        return ".gz";
    }

    @Override
    public List<String> getHadoopCodecName() {
        return Collections.singletonList("org.apache.hadoop.io.compress.GzipCodec");
    }

    @Override
    public HadoopInputStream createInputStream(InputStream in) throws IOException {
        return new JdkGzipHadoopInputStream(in, 8192);
    }

    @Override
    public HadoopOutputStream createOutputStream(OutputStream out) throws IOException {
        return new JdkGzipHadoopOutputStream(out, 8192);
    }
}

