/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.annotation.NotThreadSafe;
import io.trino.hive.formats.avro.AvroTypeBlockHandler;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.AvroTypeUtils;
import io.trino.hive.formats.avro.BlockBuildingDecoder;
import io.trino.hive.formats.avro.RowBlockBuildingDecoder;
import io.trino.hive.formats.avro.model.ArrayReadAction;
import io.trino.hive.formats.avro.model.AvroReadAction;
import io.trino.hive.formats.avro.model.BooleanRead;
import io.trino.hive.formats.avro.model.BytesRead;
import io.trino.hive.formats.avro.model.DoubleRead;
import io.trino.hive.formats.avro.model.EnumReadAction;
import io.trino.hive.formats.avro.model.FixedRead;
import io.trino.hive.formats.avro.model.FloatRead;
import io.trino.hive.formats.avro.model.IntRead;
import io.trino.hive.formats.avro.model.LongRead;
import io.trino.hive.formats.avro.model.MapReadAction;
import io.trino.hive.formats.avro.model.NullRead;
import io.trino.hive.formats.avro.model.ReadErrorReadAction;
import io.trino.hive.formats.avro.model.ReadingUnionReadAction;
import io.trino.hive.formats.avro.model.RecordReadAction;
import io.trino.hive.formats.avro.model.StringRead;
import io.trino.hive.formats.avro.model.WrittenUnionReadAction;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;

public class BaseAvroTypeBlockHandlerImpls {
    static final long MAX_ARRAY_SIZE = 0x7FFFFFF7L;

    private BaseAvroTypeBlockHandlerImpls() {
    }

    public static Type baseTypeFor(Schema schema, AvroTypeBlockHandler delegate) throws AvroTypeException {
        return switch (schema.getType()) {
            default -> throw new MatchException(null, null);
            case Schema.Type.NULL -> throw new UnsupportedOperationException("No null column type support");
            case Schema.Type.BOOLEAN -> BooleanType.BOOLEAN;
            case Schema.Type.INT -> IntegerType.INTEGER;
            case Schema.Type.LONG -> BigintType.BIGINT;
            case Schema.Type.FLOAT -> RealType.REAL;
            case Schema.Type.DOUBLE -> DoubleType.DOUBLE;
            case Schema.Type.ENUM, Schema.Type.STRING -> VarcharType.VARCHAR;
            case Schema.Type.FIXED, Schema.Type.BYTES -> VarbinaryType.VARBINARY;
            case Schema.Type.ARRAY -> new ArrayType(delegate.typeFor(schema.getElementType()));
            case Schema.Type.MAP -> new MapType((Type)VarcharType.VARCHAR, delegate.typeFor(schema.getValueType()), new TypeOperators());
            case Schema.Type.RECORD -> {
                ImmutableList.Builder rowFieldTypes = ImmutableList.builder();
                for (Schema.Field field : schema.getFields()) {
                    rowFieldTypes.add((Object)new RowType.Field(Optional.of(field.name()), delegate.typeFor(field.schema())));
                }
                yield RowType.from((List)rowFieldTypes.build());
            }
            case Schema.Type.UNION -> {
                if (AvroTypeUtils.isSimpleNullableUnion(schema)) {
                    yield delegate.typeFor(AvroTypeUtils.unwrapNullableUnion(schema));
                }
                throw new AvroTypeException("Unable to read union with multiple non null types: " + String.valueOf(schema));
            }
        };
    }

    public static BlockBuildingDecoder baseBlockBuildingDecoderFor(AvroReadAction action, AvroTypeBlockHandler delegate) throws AvroTypeException {
        AvroReadAction avroReadAction = action;
        Objects.requireNonNull(avroReadAction);
        AvroReadAction avroReadAction2 = avroReadAction;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NullRead.class, BooleanRead.class, IntRead.class, LongRead.class, FloatRead.class, DoubleRead.class, BytesRead.class, FixedRead.class, StringRead.class, ArrayReadAction.class, MapReadAction.class, EnumReadAction.class, RecordReadAction.class, ReadingUnionReadAction.class, WrittenUnionReadAction.class, ReadErrorReadAction.class}, (AvroReadAction)avroReadAction2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                NullRead __ = (NullRead)avroReadAction2;
                yield NullBlockBuildingDecoder.INSTANCE;
            }
            case 1 -> {
                BooleanRead __ = (BooleanRead)avroReadAction2;
                yield BooleanBlockBuildingDecoder.INSTANCE;
            }
            case 2 -> {
                IntRead __ = (IntRead)avroReadAction2;
                yield IntBlockBuildingDecoder.INSTANCE;
            }
            case 3 -> {
                LongRead longRead = (LongRead)avroReadAction2;
                yield new LongBlockBuildingDecoder(longRead.getLongDecoder());
            }
            case 4 -> {
                FloatRead floatRead = (FloatRead)avroReadAction2;
                yield new FloatBlockBuildingDecoder(floatRead.getFloatDecoder());
            }
            case 5 -> {
                DoubleRead doubleRead = (DoubleRead)avroReadAction2;
                yield new DoubleBlockBuildingDecoder(doubleRead.getDoubleDecoder());
            }
            case 6 -> {
                BytesRead __ = (BytesRead)avroReadAction2;
                yield BytesBlockBuildingDecoder.INSTANCE;
            }
            case 7 -> {
                FixedRead __ = (FixedRead)avroReadAction2;
                yield new FixedBlockBuildingDecoder(action.readSchema().getFixedSize());
            }
            case 8 -> {
                StringRead __ = (StringRead)avroReadAction2;
                yield StringBlockBuildingDecoder.INSTANCE;
            }
            case 9 -> {
                ArrayReadAction arrayReadAction = (ArrayReadAction)avroReadAction2;
                yield new ArrayBlockBuildingDecoder(arrayReadAction, delegate);
            }
            case 10 -> {
                MapReadAction mapReadAction = (MapReadAction)avroReadAction2;
                yield new MapBlockBuildingDecoder(mapReadAction, delegate);
            }
            case 11 -> {
                EnumReadAction enumReadAction = (EnumReadAction)avroReadAction2;
                yield new EnumBlockBuildingDecoder(enumReadAction);
            }
            case 12 -> {
                RecordReadAction recordReadAction = (RecordReadAction)avroReadAction2;
                yield new RowBlockBuildingDecoder(recordReadAction, delegate);
            }
            case 13 -> {
                ReadingUnionReadAction readingUnionReadAction = (ReadingUnionReadAction)avroReadAction2;
                if (!AvroTypeUtils.isSimpleNullableUnion(readingUnionReadAction.readSchema())) {
                    throw new AvroTypeException("Unable to natively read into a non nullable union: " + String.valueOf(readingUnionReadAction.readSchema()));
                }
                yield delegate.blockBuildingDecoderFor(readingUnionReadAction.actualAction());
            }
            case 14 -> {
                WrittenUnionReadAction writtenUnionReadAction = (WrittenUnionReadAction)avroReadAction2;
                if (writtenUnionReadAction.unionEqiv() && !AvroTypeUtils.isSimpleNullableUnion(writtenUnionReadAction.readSchema())) {
                    throw new AvroTypeException("Unable to natively read into a non nullable union: " + String.valueOf(writtenUnionReadAction.readSchema()));
                }
                yield new WriterUnionBlockBuildingDecoder(writtenUnionReadAction, delegate);
            }
            case 15 -> {
                ReadErrorReadAction readErrorReadAction = (ReadErrorReadAction)avroReadAction2;
                throw new AvroTypeException("Incompatible read and write schema returned with error:\n " + String.valueOf(readErrorReadAction));
            }
        };
    }

    public static class NullBlockBuildingDecoder
    implements BlockBuildingDecoder {
        public static final NullBlockBuildingDecoder INSTANCE = new NullBlockBuildingDecoder();

        private NullBlockBuildingDecoder() {
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            decoder.readNull();
            builder.appendNull();
        }
    }

    static class BooleanBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private static final BooleanBlockBuildingDecoder INSTANCE = new BooleanBlockBuildingDecoder();

        BooleanBlockBuildingDecoder() {
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            BooleanType.BOOLEAN.writeBoolean(builder, decoder.readBoolean());
        }
    }

    public static class IntBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private static final IntBlockBuildingDecoder INSTANCE = new IntBlockBuildingDecoder();

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            IntegerType.INTEGER.writeLong(builder, (long)decoder.readInt());
        }
    }

    public static class LongBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private final AvroReadAction.LongIoFunction<Decoder> extractLong;

        public LongBlockBuildingDecoder(AvroReadAction.LongIoFunction<Decoder> extractLong) {
            this.extractLong = Objects.requireNonNull(extractLong, "extractLong is null");
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            BigintType.BIGINT.writeLong(builder, this.extractLong.apply(decoder));
        }
    }

    static class FloatBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private final AvroReadAction.FloatIoFunction<Decoder> extractFloat;

        public FloatBlockBuildingDecoder(AvroReadAction.FloatIoFunction<Decoder> extractFloat) {
            this.extractFloat = Objects.requireNonNull(extractFloat, "extractFloat is null");
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            RealType.REAL.writeLong(builder, (long)Float.floatToRawIntBits(this.extractFloat.apply(decoder)));
        }
    }

    static class DoubleBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private final AvroReadAction.DoubleIoFunction<Decoder> extractDouble;

        public DoubleBlockBuildingDecoder(AvroReadAction.DoubleIoFunction<Decoder> extractDouble) {
            this.extractDouble = Objects.requireNonNull(extractDouble, "extractDouble is null");
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            DoubleType.DOUBLE.writeDouble(builder, this.extractDouble.apply(decoder));
        }
    }

    static class BytesBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private static final BytesBlockBuildingDecoder INSTANCE = new BytesBlockBuildingDecoder();

        BytesBlockBuildingDecoder() {
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            long size = decoder.readLong();
            if (size > 0x7FFFFFF7L) {
                throw new IOException("Unable to read avro Bytes with size greater than %s. Found Bytes size: %s".formatted(0x7FFFFFF7L, size));
            }
            byte[] bytes = new byte[(int)size];
            decoder.readFixed(bytes);
            VarbinaryType.VARBINARY.writeSlice(builder, Slices.wrappedBuffer((byte[])bytes));
        }
    }

    @NotThreadSafe
    static class FixedBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private final byte[] bytes;

        public FixedBlockBuildingDecoder(int expectedSize) {
            Verify.verify((expectedSize >= 0 ? 1 : 0) != 0, (String)"expected size must be greater than or equal to 0", (Object[])new Object[0]);
            this.bytes = new byte[expectedSize];
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            decoder.readFixed(this.bytes);
            VarbinaryType.VARBINARY.writeSlice(builder, Slices.wrappedBuffer((byte[])this.bytes));
        }
    }

    static class StringBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private static final StringBlockBuildingDecoder INSTANCE = new StringBlockBuildingDecoder();

        StringBlockBuildingDecoder() {
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            long size = decoder.readLong();
            if (size > 0x7FFFFFF7L) {
                throw new IOException("Unable to read avro String with size greater than %s. Found String size: %s".formatted(0x7FFFFFF7L, size));
            }
            byte[] bytes = new byte[(int)size];
            decoder.readFixed(bytes);
            VarcharType.VARCHAR.writeSlice(builder, Slices.wrappedBuffer((byte[])bytes));
        }
    }

    static class ArrayBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private final BlockBuildingDecoder elementBlockBuildingDecoder;

        public ArrayBlockBuildingDecoder(ArrayReadAction arrayReadAction, AvroTypeBlockHandler typeManager) throws AvroTypeException {
            Objects.requireNonNull(arrayReadAction, "arrayReadAction is null");
            this.elementBlockBuildingDecoder = typeManager.blockBuildingDecoderFor(arrayReadAction.elementReadAction());
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            ((ArrayBlockBuilder)builder).buildEntry(elementBuilder -> {
                long elementsInBlock = decoder.readArrayStart();
                if (elementsInBlock > 0L) {
                    do {
                        int i = 0;
                        while ((long)i < elementsInBlock) {
                            this.elementBlockBuildingDecoder.decodeIntoBlock(decoder, elementBuilder);
                            ++i;
                        }
                    } while ((elementsInBlock = decoder.arrayNext()) > 0L);
                }
            });
        }
    }

    static class MapBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private final BlockBuildingDecoder keyBlockBuildingDecoder = new StringBlockBuildingDecoder();
        private final BlockBuildingDecoder valueBlockBuildingDecoder;

        public MapBlockBuildingDecoder(MapReadAction mapReadAction, AvroTypeBlockHandler typeManager) throws AvroTypeException {
            Objects.requireNonNull(mapReadAction, "mapReadAction is null");
            this.valueBlockBuildingDecoder = typeManager.blockBuildingDecoderFor(mapReadAction.valueReadAction());
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            ((MapBlockBuilder)builder).buildEntry((keyBuilder, valueBuilder) -> {
                long entriesInBlock = decoder.readMapStart();
                if (entriesInBlock > 0L) {
                    do {
                        int i = 0;
                        while ((long)i < entriesInBlock) {
                            this.keyBlockBuildingDecoder.decodeIntoBlock(decoder, keyBuilder);
                            this.valueBlockBuildingDecoder.decodeIntoBlock(decoder, valueBuilder);
                            ++i;
                        }
                    } while ((entriesInBlock = decoder.mapNext()) > 0L);
                }
            });
        }
    }

    static class EnumBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private final List<Slice> symbols;

        public EnumBlockBuildingDecoder(EnumReadAction enumReadAction) {
            Objects.requireNonNull(enumReadAction, "action is null");
            this.symbols = enumReadAction.getSymbolIndex();
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            VarcharType.VARCHAR.writeSlice(builder, this.symbols.get(decoder.readEnum()));
        }
    }

    static class WriterUnionBlockBuildingDecoder
    implements BlockBuildingDecoder {
        protected final BlockBuildingDecoder[] blockBuildingDecoders;

        public WriterUnionBlockBuildingDecoder(WrittenUnionReadAction writtenUnionReadAction, AvroTypeBlockHandler typeManager) throws AvroTypeException {
            Objects.requireNonNull(writtenUnionReadAction, "writerUnion is null");
            this.blockBuildingDecoders = new BlockBuildingDecoder[writtenUnionReadAction.writeOptionReadActions().size()];
            for (int i = 0; i < writtenUnionReadAction.writeOptionReadActions().size(); ++i) {
                this.blockBuildingDecoders[i] = typeManager.blockBuildingDecoderFor(writtenUnionReadAction.writeOptionReadActions().get(i));
            }
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            this.decodeIntoBlock(decoder.readIndex(), decoder, builder);
        }

        protected void decodeIntoBlock(int blockBuilderIndex, Decoder decoder, BlockBuilder builder) throws IOException {
            this.blockBuildingDecoders[blockBuilderIndex].decodeIntoBlock(decoder, builder);
        }
    }
}

