/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import com.google.common.base.Preconditions;
import io.trino.hive.formats.avro.AvroTypeBlockHandler;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.BlockBuildingDecoder;
import io.trino.hive.formats.avro.model.AvroReadAction;
import io.trino.hive.formats.avro.model.DefaultValueFieldRecordFieldReadAction;
import io.trino.hive.formats.avro.model.ReadFieldAction;
import io.trino.hive.formats.avro.model.RecordFieldReadAction;
import io.trino.hive.formats.avro.model.RecordReadAction;
import io.trino.hive.formats.avro.model.SkipFieldRecordFieldReadAction;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.IntFunction;
import org.apache.avro.Resolver;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;

public class RowBlockBuildingDecoder
implements BlockBuildingDecoder {
    private final RowBuildingAction[] buildSteps;

    public RowBlockBuildingDecoder(Schema writeSchema, Schema readSchema, AvroTypeBlockHandler typeManager) throws AvroTypeException {
        this(AvroReadAction.fromAction(Resolver.resolve((Schema)writeSchema, (Schema)readSchema, (GenericData)new GenericData())), typeManager);
    }

    public RowBlockBuildingDecoder(AvroReadAction action, AvroTypeBlockHandler typeManager) throws AvroTypeException {
        if (!(action instanceof RecordReadAction)) {
            throw new AvroTypeException("Write and Read Schemas must be records when building a row block building decoder. Illegal action: " + String.valueOf(action));
        }
        RecordReadAction recordReadAction = (RecordReadAction)action;
        this.buildSteps = new RowBuildingAction[recordReadAction.fieldReadActions().size()];
        int i = 0;
        for (RecordFieldReadAction fieldAction : recordReadAction.fieldReadActions()) {
            RecordFieldReadAction recordFieldReadAction;
            Objects.requireNonNull(fieldAction);
            int n = 0;
            this.buildSteps[i] = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DefaultValueFieldRecordFieldReadAction.class, ReadFieldAction.class, SkipFieldRecordFieldReadAction.class}, (RecordFieldReadAction)recordFieldReadAction, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    DefaultValueFieldRecordFieldReadAction defaultValueFieldRecordFieldReadAction = (DefaultValueFieldRecordFieldReadAction)recordFieldReadAction;
                    yield new ConstantBlockAction(RowBlockBuildingDecoder.getDefaultBlockBuilder(defaultValueFieldRecordFieldReadAction.fieldSchema(), defaultValueFieldRecordFieldReadAction.defaultBytes(), typeManager), defaultValueFieldRecordFieldReadAction.outputChannel());
                }
                case 1 -> {
                    ReadFieldAction readFieldAction = (ReadFieldAction)recordFieldReadAction;
                    yield new BuildIntoBlockAction(typeManager.blockBuildingDecoderFor(readFieldAction.readAction()), readFieldAction.outputChannel());
                }
                case 2 -> {
                    SkipFieldRecordFieldReadAction skipFieldRecordFieldReadAction = (SkipFieldRecordFieldReadAction)recordFieldReadAction;
                    yield new SkipSchemaBuildingAction(skipFieldRecordFieldReadAction.skipAction());
                }
            };
            ++i;
        }
    }

    @Override
    public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
        ((RowBlockBuilder)builder).buildEntry(fieldBuilders -> this.decodeIntoBlockProvided(decoder, fieldBuilders::get));
    }

    protected void decodeIntoPageBuilder(Decoder decoder, PageBuilder builder) throws IOException {
        builder.declarePosition();
        this.decodeIntoBlockProvided(decoder, arg_0 -> ((PageBuilder)builder).getBlockBuilder(arg_0));
    }

    protected void decodeIntoBlockProvided(Decoder decoder, IntFunction<BlockBuilder> fieldBlockBuilder) throws IOException {
        block5: for (RowBuildingAction buildStep : this.buildSteps) {
            RowBuildingAction rowBuildingAction;
            Objects.requireNonNull(buildStep);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SkipSchemaBuildingAction.class, BuildIntoBlockAction.class, ConstantBlockAction.class}, (RowBuildingAction)rowBuildingAction, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    SkipSchemaBuildingAction skipSchemaBuildingAction = (SkipSchemaBuildingAction)rowBuildingAction;
                    skipSchemaBuildingAction.skip(decoder);
                    continue block5;
                }
                case 1: {
                    BuildIntoBlockAction buildIntoBlockAction = (BuildIntoBlockAction)rowBuildingAction;
                    buildIntoBlockAction.decode(decoder, fieldBlockBuilder);
                    continue block5;
                }
                case 2: {
                    ConstantBlockAction constantBlockAction = (ConstantBlockAction)rowBuildingAction;
                    constantBlockAction.addConstant(fieldBlockBuilder);
                }
            }
        }
    }

    private static AvroReadAction.IoConsumer<BlockBuilder> getDefaultBlockBuilder(Schema fieldSchema, byte[] defaultBytes, AvroTypeBlockHandler typeManager) throws AvroTypeException {
        BlockBuildingDecoder buildingDecoder = typeManager.blockBuildingDecoderFor(AvroReadAction.fromAction(Resolver.resolve((Schema)fieldSchema, (Schema)fieldSchema)));
        BinaryDecoder reuse = DecoderFactory.get().binaryDecoder(defaultBytes, null);
        return blockBuilder -> buildingDecoder.decodeIntoBlock((Decoder)DecoderFactory.get().binaryDecoder(defaultBytes, reuse), (BlockBuilder)blockBuilder);
    }

    static sealed interface RowBuildingAction
    permits BuildIntoBlockAction, ConstantBlockAction, SkipSchemaBuildingAction {
    }

    protected static final class ConstantBlockAction
    implements RowBuildingAction {
        private final AvroReadAction.IoConsumer<BlockBuilder> addConstantFunction;
        private final int outputChannel;

        public ConstantBlockAction(AvroReadAction.IoConsumer<BlockBuilder> addConstantFunction, int outputChannel) {
            this.addConstantFunction = Objects.requireNonNull(addConstantFunction, "addConstantFunction is null");
            Preconditions.checkArgument((outputChannel >= 0 ? 1 : 0) != 0, (Object)"outputChannel must be positive");
            this.outputChannel = outputChannel;
        }

        public void addConstant(IntFunction<BlockBuilder> channelSelector) throws IOException {
            this.addConstantFunction.accept(channelSelector.apply(this.outputChannel));
        }
    }

    private static final class BuildIntoBlockAction
    implements RowBuildingAction {
        private final BlockBuildingDecoder delegate;
        private final int outputChannel;

        public BuildIntoBlockAction(BlockBuildingDecoder delegate, int outputChannel) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            Preconditions.checkArgument((outputChannel >= 0 ? 1 : 0) != 0, (Object)"outputChannel must be positive");
            this.outputChannel = outputChannel;
        }

        public void decode(Decoder decoder, IntFunction<BlockBuilder> channelSelector) throws IOException {
            this.delegate.decodeIntoBlock(decoder, channelSelector.apply(this.outputChannel));
        }
    }

    public static final class SkipSchemaBuildingAction
    implements RowBuildingAction {
        private final SkipFieldRecordFieldReadAction.SkipAction skipAction;

        SkipSchemaBuildingAction(SkipFieldRecordFieldReadAction.SkipAction skipAction) {
            this.skipAction = Objects.requireNonNull(skipAction, "skipAction is null");
        }

        public void skip(Decoder decoder) throws IOException {
            this.skipAction.skip(decoder);
        }
    }
}

