/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.compression;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Arrays;

public class BufferedOutputStreamSliceOutput
extends SliceOutput {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(BufferedOutputStreamSliceOutput.class);
    private static final int CHUNK_SIZE = 4096;
    private final OutputStream outputStream;
    private final Slice slice;
    private final byte[] buffer;
    private long bufferOffset;
    private int bufferPosition;

    public BufferedOutputStreamSliceOutput(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("outputStream is null");
        }
        this.outputStream = outputStream;
        this.buffer = new byte[4096];
        this.slice = Slices.wrappedBuffer((byte[])this.buffer);
    }

    public void flush() throws IOException {
        this.flushBufferToOutputStream();
        this.outputStream.flush();
    }

    public void close() throws IOException {
        try {
            this.flushBufferToOutputStream();
        }
        finally {
            this.outputStream.close();
        }
    }

    public void reset() {
        throw new UnsupportedOperationException("OutputStream cannot be reset");
    }

    public void reset(int position) {
        throw new UnsupportedOperationException("OutputStream cannot be reset");
    }

    public int size() {
        return Math.toIntExact(this.bufferOffset + (long)this.bufferPosition);
    }

    public long getRetainedSize() {
        return this.slice.getRetainedSize() + (long)INSTANCE_SIZE;
    }

    public int writableBytes() {
        return Integer.MAX_VALUE;
    }

    public boolean isWritable() {
        return true;
    }

    public void writeByte(int value) {
        this.ensureWritableBytes(1);
        this.slice.setByte(this.bufferPosition, value);
        ++this.bufferPosition;
    }

    public void writeShort(int value) {
        this.ensureWritableBytes(2);
        this.slice.setShort(this.bufferPosition, value);
        this.bufferPosition += 2;
    }

    public void writeInt(int value) {
        this.ensureWritableBytes(4);
        this.slice.setInt(this.bufferPosition, value);
        this.bufferPosition += 4;
    }

    public void writeLong(long value) {
        this.ensureWritableBytes(8);
        this.slice.setLong(this.bufferPosition, value);
        this.bufferPosition += 8;
    }

    public void writeFloat(float value) {
        this.writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeBytes(Slice source) {
        this.writeBytes(source, 0, source.length());
    }

    public void writeBytes(Slice source, int sourceIndex, int length) {
        if (length >= 4096) {
            if (this.bufferPosition > 0) {
                int flushLength = this.getFreeBufferLength();
                this.slice.setBytes(this.bufferPosition, source, sourceIndex, flushLength);
                this.bufferPosition = 4096;
                this.flushBufferToOutputStream();
                sourceIndex += flushLength;
                length -= flushLength;
            }
            while (length >= 4096) {
                this.writeToOutputStream(source, sourceIndex, 4096);
                sourceIndex += 4096;
                length -= 4096;
                this.bufferOffset += 4096L;
            }
        }
        if (length > 0) {
            this.ensureWritableBytes(length);
            this.slice.setBytes(this.bufferPosition, source, sourceIndex, length);
            this.bufferPosition += length;
        }
    }

    public void writeBytes(byte[] source) {
        this.writeBytes(source, 0, source.length);
    }

    public void writeBytes(byte[] source, int sourceIndex, int length) {
        if (length >= 4096) {
            if (this.bufferPosition > 0) {
                int flushLength = this.getFreeBufferLength();
                this.slice.setBytes(this.bufferPosition, source, sourceIndex, flushLength);
                this.bufferPosition = 4096;
                this.flushBufferToOutputStream();
                sourceIndex += flushLength;
                length -= flushLength;
            }
            while (length >= 4096) {
                this.writeToOutputStream(source, sourceIndex, 4096);
                sourceIndex += 4096;
                length -= 4096;
                this.bufferOffset += 4096L;
            }
        }
        if (length > 0) {
            this.ensureWritableBytes(length);
            this.slice.setBytes(this.bufferPosition, source, sourceIndex, length);
            this.bufferPosition += length;
        }
    }

    public void writeShorts(short[] source, int sourceIndex, int length) {
        while (length > 0) {
            int flushLength = this.ensureBatchSize(length * 2) / 2;
            this.slice.setShorts(this.bufferPosition, source, sourceIndex, flushLength);
            this.bufferPosition += flushLength * 2;
            sourceIndex += flushLength;
            length -= flushLength;
        }
    }

    public void writeInts(int[] source, int sourceIndex, int length) {
        while (length > 0) {
            int flushLength = this.ensureBatchSize(length * 4) / 4;
            this.slice.setInts(this.bufferPosition, source, sourceIndex, flushLength);
            this.bufferPosition += flushLength * 4;
            sourceIndex += flushLength;
            length -= flushLength;
        }
    }

    public void writeLongs(long[] source, int sourceIndex, int length) {
        while (length > 0) {
            int flushLength = this.ensureBatchSize(length * 8) / 8;
            this.slice.setLongs(this.bufferPosition, source, sourceIndex, flushLength);
            this.bufferPosition += flushLength * 8;
            sourceIndex += flushLength;
            length -= flushLength;
        }
    }

    public void writeFloats(float[] source, int sourceIndex, int length) {
        while (length > 0) {
            int flushLength = this.ensureBatchSize(length * 4) / 4;
            this.slice.setFloats(this.bufferPosition, source, sourceIndex, flushLength);
            this.bufferPosition += flushLength * 4;
            sourceIndex += flushLength;
            length -= flushLength;
        }
    }

    public void writeDoubles(double[] source, int sourceIndex, int length) {
        while (length > 0) {
            int flushLength = this.ensureBatchSize(length * 8) / 8;
            this.slice.setDoubles(this.bufferPosition, source, sourceIndex, flushLength);
            this.bufferPosition += flushLength * 8;
            sourceIndex += flushLength;
            length -= flushLength;
        }
    }

    public void writeBytes(InputStream in, int length) throws IOException {
        while (length > 0) {
            int batch = this.ensureBatchSize(length);
            this.slice.setBytes(this.bufferPosition, in, batch);
            this.bufferPosition += batch;
            length -= batch;
        }
    }

    public void writeZero(int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length must be 0 or greater than 0.");
        while (length > 0) {
            int batch = this.ensureBatchSize(length);
            Arrays.fill(this.buffer, this.bufferPosition, this.bufferPosition + batch, (byte)0);
            this.bufferPosition += batch;
            length -= batch;
        }
    }

    public SliceOutput appendLong(long value) {
        this.writeLong(value);
        return this;
    }

    public SliceOutput appendDouble(double value) {
        this.writeDouble(value);
        return this;
    }

    public SliceOutput appendInt(int value) {
        this.writeInt(value);
        return this;
    }

    public SliceOutput appendShort(int value) {
        this.writeShort(value);
        return this;
    }

    public SliceOutput appendByte(int value) {
        this.writeByte(value);
        return this;
    }

    public SliceOutput appendBytes(byte[] source, int sourceIndex, int length) {
        this.writeBytes(source, sourceIndex, length);
        return this;
    }

    public SliceOutput appendBytes(byte[] source) {
        this.writeBytes(source);
        return this;
    }

    public SliceOutput appendBytes(Slice slice) {
        this.writeBytes(slice);
        return this;
    }

    public Slice slice() {
        throw new UnsupportedOperationException();
    }

    public Slice getUnderlyingSlice() {
        throw new UnsupportedOperationException();
    }

    public String toString(Charset charset) {
        return this.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OutputStreamSliceOutputAdapter{");
        builder.append("outputStream=").append(this.outputStream);
        builder.append("bufferSize=").append(this.slice.length());
        builder.append('}');
        return builder.toString();
    }

    private int getFreeBufferLength() {
        return 4096 - this.bufferPosition;
    }

    private void ensureWritableBytes(int minWritableBytes) {
        if (minWritableBytes > this.getFreeBufferLength()) {
            this.flushBufferToOutputStream();
        }
    }

    private int ensureBatchSize(int length) {
        this.ensureWritableBytes(Math.min(4096, length));
        return Math.min(length, 4096 - this.bufferPosition);
    }

    private void flushBufferToOutputStream() {
        this.writeToOutputStream(this.buffer, 0, this.bufferPosition);
        this.bufferOffset += (long)this.bufferPosition;
        this.bufferPosition = 0;
    }

    private void writeToOutputStream(byte[] source, int sourceIndex, int length) {
        try {
            this.outputStream.write(source, sourceIndex, length);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeToOutputStream(Slice source, int sourceIndex, int length) {
        try {
            source.getBytes(sourceIndex, this.outputStream, length);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

