/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.compression;

import io.airlift.compress.v3.hadoop.HadoopStreams;
import io.trino.hive.formats.compression.MemoryCompressedSliceOutput;
import io.trino.hive.formats.compression.ValueCompressor;
import io.trino.hive.formats.compression.ValueDecompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public final class Codec {
    private final HadoopStreams hadoopStreams;

    Codec(HadoopStreams hadoopStreams) {
        this.hadoopStreams = Objects.requireNonNull(hadoopStreams, "hadoopStreams is null");
    }

    public OutputStream createStreamCompressor(OutputStream outputStream) throws IOException {
        return this.hadoopStreams.createOutputStream(outputStream);
    }

    public ValueCompressor createValueCompressor() {
        return new ValueCompressor(this.hadoopStreams);
    }

    public MemoryCompressedSliceOutput createMemoryCompressedSliceOutput(int minChunkSize, int maxChunkSize) throws IOException {
        return new MemoryCompressedSliceOutput(this.hadoopStreams, minChunkSize, maxChunkSize);
    }

    public InputStream createStreamDecompressor(InputStream inputStream) throws IOException {
        return this.hadoopStreams.createInputStream(inputStream);
    }

    public ValueDecompressor createValueDecompressor() {
        return new ValueDecompressor(this.hadoopStreams);
    }
}

