/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.simple;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.hive.formats.FileCorruptionException;
import io.trino.hive.formats.encodings.text.TextColumnEncoding;
import io.trino.hive.formats.encodings.text.TextColumnEncodingFactory;
import io.trino.hive.formats.encodings.text.TextEncodingOptions;
import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineBuffer;
import io.trino.hive.formats.line.LineDeserializer;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class SimpleDeserializer
implements LineDeserializer {
    private final List<Column> columns;
    private final int[] readColumnIndexes;
    private final TextColumnEncoding[] columnEncodings;
    private final Slice nullSequence;
    private final byte separator;
    private final Byte escapeByte;
    private final boolean lastColumnTakesRest;

    public SimpleDeserializer(List<Column> columns, TextEncodingOptions textEncodingOptions, int tableColumnCount) {
        this.columns = ImmutableList.copyOf(columns);
        this.nullSequence = textEncodingOptions.getNullSequence();
        this.separator = textEncodingOptions.getSeparators().getByte(0);
        this.escapeByte = textEncodingOptions.getEscapeByte();
        this.lastColumnTakesRest = textEncodingOptions.isLastColumnTakesRest();
        this.columnEncodings = new TextColumnEncoding[tableColumnCount];
        this.readColumnIndexes = new int[tableColumnCount];
        Arrays.fill(this.readColumnIndexes, -1);
        TextColumnEncodingFactory columnEncodingFactory = new TextColumnEncodingFactory(textEncodingOptions);
        int i = 0;
        while (i < columns.size()) {
            Column column = columns.get(i);
            this.columnEncodings[column.ordinal()] = columnEncodingFactory.getEncoding(column.type());
            this.readColumnIndexes[column.ordinal()] = i++;
        }
    }

    @Override
    public List<? extends Type> getTypes() {
        return (List)this.columns.stream().map(Column::type).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void deserialize(LineBuffer lineBuffer, PageBuilder builder) throws IOException {
        int offset;
        builder.declarePosition();
        byte[] buffer = lineBuffer.getBuffer();
        Slice line = Slices.wrappedBuffer((byte[])buffer, (int)0, (int)lineBuffer.getLength());
        int length = line.length();
        int end = offset + length;
        int elementOffset = offset;
        int fieldIndex = 0;
        for (offset = 0; offset < end; ++offset) {
            byte currentByte = buffer[offset];
            if (currentByte == this.separator) {
                this.decodeElementValueInto(fieldIndex, builder, line, elementOffset, offset - elementOffset);
                elementOffset = offset + 1;
                if (!this.lastColumnTakesRest || ++fieldIndex != this.columnEncodings.length - 1) continue;
                break;
            }
            if (this.escapeByte == null || currentByte != this.escapeByte) continue;
            ++offset;
        }
        this.decodeElementValueInto(fieldIndex, builder, line, elementOffset, end - elementOffset);
        ++fieldIndex;
        while (fieldIndex < this.columnEncodings.length) {
            int ordinal = this.readColumnIndexes[fieldIndex];
            if (ordinal >= 0) {
                builder.getBlockBuilder(ordinal).appendNull();
            }
            ++fieldIndex;
        }
    }

    private void decodeElementValueInto(int fieldIndex, PageBuilder builder, Slice slice, int offset, int length) throws FileCorruptionException {
        if (fieldIndex >= this.columnEncodings.length) {
            return;
        }
        TextColumnEncoding columnEncoding = this.columnEncodings[fieldIndex];
        if (columnEncoding == null) {
            return;
        }
        BlockBuilder blockBuilder = builder.getBlockBuilder(this.readColumnIndexes[fieldIndex]);
        if (this.isNullSequence(slice, offset, length)) {
            blockBuilder.appendNull();
        } else {
            columnEncoding.decodeValueInto(blockBuilder, slice, offset, length);
        }
    }

    private boolean isNullSequence(Slice slice, int offset, int length) {
        return this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length);
    }
}

