/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import io.trino.filesystem.Location;
import io.trino.metastore.type.TypeInfo;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SourcePage;
import java.util.List;
import java.util.Objects;

public class BucketValidator {
    public static final int VALIDATION_STRIDE = 97;
    private final Location path;
    private final int[] bucketColumnIndices;
    private final List<TypeInfo> bucketColumnTypes;
    private final HiveBucketing.BucketingVersion bucketingVersion;
    private final int bucketCount;
    private final int expectedBucket;

    public BucketValidator(Location path, int[] bucketColumnIndices, List<TypeInfo> bucketColumnTypes, HiveBucketing.BucketingVersion bucketingVersion, int bucketCount, int expectedBucket) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.bucketColumnIndices = Objects.requireNonNull(bucketColumnIndices, "bucketColumnIndices is null");
        this.bucketColumnTypes = Objects.requireNonNull(bucketColumnTypes, "bucketColumnTypes is null");
        this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
        this.bucketCount = bucketCount;
        this.expectedBucket = expectedBucket;
        Preconditions.checkArgument((bucketColumnIndices.length == bucketColumnTypes.size() ? 1 : 0) != 0, (Object)"indices and types counts mismatch");
    }

    public void validate(SourcePage page) {
        Page bucketColumnsPage = page.getColumns(this.bucketColumnIndices);
        for (int position = 0; position < page.getPositionCount(); position += 97) {
            int bucket = HiveBucketing.getHiveBucket(this.bucketingVersion, this.bucketCount, this.bucketColumnTypes, bucketColumnsPage, position);
            if (bucket == this.expectedBucket) continue;
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table is corrupt. File '%s' is for bucket %s, but contains a row for bucket %s.", this.path, this.expectedBucket, bucket));
        }
    }
}

