/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.hive.formats.avro.AvroCompressionKind;
import io.trino.hive.formats.compression.CompressionKind;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.format.CompressionCodec;

public enum HiveCompressionCodec {
    NONE(null, io.trino.orc.metadata.CompressionKind.NONE, CompressionCodec.UNCOMPRESSED, AvroCompressionKind.NULL),
    SNAPPY(CompressionKind.SNAPPY, io.trino.orc.metadata.CompressionKind.SNAPPY, CompressionCodec.SNAPPY, AvroCompressionKind.SNAPPY),
    LZ4(CompressionKind.LZ4, io.trino.orc.metadata.CompressionKind.LZ4, null, null),
    ZSTD(CompressionKind.ZSTD, io.trino.orc.metadata.CompressionKind.ZSTD, CompressionCodec.ZSTD, AvroCompressionKind.ZSTANDARD),
    GZIP(CompressionKind.GZIP, io.trino.orc.metadata.CompressionKind.ZLIB, CompressionCodec.GZIP, AvroCompressionKind.DEFLATE);

    private final Optional<CompressionKind> hiveCompressionKind;
    private final io.trino.orc.metadata.CompressionKind orcCompressionKind;
    private final Optional<CompressionCodec> parquetCompressionCodec;
    private final Optional<AvroCompressionKind> avroCompressionKind;

    private HiveCompressionCodec(@Nullable CompressionKind hiveCompressionKind, @Nullable io.trino.orc.metadata.CompressionKind orcCompressionKind, CompressionCodec parquetCompressionCodec, AvroCompressionKind avroCompressionKind) {
        this.hiveCompressionKind = Optional.ofNullable(hiveCompressionKind);
        this.orcCompressionKind = Objects.requireNonNull(orcCompressionKind, "orcCompressionKind is null");
        this.parquetCompressionCodec = Optional.ofNullable(parquetCompressionCodec);
        this.avroCompressionKind = Optional.ofNullable(avroCompressionKind);
    }

    public Optional<CompressionKind> getHiveCompressionKind() {
        return this.hiveCompressionKind;
    }

    public io.trino.orc.metadata.CompressionKind getOrcCompressionKind() {
        return this.orcCompressionKind;
    }

    public Optional<CompressionCodec> getParquetCompressionCodec() {
        return this.parquetCompressionCodec;
    }

    public Optional<AvroCompressionKind> getAvroCompressionKind() {
        return this.avroCompressionKind;
    }
}

