/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import java.util.Optional;

public class HiveNotReadableException
extends TrinoException {
    public HiveNotReadableException(SchemaTableName tableName, Optional<String> partition, String message) {
        super((ErrorCodeSupplier)(partition.isPresent() ? HiveErrorCode.HIVE_PARTITION_NOT_READABLE : HiveErrorCode.HIVE_TABLE_READ_ONLY), HiveNotReadableException.composeMessage(tableName, partition, message));
    }

    private static String composeMessage(SchemaTableName tableName, Optional<String> partition, String message) {
        return partition.isPresent() ? String.format("Table '%s' partition '%s' is not readable: %s", tableName, partition.get(), message) : String.format("Table '%s' is not readable: %s", tableName, message);
    }
}

