/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.SortingColumn;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HiveInsertTableHandle;
import io.trino.plugin.hive.HiveMergeTableHandle;
import io.trino.plugin.hive.HiveOutputTableHandle;
import io.trino.plugin.hive.HivePageSink;
import io.trino.plugin.hive.HiveTableExecuteHandle;
import io.trino.plugin.hive.HiveWritableTableHandle;
import io.trino.plugin.hive.HiveWriterFactory;
import io.trino.plugin.hive.HiveWriterStats;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.SortingFileWriterConfig;
import io.trino.plugin.hive.metastore.HivePageSinkMetadataProvider;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.TypeManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

public class HivePageSinkProvider
implements ConnectorPageSinkProvider {
    private final Set<HiveFileWriterFactory> fileWriterFactories;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final PageSorter pageSorter;
    private final HiveMetastoreFactory metastoreFactory;
    private final PageIndexerFactory pageIndexerFactory;
    private final TypeManager typeManager;
    private final int maxOpenPartitions;
    private final int maxOpenSortFiles;
    private final DataSize writerSortBufferSize;
    private final LocationService locationService;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final HiveWriterStats hiveWriterStats;
    private final long perTransactionMetastoreCacheMaximumSize;
    private final boolean temporaryStagingDirectoryEnabled;
    private final String temporaryStagingDirectoryPath;

    @Inject
    public HivePageSinkProvider(Set<HiveFileWriterFactory> fileWriterFactories, TrinoFileSystemFactory fileSystemFactory, PageSorter pageSorter, HiveMetastoreFactory metastoreFactory, PageIndexerFactory pageIndexerFactory, TypeManager typeManager, HiveConfig config, SortingFileWriterConfig sortingFileWriterConfig, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, HiveWriterStats hiveWriterStats) {
        this.fileWriterFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fileWriterFactories, "fileWriterFactories is null"));
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.metastoreFactory = Objects.requireNonNull(metastoreFactory, "metastoreFactory is null");
        this.pageIndexerFactory = Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.maxOpenPartitions = config.getMaxPartitionsPerWriter();
        this.maxOpenSortFiles = sortingFileWriterConfig.getMaxOpenSortFiles();
        this.writerSortBufferSize = Objects.requireNonNull(sortingFileWriterConfig.getWriterSortBufferSize(), "writerSortBufferSize is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.hiveWriterStats = Objects.requireNonNull(hiveWriterStats, "hiveWriterStats is null");
        this.perTransactionMetastoreCacheMaximumSize = config.getPerTransactionMetastoreCacheMaximumSize();
        this.temporaryStagingDirectoryEnabled = config.isTemporaryStagingDirectoryEnabled();
        this.temporaryStagingDirectoryPath = config.getTemporaryStagingDirectoryPath();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorOutputTableHandle tableHandle, ConnectorPageSinkId pageSinkId) {
        HiveOutputTableHandle handle = (HiveOutputTableHandle)tableHandle;
        return this.createPageSink(handle, true, session, handle.getAdditionalTableParameters());
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorInsertTableHandle tableHandle, ConnectorPageSinkId pageSinkId) {
        HiveInsertTableHandle handle = (HiveInsertTableHandle)tableHandle;
        return this.createPageSink(handle, false, session, (Map<String, String>)ImmutableMap.of());
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorPageSinkId pageSinkId) {
        HiveTableExecuteHandle handle = (HiveTableExecuteHandle)tableExecuteHandle;
        return this.createPageSink(handle, false, session, (Map<String, String>)ImmutableMap.of());
    }

    public ConnectorMergeSink createMergeSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorMergeTableHandle mergeHandle, ConnectorPageSinkId pageSinkId) {
        HiveMergeTableHandle hiveMergeHandle = (HiveMergeTableHandle)mergeHandle;
        HiveInsertTableHandle insertHandle = hiveMergeHandle.getInsertHandle();
        Preconditions.checkArgument((boolean)insertHandle.getTransaction().isMerge(), (Object)"handle isn't an ACID MERGE");
        return this.createPageSink(insertHandle, false, session, (Map<String, String>)ImmutableMap.of());
    }

    private HivePageSink createPageSink(HiveWritableTableHandle handle, boolean isCreateTable, ConnectorSession session, Map<String, String> additionalTableParameters) {
        OptionalInt bucketCount = OptionalInt.empty();
        Object sortedBy = ImmutableList.of();
        if (handle.getBucketInfo().isPresent()) {
            bucketCount = OptionalInt.of(handle.getBucketInfo().get().bucketCount());
            sortedBy = handle.getBucketInfo().get().sortedBy();
        }
        CachingHiveMetastore cachingHiveMetastore = CachingHiveMetastore.createPerTransactionCache((HiveMetastore)this.metastoreFactory.createMetastore(Optional.of(session.getIdentity())), (long)this.perTransactionMetastoreCacheMaximumSize);
        HiveWriterFactory writerFactory = new HiveWriterFactory(this.fileWriterFactories, this.fileSystemFactory, handle.getSchemaName(), handle.getTableName(), isCreateTable, handle.getTransaction(), handle.getInputColumns(), handle.getTableStorageFormat(), handle.getPartitionStorageFormat(), additionalTableParameters, bucketCount, (List<SortingColumn>)sortedBy, handle.getLocationHandle(), this.locationService, session.getQueryId(), new HivePageSinkMetadataProvider(handle.getPageSinkMetadata(), (HiveMetastore)cachingHiveMetastore), this.typeManager, this.pageSorter, this.writerSortBufferSize, this.maxOpenSortFiles, session, this.hiveWriterStats, this.temporaryStagingDirectoryEnabled, this.temporaryStagingDirectoryPath);
        return new HivePageSink(writerFactory, handle.getInputColumns(), handle.getTransaction(), handle.getBucketInfo(), this.pageIndexerFactory, this.maxOpenPartitions, this.partitionUpdateCodec, session);
    }
}

