/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.orc.OrcWriteValidation;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.hive.HiveCompressionOption;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public final class HiveSessionProperties
implements SessionPropertiesProvider {
    private static final String BUCKET_EXECUTION_ENABLED = "bucket_execution_enabled";
    private static final String VALIDATE_BUCKETING = "validate_bucketing";
    private static final String TARGET_MAX_FILE_SIZE = "target_max_file_size";
    private static final String IDLE_WRITER_MIN_FILE_SIZE = "idle_writer_min_file_size";
    private static final String PARALLEL_PARTITIONED_BUCKETED_WRITES = "parallel_partitioned_bucketed_writes";
    private static final String FORCE_LOCAL_SCHEDULING = "force_local_scheduling";
    private static final String INSERT_EXISTING_PARTITIONS_BEHAVIOR = "insert_existing_partitions_behavior";
    private static final String ORC_BLOOM_FILTERS_ENABLED = "orc_bloom_filters_enabled";
    private static final String ORC_MAX_MERGE_DISTANCE = "orc_max_merge_distance";
    private static final String ORC_MAX_BUFFER_SIZE = "orc_max_buffer_size";
    private static final String ORC_STREAM_BUFFER_SIZE = "orc_stream_buffer_size";
    private static final String ORC_TINY_STRIPE_THRESHOLD = "orc_tiny_stripe_threshold";
    private static final String ORC_MAX_READ_BLOCK_SIZE = "orc_max_read_block_size";
    private static final String ORC_LAZY_READ_SMALL_RANGES = "orc_lazy_read_small_ranges";
    private static final String ORC_NESTED_LAZY_ENABLED = "orc_nested_lazy_enabled";
    private static final String ORC_STRING_STATISTICS_LIMIT = "orc_string_statistics_limit";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE = "orc_optimized_writer_validate";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE = "orc_optimized_writer_validate_percentage";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE_MODE = "orc_optimized_writer_validate_mode";
    private static final String ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE = "orc_optimized_writer_min_stripe_size";
    private static final String ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE = "orc_optimized_writer_max_stripe_size";
    private static final String ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS = "orc_optimized_writer_max_stripe_rows";
    private static final String ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY = "orc_optimized_writer_max_dictionary_memory";
    private static final String ORC_USE_COLUMN_NAME = "orc_use_column_names";
    private static final String HIVE_STORAGE_FORMAT = "hive_storage_format";
    private static final String COMPRESSION_CODEC = "compression_codec";
    private static final String RESPECT_TABLE_FORMAT = "respect_table_format";
    private static final String CREATE_EMPTY_BUCKET_FILES = "create_empty_bucket_files";
    private static final String PARQUET_USE_COLUMN_NAME = "parquet_use_column_names";
    private static final String PARQUET_IGNORE_STATISTICS = "parquet_ignore_statistics";
    private static final String PARQUET_USE_COLUMN_INDEX = "parquet_use_column_index";
    private static final String PARQUET_USE_BLOOM_FILTER = "parquet_use_bloom_filter";
    private static final String PARQUET_MAX_READ_BLOCK_SIZE = "parquet_max_read_block_size";
    private static final String PARQUET_MAX_READ_BLOCK_ROW_COUNT = "parquet_max_read_block_row_count";
    private static final String PARQUET_SMALL_FILE_THRESHOLD = "parquet_small_file_threshold";
    private static final String PARQUET_VECTORIZED_DECODING_ENABLED = "parquet_vectorized_decoding_enabled";
    private static final String PARQUET_WRITER_BLOCK_SIZE = "parquet_writer_block_size";
    private static final String PARQUET_WRITER_PAGE_SIZE = "parquet_writer_page_size";
    private static final String PARQUET_WRITER_PAGE_VALUE_COUNT = "parquet_writer_page_value_count";
    private static final String PARQUET_WRITER_BATCH_SIZE = "parquet_writer_batch_size";
    private static final String PARQUET_OPTIMIZED_WRITER_VALIDATION_PERCENTAGE = "parquet_optimized_writer_validation_percentage";
    private static final String MAX_SPLIT_SIZE = "max_split_size";
    private static final String MAX_INITIAL_SPLIT_SIZE = "max_initial_split_size";
    private static final String RCFILE_OPTIMIZED_WRITER_VALIDATE = "rcfile_optimized_writer_validate";
    private static final String SORTED_WRITING_ENABLED = "sorted_writing_enabled";
    private static final String PROPAGATE_TABLE_SCAN_SORTING_PROPERTIES = "propagate_table_scan_sorting_properties";
    private static final String STATISTICS_ENABLED = "statistics_enabled";
    private static final String PARTITION_STATISTICS_SAMPLE_SIZE = "partition_statistics_sample_size";
    private static final String IGNORE_CORRUPTED_STATISTICS = "ignore_corrupted_statistics";
    private static final String COLLECT_COLUMN_STATISTICS_ON_WRITE = "collect_column_statistics_on_write";
    private static final String OPTIMIZE_MISMATCHED_BUCKET_COUNT = "optimize_mismatched_bucket_count";
    private static final String DELEGATE_TRANSACTIONAL_MANAGED_TABLE_LOCATION_TO_METASTORE = "delegate_transactional_managed_table_location_to_metastore";
    private static final String IGNORE_ABSENT_PARTITIONS = "ignore_absent_partitions";
    private static final String QUERY_PARTITION_FILTER_REQUIRED = "query_partition_filter_required";
    private static final String QUERY_PARTITION_FILTER_REQUIRED_SCHEMAS = "query_partition_filter_required_schemas";
    private static final String PROJECTION_PUSHDOWN_ENABLED = "projection_pushdown_enabled";
    private static final String TIMESTAMP_PRECISION = "timestamp_precision";
    private static final String DYNAMIC_FILTERING_WAIT_TIMEOUT = "dynamic_filtering_wait_timeout";
    private static final String HIVE_VIEWS_LEGACY_TRANSLATION = "hive_views_legacy_translation";
    private static final String ICEBERG_CATALOG_NAME = "iceberg_catalog_name";
    public static final String DELTA_LAKE_CATALOG_NAME = "delta_lake_catalog_name";
    public static final String HUDI_CATALOG_NAME = "hudi_catalog_name";
    public static final String SIZE_BASED_SPLIT_WEIGHTS_ENABLED = "size_based_split_weights_enabled";
    public static final String MINIMUM_ASSIGNED_SPLIT_WEIGHT = "minimum_assigned_split_weight";
    public static final String NON_TRANSACTIONAL_OPTIMIZE_ENABLED = "non_transactional_optimize_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public HiveSessionProperties(HiveConfig hiveConfig, OrcReaderConfig orcReaderConfig, OrcWriterConfig orcWriterConfig, ParquetReaderConfig parquetReaderConfig, ParquetWriterConfig parquetWriterConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)BUCKET_EXECUTION_ENABLED, (String)"Enable bucket-aware execution: use physical bucketing information to optimize queries", (Boolean)hiveConfig.isBucketExecutionEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)VALIDATE_BUCKETING, (String)"Verify that data is bucketed correctly when reading", (Boolean)hiveConfig.isValidateBucketing(), (boolean)false), (Object)PropertyMetadataUtil.dataSizeProperty((String)TARGET_MAX_FILE_SIZE, (String)"Target maximum size of written files; the actual size may be larger", (DataSize)hiveConfig.getTargetMaxFileSize(), (boolean)false), (Object)PropertyMetadataUtil.dataSizeProperty((String)IDLE_WRITER_MIN_FILE_SIZE, (String)"Minimum data written by a single partition writer before it can be consider as 'idle' and could be closed by the engine", (DataSize)hiveConfig.getIdleWriterMinFileSize(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARALLEL_PARTITIONED_BUCKETED_WRITES, (String)"Improve parallelism of partitioned and bucketed table writes", (Boolean)hiveConfig.isParallelPartitionedBucketedWrites(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)FORCE_LOCAL_SCHEDULING, (String)"Only schedule splits on workers colocated with data node", (Boolean)hiveConfig.isForceLocalScheduling(), (boolean)false), (Object)new PropertyMetadata(INSERT_EXISTING_PARTITIONS_BEHAVIOR, "Behavior on insert existing partitions; this session property doesn't control behavior on insert existing unpartitioned table", (Type)VarcharType.VARCHAR, InsertExistingPartitionsBehavior.class, (Object)hiveConfig.getInsertExistingPartitionsBehavior(), false, value -> InsertExistingPartitionsBehavior.valueOf((String)value, hiveConfig.isImmutablePartitions()), Enum::toString), (Object)PropertyMetadata.booleanProperty((String)ORC_BLOOM_FILTERS_ENABLED, (String)"ORC: Enable bloom filters for predicate pushdown", (Boolean)orcReaderConfig.isBloomFiltersEnabled(), (boolean)false), (Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_MAX_MERGE_DISTANCE, (String)"ORC: Maximum size of gap between two reads to merge into a single read", (DataSize)orcReaderConfig.getMaxMergeDistance(), (boolean)false), (Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_MAX_BUFFER_SIZE, (String)"ORC: Maximum size of a single read", (DataSize)orcReaderConfig.getMaxBufferSize(), (boolean)false), (Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_STREAM_BUFFER_SIZE, (String)"ORC: Size of buffer for streaming reads", (DataSize)orcReaderConfig.getStreamBufferSize(), (boolean)false), (Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_TINY_STRIPE_THRESHOLD, (String)"ORC: Threshold below which an ORC stripe or file will read in its entirety", (DataSize)orcReaderConfig.getTinyStripeThreshold(), (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadataUtil.dataSizeProperty((String)ORC_MAX_READ_BLOCK_SIZE, (String)"ORC: Soft max size of Trino blocks produced by ORC reader", (DataSize)orcReaderConfig.getMaxBlockSize(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_LAZY_READ_SMALL_RANGES, (String)"Experimental: ORC: Read small file segments lazily", (Boolean)orcReaderConfig.isLazyReadSmallRanges(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_NESTED_LAZY_ENABLED, (String)"Experimental: ORC: Lazily read nested data", (Boolean)orcReaderConfig.isNestedLazy(), (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)ORC_STRING_STATISTICS_LIMIT, (String)"ORC: Maximum size of string statistics; drop if exceeding", (DataSize)orcWriterConfig.getStringStatisticsLimit(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_OPTIMIZED_WRITER_VALIDATE, (String)"ORC: Force all validation for files", (Boolean)(orcWriterConfig.getValidationPercentage() > 0.0 ? 1 : 0), (boolean)false), new PropertyMetadata(ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, "ORC: sample percentage for validation for files", (Type)DoubleType.DOUBLE, Double.class, (Object)orcWriterConfig.getValidationPercentage(), false, value -> {
            double doubleValue = (Double)value;
            if (doubleValue < 0.0 || doubleValue > 100.0) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between 0.0 and 100.0 inclusive: %s", ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, doubleValue));
            }
            return doubleValue;
        }, value -> value), PropertyMetadata.enumProperty((String)ORC_OPTIMIZED_WRITER_VALIDATE_MODE, (String)"ORC: Level of detail in ORC validation", OrcWriteValidation.OrcWriteValidationMode.class, (Enum)orcWriterConfig.getValidationMode(), (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE, (String)"ORC: Min stripe size", (DataSize)orcWriterConfig.getStripeMinSize(), (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE, (String)"ORC: Max stripe size", (DataSize)orcWriterConfig.getStripeMaxSize(), (boolean)false), PropertyMetadata.integerProperty((String)ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS, (String)"ORC: Max stripe row count", (Integer)orcWriterConfig.getStripeMaxRowCount(), (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY, (String)"ORC: Max dictionary memory", (DataSize)orcWriterConfig.getDictionaryMaxMemory(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_USE_COLUMN_NAME, (String)"ORC: Access ORC columns using names from the file", (Boolean)orcReaderConfig.isUseColumnNames(), (boolean)false), PropertyMetadata.enumProperty((String)HIVE_STORAGE_FORMAT, (String)"Default storage format for new tables or partitions", HiveStorageFormat.class, (Enum)hiveConfig.getHiveStorageFormat(), (boolean)false), PropertyMetadata.enumProperty((String)COMPRESSION_CODEC, (String)"Compression codec to use when writing files", HiveCompressionOption.class, (Enum)hiveConfig.getHiveCompressionCodec(), (boolean)false), PropertyMetadata.booleanProperty((String)RESPECT_TABLE_FORMAT, (String)"Write new partitions using table format rather than default storage format", (Boolean)hiveConfig.isRespectTableFormat(), (boolean)false), PropertyMetadata.booleanProperty((String)CREATE_EMPTY_BUCKET_FILES, (String)"Create empty files for buckets that have no data", (Boolean)hiveConfig.isCreateEmptyBucketFiles(), (boolean)false), PropertyMetadata.booleanProperty((String)PARQUET_USE_COLUMN_NAME, (String)"Parquet: Access Parquet columns using names from the file", (Boolean)hiveConfig.isUseParquetColumnNames(), (boolean)false), PropertyMetadata.booleanProperty((String)PARQUET_IGNORE_STATISTICS, (String)"Ignore statistics from Parquet to allow querying files with corrupted or incorrect statistics", (Boolean)parquetReaderConfig.isIgnoreStatistics(), (boolean)false), PropertyMetadata.booleanProperty((String)PARQUET_USE_COLUMN_INDEX, (String)"Use Parquet column index", (Boolean)parquetReaderConfig.isUseColumnIndex(), (boolean)false), PropertyMetadata.booleanProperty((String)PARQUET_USE_BLOOM_FILTER, (String)"Use Parquet Bloom filters", (Boolean)parquetReaderConfig.isUseBloomFilter(), (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)PARQUET_MAX_READ_BLOCK_SIZE, (String)"Parquet: Maximum size of a block to read", (DataSize)parquetReaderConfig.getMaxReadBlockSize(), (boolean)false), PropertyMetadata.integerProperty((String)PARQUET_MAX_READ_BLOCK_ROW_COUNT, (String)"Parquet: Maximum number of rows read in a batch", (Integer)parquetReaderConfig.getMaxReadBlockRowCount(), value -> {
            if (value < 128 || value > 65536) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between 128 and 65536: %s", PARQUET_MAX_READ_BLOCK_ROW_COUNT, value));
            }
        }, (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)PARQUET_SMALL_FILE_THRESHOLD, (String)"Parquet: Size below which a parquet file will be read entirely", (DataSize)parquetReaderConfig.getSmallFileThreshold(), value -> PropertyMetadataUtil.validateMaxDataSize((String)PARQUET_SMALL_FILE_THRESHOLD, (DataSize)value, (DataSize)DataSize.valueOf((String)"15MB")), (boolean)false), PropertyMetadata.booleanProperty((String)PARQUET_VECTORIZED_DECODING_ENABLED, (String)"Enable using Java Vector API for faster decoding of parquet files", (Boolean)parquetReaderConfig.isVectorizedDecodingEnabled(), (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)PARQUET_WRITER_BLOCK_SIZE, (String)"Parquet: Writer block size", (DataSize)parquetWriterConfig.getBlockSize(), value -> PropertyMetadataUtil.validateMaxDataSize((String)PARQUET_WRITER_BLOCK_SIZE, (DataSize)value, (DataSize)DataSize.valueOf((String)"2GB")), (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)PARQUET_WRITER_PAGE_SIZE, (String)"Parquet: Writer page size", (DataSize)parquetWriterConfig.getPageSize(), value -> {
            PropertyMetadataUtil.validateMinDataSize((String)PARQUET_WRITER_PAGE_SIZE, (DataSize)value, (DataSize)DataSize.valueOf((String)"8kB"));
            PropertyMetadataUtil.validateMaxDataSize((String)PARQUET_WRITER_PAGE_SIZE, (DataSize)value, (DataSize)DataSize.valueOf((String)"8MB"));
        }, (boolean)false), PropertyMetadata.integerProperty((String)PARQUET_WRITER_PAGE_VALUE_COUNT, (String)"Parquet: Writer page row count", (Integer)parquetWriterConfig.getPageValueCount(), value -> {
            if (value < 1000 || value > 200000) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between %s and %s: %s", PARQUET_WRITER_PAGE_VALUE_COUNT, 1000, 200000, value));
            }
        }, (boolean)false), PropertyMetadata.integerProperty((String)PARQUET_WRITER_BATCH_SIZE, (String)"Parquet: Maximum number of rows passed to the writer in each batch", (Integer)parquetWriterConfig.getBatchSize(), (boolean)false), new PropertyMetadata(PARQUET_OPTIMIZED_WRITER_VALIDATION_PERCENTAGE, "Parquet: sample percentage for validation of written files", (Type)DoubleType.DOUBLE, Double.class, (Object)parquetWriterConfig.getValidationPercentage(), false, value -> {
            double doubleValue = (Double)value;
            if (doubleValue < 0.0 || doubleValue > 100.0) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between 0.0 and 100.0 inclusive: %s", PARQUET_OPTIMIZED_WRITER_VALIDATION_PERCENTAGE, doubleValue));
            }
            return doubleValue;
        }, value -> value), PropertyMetadataUtil.dataSizeProperty((String)MAX_SPLIT_SIZE, (String)"Max split size", (DataSize)hiveConfig.getMaxSplitSize(), (boolean)true), PropertyMetadataUtil.dataSizeProperty((String)MAX_INITIAL_SPLIT_SIZE, (String)"Max initial split size", (DataSize)hiveConfig.getMaxInitialSplitSize(), (boolean)true), PropertyMetadata.booleanProperty((String)RCFILE_OPTIMIZED_WRITER_VALIDATE, (String)"RCFile: Validate writer files", (Boolean)hiveConfig.isRcfileWriterValidate(), (boolean)false), PropertyMetadata.booleanProperty((String)SORTED_WRITING_ENABLED, (String)"Enable writing to bucketed sorted tables", (Boolean)hiveConfig.isSortedWritingEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)PROPAGATE_TABLE_SCAN_SORTING_PROPERTIES, (String)"Use sorted table layout to generate more efficient execution plans. May lead to incorrect results if files are not sorted as per table definition.", (Boolean)hiveConfig.isPropagateTableScanSortingProperties(), (boolean)false), PropertyMetadata.booleanProperty((String)STATISTICS_ENABLED, (String)"Expose table statistics", (Boolean)hiveConfig.isTableStatisticsEnabled(), (boolean)false), PropertyMetadata.integerProperty((String)PARTITION_STATISTICS_SAMPLE_SIZE, (String)"Maximum sample size of the partitions column statistics", (Integer)hiveConfig.getPartitionStatisticsSampleSize(), (boolean)false), PropertyMetadata.booleanProperty((String)IGNORE_CORRUPTED_STATISTICS, (String)"Experimental: Ignore corrupted statistics rather than failing", (Boolean)hiveConfig.isIgnoreCorruptedStatistics(), (boolean)false), PropertyMetadata.booleanProperty((String)COLLECT_COLUMN_STATISTICS_ON_WRITE, (String)"Enables automatic column level statistics collection on write", (Boolean)hiveConfig.isCollectColumnStatisticsOnWrite(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_MISMATCHED_BUCKET_COUNT, (String)"Experimental: Enable optimization to avoid shuffle when bucket count is compatible but not the same", (Boolean)hiveConfig.isOptimizeMismatchedBucketCount(), (boolean)false), PropertyMetadata.booleanProperty((String)DELEGATE_TRANSACTIONAL_MANAGED_TABLE_LOCATION_TO_METASTORE, (String)"When transactional managed table is created via Trino the location will not be set in request sent to HMS and location will be determined by metastore; if this property is set to true CREATE TABLE AS queries are not supported.", (Boolean)hiveConfig.isDelegateTransactionalManagedTableLocationToMetastore(), (boolean)true), PropertyMetadata.booleanProperty((String)IGNORE_ABSENT_PARTITIONS, (String)"Ignore partitions when the file system location does not exist rather than failing the query.", (Boolean)hiveConfig.isIgnoreAbsentPartitions(), (boolean)false), PropertyMetadata.booleanProperty((String)QUERY_PARTITION_FILTER_REQUIRED, (String)"Require filter on partition column", (Boolean)hiveConfig.isQueryPartitionFilterRequired(), (boolean)false), new PropertyMetadata(QUERY_PARTITION_FILTER_REQUIRED_SCHEMAS, "List of schemas for which filter on partition column is enforced.", (Type)new ArrayType((Type)VarcharType.VARCHAR), Set.class, hiveConfig.getQueryPartitionFilterRequiredSchemas(), false, object -> (Set)((Collection)object).stream().map(String.class::cast).peek(property -> {
            if (Strings.isNullOrEmpty((String)property)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Invalid null or empty value in %s property", QUERY_PARTITION_FILTER_REQUIRED_SCHEMAS));
            }
        }).map(schema -> schema.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet()), value -> value), PropertyMetadata.booleanProperty((String)PROJECTION_PUSHDOWN_ENABLED, (String)"Read only required fields from a row type", (Boolean)hiveConfig.isProjectionPushdownEnabled(), (boolean)false), PropertyMetadata.enumProperty((String)TIMESTAMP_PRECISION, (String)"Precision for timestamp columns in Hive tables", HiveTimestampPrecision.class, (Enum)hiveConfig.getTimestampPrecision(), (boolean)false), PropertyMetadataUtil.durationProperty((String)DYNAMIC_FILTERING_WAIT_TIMEOUT, (String)"Duration to wait for completion of dynamic filters during split generation", (Duration)hiveConfig.getDynamicFilteringWaitTimeout(), (boolean)false), PropertyMetadata.booleanProperty((String)HIVE_VIEWS_LEGACY_TRANSLATION, (String)"Use legacy Hive view translation mechanism", (Boolean)hiveConfig.isLegacyHiveViewTranslation(), (boolean)false), PropertyMetadata.stringProperty((String)ICEBERG_CATALOG_NAME, (String)"Catalog to redirect to when an Iceberg table is referenced", (String)hiveConfig.getIcebergCatalogName().orElse(null), (boolean)true), PropertyMetadata.booleanProperty((String)SIZE_BASED_SPLIT_WEIGHTS_ENABLED, (String)"Enable estimating split weights based on size in bytes", (Boolean)hiveConfig.isSizeBasedSplitWeightsEnabled(), (boolean)false), PropertyMetadata.doubleProperty((String)MINIMUM_ASSIGNED_SPLIT_WEIGHT, (String)"Minimum assigned split weight when size based split weighting is enabled", (Double)hiveConfig.getMinimumAssignedSplitWeight(), value -> {
            if (!Double.isFinite(value) || value <= 0.0 || value > 1.0) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be > 0 and <= 1.0: %s", MINIMUM_ASSIGNED_SPLIT_WEIGHT, value));
            }
        }, (boolean)false), PropertyMetadata.booleanProperty((String)NON_TRANSACTIONAL_OPTIMIZE_ENABLED, (String)"Enable OPTIMIZE table procedure", (Boolean)false, (boolean)false), PropertyMetadata.stringProperty((String)DELTA_LAKE_CATALOG_NAME, (String)"Catalog to redirect to when a Delta Lake table is referenced", (String)hiveConfig.getDeltaLakeCatalogName().orElse(null), (boolean)true), PropertyMetadata.stringProperty((String)HUDI_CATALOG_NAME, (String)"Catalog to redirect to when a Hudi table is referenced", (String)hiveConfig.getHudiCatalogName().orElse(null), (boolean)true)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isBucketExecutionEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(BUCKET_EXECUTION_ENABLED, Boolean.class);
    }

    public static boolean isValidateBucketing(ConnectorSession session) {
        return (Boolean)session.getProperty(VALIDATE_BUCKETING, Boolean.class);
    }

    public static DataSize getTargetMaxFileSize(ConnectorSession session) {
        return (DataSize)session.getProperty(TARGET_MAX_FILE_SIZE, DataSize.class);
    }

    public static DataSize getIdleWriterMinFileSize(ConnectorSession session) {
        return (DataSize)session.getProperty(IDLE_WRITER_MIN_FILE_SIZE, DataSize.class);
    }

    public static boolean isParallelPartitionedBucketedWrites(ConnectorSession session) {
        return (Boolean)session.getProperty(PARALLEL_PARTITIONED_BUCKETED_WRITES, Boolean.class);
    }

    public static boolean isForceLocalScheduling(ConnectorSession session) {
        return (Boolean)session.getProperty(FORCE_LOCAL_SCHEDULING, Boolean.class);
    }

    public static InsertExistingPartitionsBehavior getInsertExistingPartitionsBehavior(ConnectorSession session) {
        return (InsertExistingPartitionsBehavior)((Object)session.getProperty(INSERT_EXISTING_PARTITIONS_BEHAVIOR, InsertExistingPartitionsBehavior.class));
    }

    public static boolean isOrcBloomFiltersEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_BLOOM_FILTERS_ENABLED, Boolean.class);
    }

    public static DataSize getOrcMaxMergeDistance(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_MERGE_DISTANCE, DataSize.class);
    }

    public static DataSize getOrcMaxBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcStreamBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STREAM_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcTinyStripeThreshold(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_TINY_STRIPE_THRESHOLD, DataSize.class);
    }

    public static DataSize getOrcMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static boolean getOrcLazyReadSmallRanges(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_LAZY_READ_SMALL_RANGES, Boolean.class);
    }

    public static boolean isOrcNestedLazy(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_NESTED_LAZY_ENABLED, Boolean.class);
    }

    public static DataSize getOrcStringStatisticsLimit(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STRING_STATISTICS_LIMIT, DataSize.class);
    }

    public static boolean isOrcOptimizedWriterValidate(ConnectorSession session) {
        boolean validate = (Boolean)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE, Boolean.class);
        double percentage = (Double)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, Double.class);
        Preconditions.checkArgument((percentage >= 0.0 && percentage <= 100.0 ? 1 : 0) != 0);
        if (!validate) {
            return false;
        }
        return ThreadLocalRandom.current().nextDouble(100.0) < percentage;
    }

    public static OrcWriteValidation.OrcWriteValidationMode getOrcOptimizedWriterValidateMode(ConnectorSession session) {
        return (OrcWriteValidation.OrcWriteValidationMode)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE_MODE, OrcWriteValidation.OrcWriteValidationMode.class);
    }

    public static DataSize getOrcOptimizedWriterMinStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE, DataSize.class);
    }

    public static DataSize getOrcOptimizedWriterMaxStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE, DataSize.class);
    }

    public static int getOrcOptimizedWriterMaxStripeRows(ConnectorSession session) {
        return (Integer)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS, Integer.class);
    }

    public static DataSize getOrcOptimizedWriterMaxDictionaryMemory(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY, DataSize.class);
    }

    public static boolean isUseOrcColumnNames(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_USE_COLUMN_NAME, Boolean.class);
    }

    public static HiveStorageFormat getHiveStorageFormat(ConnectorSession session) {
        return (HiveStorageFormat)((Object)session.getProperty(HIVE_STORAGE_FORMAT, HiveStorageFormat.class));
    }

    public static HiveCompressionOption getCompressionCodec(ConnectorSession session) {
        return (HiveCompressionOption)((Object)session.getProperty(COMPRESSION_CODEC, HiveCompressionOption.class));
    }

    public static boolean isRespectTableFormat(ConnectorSession session) {
        return (Boolean)session.getProperty(RESPECT_TABLE_FORMAT, Boolean.class);
    }

    public static boolean isCreateEmptyBucketFiles(ConnectorSession session) {
        return (Boolean)session.getProperty(CREATE_EMPTY_BUCKET_FILES, Boolean.class);
    }

    public static boolean isUseParquetColumnNames(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_USE_COLUMN_NAME, Boolean.class);
    }

    public static boolean isParquetIgnoreStatistics(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_IGNORE_STATISTICS, Boolean.class);
    }

    public static boolean isParquetUseColumnIndex(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_USE_COLUMN_INDEX, Boolean.class);
    }

    public static boolean useParquetBloomFilter(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_USE_BLOOM_FILTER, Boolean.class);
    }

    public static DataSize getParquetMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static int getParquetMaxReadBlockRowCount(ConnectorSession session) {
        return (Integer)session.getProperty(PARQUET_MAX_READ_BLOCK_ROW_COUNT, Integer.class);
    }

    public static DataSize getParquetSmallFileThreshold(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_SMALL_FILE_THRESHOLD, DataSize.class);
    }

    public static boolean isParquetVectorizedDecodingEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_VECTORIZED_DECODING_ENABLED, Boolean.class);
    }

    public static DataSize getParquetWriterBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_BLOCK_SIZE, DataSize.class);
    }

    public static DataSize getParquetWriterPageSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_PAGE_SIZE, DataSize.class);
    }

    public static int getParquetWriterPageValueCount(ConnectorSession session) {
        return (Integer)session.getProperty(PARQUET_WRITER_PAGE_VALUE_COUNT, Integer.class);
    }

    public static int getParquetBatchSize(ConnectorSession session) {
        return (Integer)session.getProperty(PARQUET_WRITER_BATCH_SIZE, Integer.class);
    }

    public static boolean isParquetOptimizedWriterValidate(ConnectorSession session) {
        double percentage = (Double)session.getProperty(PARQUET_OPTIMIZED_WRITER_VALIDATION_PERCENTAGE, Double.class);
        Preconditions.checkArgument((percentage >= 0.0 && percentage <= 100.0 ? 1 : 0) != 0);
        return ThreadLocalRandom.current().nextDouble(100.0) < percentage;
    }

    public static DataSize getMaxSplitSize(ConnectorSession session) {
        return (DataSize)session.getProperty(MAX_SPLIT_SIZE, DataSize.class);
    }

    public static DataSize getMaxInitialSplitSize(ConnectorSession session) {
        return (DataSize)session.getProperty(MAX_INITIAL_SPLIT_SIZE, DataSize.class);
    }

    public static boolean isRcfileOptimizedWriterValidate(ConnectorSession session) {
        return (Boolean)session.getProperty(RCFILE_OPTIMIZED_WRITER_VALIDATE, Boolean.class);
    }

    public static boolean isSortedWritingEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(SORTED_WRITING_ENABLED, Boolean.class);
    }

    public static boolean isPropagateTableScanSortingProperties(ConnectorSession session) {
        return (Boolean)session.getProperty(PROPAGATE_TABLE_SCAN_SORTING_PROPERTIES, Boolean.class);
    }

    public static boolean isStatisticsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(STATISTICS_ENABLED, Boolean.class);
    }

    public static int getPartitionStatisticsSampleSize(ConnectorSession session) {
        int size = (Integer)session.getProperty(PARTITION_STATISTICS_SAMPLE_SIZE, Integer.class);
        if (size < 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be greater than 0: %s", PARTITION_STATISTICS_SAMPLE_SIZE, size));
        }
        return size;
    }

    public static boolean isIgnoreCorruptedStatistics(ConnectorSession session) {
        return (Boolean)session.getProperty(IGNORE_CORRUPTED_STATISTICS, Boolean.class);
    }

    public static boolean isCollectColumnStatisticsOnWrite(ConnectorSession session) {
        return (Boolean)session.getProperty(COLLECT_COLUMN_STATISTICS_ON_WRITE, Boolean.class);
    }

    public static boolean isOptimizedMismatchedBucketCount(ConnectorSession session) {
        return (Boolean)session.getProperty(OPTIMIZE_MISMATCHED_BUCKET_COUNT, Boolean.class);
    }

    public static boolean isDelegateTransactionalManagedTableLocationToMetastore(ConnectorSession session) {
        return (Boolean)session.getProperty(DELEGATE_TRANSACTIONAL_MANAGED_TABLE_LOCATION_TO_METASTORE, Boolean.class);
    }

    public static boolean isIgnoreAbsentPartitions(ConnectorSession session) {
        return (Boolean)session.getProperty(IGNORE_ABSENT_PARTITIONS, Boolean.class);
    }

    public static boolean isQueryPartitionFilterRequired(ConnectorSession session) {
        return (Boolean)session.getProperty(QUERY_PARTITION_FILTER_REQUIRED, Boolean.class);
    }

    public static Set<String> getQueryPartitionFilterRequiredSchemas(ConnectorSession session) {
        Set schemas = (Set)session.getProperty(QUERY_PARTITION_FILTER_REQUIRED_SCHEMAS, Set.class);
        Objects.requireNonNull(schemas, "queryPartitionFilterRequiredSchemas is null");
        return schemas;
    }

    public static boolean isProjectionPushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PROJECTION_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static HiveTimestampPrecision getTimestampPrecision(ConnectorSession session) {
        return (HiveTimestampPrecision)((Object)session.getProperty(TIMESTAMP_PRECISION, HiveTimestampPrecision.class));
    }

    public static Duration getDynamicFilteringWaitTimeout(ConnectorSession session) {
        return (Duration)session.getProperty(DYNAMIC_FILTERING_WAIT_TIMEOUT, Duration.class);
    }

    public static boolean isHiveViewsLegacyTranslation(ConnectorSession session) {
        return (Boolean)session.getProperty(HIVE_VIEWS_LEGACY_TRANSLATION, Boolean.class);
    }

    public static Optional<String> getIcebergCatalogName(ConnectorSession session) {
        return Optional.ofNullable((String)session.getProperty(ICEBERG_CATALOG_NAME, String.class));
    }

    public static boolean isSizeBasedSplitWeightsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(SIZE_BASED_SPLIT_WEIGHTS_ENABLED, Boolean.class);
    }

    public static double getMinimumAssignedSplitWeight(ConnectorSession session) {
        return (Double)session.getProperty(MINIMUM_ASSIGNED_SPLIT_WEIGHT, Double.class);
    }

    public static boolean isNonTransactionalOptimizeEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(NON_TRANSACTIONAL_OPTIMIZE_ENABLED, Boolean.class);
    }

    public static Optional<String> getDeltaLakeCatalogName(ConnectorSession session) {
        return Optional.ofNullable((String)session.getProperty(DELTA_LAKE_CATALOG_NAME, String.class));
    }

    public static Optional<String> getHudiCatalogName(ConnectorSession session) {
        return Optional.ofNullable((String)session.getProperty(HUDI_CATALOG_NAME, String.class));
    }

    public static enum InsertExistingPartitionsBehavior {
        ERROR,
        APPEND,
        OVERWRITE;


        public static InsertExistingPartitionsBehavior valueOf(String value, boolean immutablePartitions) {
            InsertExistingPartitionsBehavior enumValue = InsertExistingPartitionsBehavior.valueOf(value.toUpperCase(Locale.ENGLISH));
            Preconditions.checkArgument((boolean)InsertExistingPartitionsBehavior.isValid(enumValue, immutablePartitions), (String)"Trino is configured to treat Hive partitions as immutable. %s is not allowed to be set to %s", (Object)HiveSessionProperties.INSERT_EXISTING_PARTITIONS_BEHAVIOR, (Object)((Object)APPEND));
            return enumValue;
        }

        static boolean isValid(InsertExistingPartitionsBehavior value, boolean immutable) {
            return !immutable || value != APPEND;
        }
    }
}

