/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HiveViewProperties {
    public static final String EXTRA_PROPERTIES = "extra_properties";
    private final List<PropertyMetadata<?>> viewProperties;

    @Inject
    public HiveViewProperties(TypeManager typeManager) {
        this.viewProperties = ImmutableList.of((Object)new PropertyMetadata(EXTRA_PROPERTIES, "Extra view properties", (Type)new MapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, typeManager.getTypeOperators()), Map.class, null, true, value -> {
            Map extraProperties = (Map)value;
            if (extraProperties.containsValue(null)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW_PROPERTY, String.format("Extra view property value cannot be null '%s'", extraProperties));
            }
            if (extraProperties.containsKey(null)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW_PROPERTY, String.format("Extra view property key cannot be null '%s'", extraProperties));
            }
            return extraProperties;
        }, value -> value));
    }

    public List<PropertyMetadata<?>> getViewProperties() {
        return this.viewProperties;
    }

    public static Optional<Map<String, String>> getExtraProperties(Map<String, Object> tableProperties) {
        return Optional.ofNullable((Map)tableProperties.get(EXTRA_PROPERTIES));
    }
}

