/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Sets;
import io.airlift.units.DataSize;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.hive.formats.compression.CompressionKind;
import io.trino.metastore.AcidOperation;
import io.trino.metastore.Column;
import io.trino.metastore.HiveType;
import io.trino.metastore.HiveTypeName;
import io.trino.metastore.Partition;
import io.trino.metastore.Partitions;
import io.trino.metastore.SortingColumn;
import io.trino.metastore.StorageFormat;
import io.trino.metastore.Table;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveCompressionCodecs;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveWriter;
import io.trino.plugin.hive.HiveWriterStats;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.MergeFileWriter;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.SortingFileWriter;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.HivePageSinkMetadataProvider;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.orc.OrcFileWriterFactory;
import io.trino.plugin.hive.util.AcidTables;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.plugin.hive.util.HiveTypeUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageSorter;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HiveWriterFactory {
    private static final int MAX_BUCKET_COUNT = 100000;
    private static final int BUCKET_NUMBER_PADDING = Integer.toString(99999).length();
    private static final Pattern BUCKET_FROM_FILENAME_PATTERN = Pattern.compile("(0[0-9]+)_.*");
    private final Set<HiveFileWriterFactory> fileWriterFactories;
    private final TrinoFileSystem fileSystem;
    private final String schemaName;
    private final String tableName;
    private final AcidTransaction transaction;
    private final List<HiveColumnHandle> inputColumns;
    private final List<DataColumn> dataColumns;
    private final List<String> partitionColumnNames;
    private final List<Type> partitionColumnTypes;
    private final HiveStorageFormat tableStorageFormat;
    private final HiveStorageFormat partitionStorageFormat;
    private final Map<String, String> additionalTableParameters;
    private final LocationHandle locationHandle;
    private final LocationService locationService;
    private final String queryId;
    private final boolean isCreateTransactionalTable;
    private final HivePageSinkMetadataProvider pageSinkMetadataProvider;
    private final TypeManager typeManager;
    private final PageSorter pageSorter;
    private final Table table;
    private final DataSize sortBufferSize;
    private final int maxOpenSortFiles;
    private final boolean sortedWritingTempStagingPathEnabled;
    private final String sortedWritingTempStagingPath;
    private final HiveSessionProperties.InsertExistingPartitionsBehavior insertExistingPartitionsBehavior;
    private final ConnectorSession session;
    private final OptionalInt bucketCount;
    private final List<SortingColumn> sortedBy;
    private final HiveWriterStats hiveWriterStats;
    private final Optional<Type> rowType;
    private final Optional<HiveType> hiveRowtype;

    public HiveWriterFactory(Set<HiveFileWriterFactory> fileWriterFactories, TrinoFileSystemFactory fileSystemFactory, String schemaName, String tableName, boolean isCreateTable, AcidTransaction transaction, List<HiveColumnHandle> inputColumns, HiveStorageFormat tableStorageFormat, HiveStorageFormat partitionStorageFormat, Map<String, String> additionalTableParameters, OptionalInt bucketCount, List<SortingColumn> sortedBy, LocationHandle locationHandle, LocationService locationService, String queryId, HivePageSinkMetadataProvider pageSinkMetadataProvider, TypeManager typeManager, PageSorter pageSorter, DataSize sortBufferSize, int maxOpenSortFiles, ConnectorSession session, HiveWriterStats hiveWriterStats, boolean sortedWritingTempStagingPathEnabled, String sortedWritingTempStagingPath) {
        this.fileWriterFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fileWriterFactories, "fileWriterFactories is null"));
        this.fileSystem = fileSystemFactory.create(session);
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.transaction = Objects.requireNonNull(transaction, "transaction is null");
        this.inputColumns = Objects.requireNonNull(inputColumns, "inputColumns is null");
        this.tableStorageFormat = Objects.requireNonNull(tableStorageFormat, "tableStorageFormat is null");
        this.partitionStorageFormat = Objects.requireNonNull(partitionStorageFormat, "partitionStorageFormat is null");
        this.additionalTableParameters = ImmutableMap.copyOf(Objects.requireNonNull(additionalTableParameters, "additionalTableParameters is null"));
        this.locationHandle = Objects.requireNonNull(locationHandle, "locationHandle is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.pageSinkMetadataProvider = Objects.requireNonNull(pageSinkMetadataProvider, "pageSinkMetadataProvider is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.sortBufferSize = Objects.requireNonNull(sortBufferSize, "sortBufferSize is null");
        this.maxOpenSortFiles = maxOpenSortFiles;
        this.sortedWritingTempStagingPathEnabled = sortedWritingTempStagingPathEnabled;
        this.sortedWritingTempStagingPath = Objects.requireNonNull(sortedWritingTempStagingPath, "sortedWritingTempStagingPath is null");
        this.insertExistingPartitionsBehavior = HiveSessionProperties.getInsertExistingPartitionsBehavior(session);
        ImmutableList.Builder partitionColumnNames = ImmutableList.builder();
        ImmutableList.Builder partitionColumnTypes = ImmutableList.builder();
        ImmutableList.Builder dataColumns = ImmutableList.builder();
        for (HiveColumnHandle column2 : inputColumns) {
            HiveType hiveType = column2.getHiveType();
            if (column2.isPartitionKey()) {
                partitionColumnNames.add((Object)column2.getName());
                partitionColumnTypes.add((Object)column2.getType());
                continue;
            }
            dataColumns.add((Object)new DataColumn(column2.getName(), hiveType));
        }
        if (transaction.isMerge()) {
            RowType mergeRowType = RowType.from((List)((List)inputColumns.stream().filter(column -> !column.isPartitionKey()).map(column -> new RowType.Field(Optional.of(column.getName()), column.getType())).collect(ImmutableList.toImmutableList())));
            this.rowType = Optional.of(mergeRowType);
            this.hiveRowtype = Optional.of(HiveTypeTranslator.toHiveType((Type)mergeRowType));
        } else {
            this.rowType = Optional.empty();
            this.hiveRowtype = Optional.empty();
        }
        this.partitionColumnNames = partitionColumnNames.build();
        this.partitionColumnTypes = partitionColumnTypes.build();
        this.dataColumns = dataColumns.build();
        boolean bl = this.isCreateTransactionalTable = isCreateTable && transaction.isTransactional();
        if (isCreateTable) {
            this.table = null;
            LocationService.WriteInfo writeInfo = locationService.getQueryWriteInfo(locationHandle);
            Preconditions.checkArgument((writeInfo.writeMode() != LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY ? 1 : 0) != 0, (Object)"CREATE TABLE write mode cannot be DIRECT_TO_TARGET_EXISTING_DIRECTORY");
        } else {
            this.table = pageSinkMetadataProvider.getTable().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table '%s.%s' was dropped during insert", schemaName, tableName)));
        }
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is null");
        if (bucketCount.isPresent()) {
            Preconditions.checkArgument((bucketCount.getAsInt() < 100000 ? 1 : 0) != 0, (String)"bucketCount must be smaller than %s", (int)100000);
        }
        this.sortedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortedBy, "sortedBy is null"));
        this.session = Objects.requireNonNull(session, "session is null");
        this.hiveWriterStats = Objects.requireNonNull(hiveWriterStats, "hiveWriterStats is null");
    }

    public HiveWriter createWriter(Page partitionColumns, int position, OptionalInt bucketNumber) {
        HiveCompressionCodec compressionCodec;
        StorageFormat outputStorageFormat;
        LocationService.WriteInfo writeInfo;
        PartitionUpdate.UpdateMode updateMode;
        if (this.bucketCount.isPresent()) {
            Preconditions.checkArgument((boolean)bucketNumber.isPresent(), (Object)"Bucket not provided for bucketed table");
            Preconditions.checkArgument((bucketNumber.getAsInt() < this.bucketCount.getAsInt() ? 1 : 0) != 0, (String)"Bucket number %s must be less than bucket count %s", (Object)bucketNumber, (Object)this.bucketCount);
        } else {
            Preconditions.checkArgument((boolean)bucketNumber.isEmpty(), (Object)"Bucket number provided by for table that is not bucketed");
        }
        List<String> partitionValues = HiveWriteUtils.createPartitionValues(this.partitionColumnTypes, partitionColumns, position);
        Optional<Object> partitionName = !this.partitionColumnNames.isEmpty() ? Optional.of(Partitions.makePartName(this.partitionColumnNames, partitionValues)) : Optional.empty();
        Optional<Object> partition = Optional.empty();
        if (!partitionValues.isEmpty() && this.table != null) {
            partition = this.pageSinkMetadataProvider.getPartition(partitionValues);
        }
        HashMap<String, String> schema = new HashMap<String, String>();
        if (partition.isEmpty()) {
            if (this.table == null) {
                updateMode = PartitionUpdate.UpdateMode.NEW;
                schema.put("columns", this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.joining(",")));
                schema.put("columns.types", this.dataColumns.stream().map(DataColumn::getHiveType).map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
                if (partitionName.isEmpty()) {
                    writeInfo = this.locationService.getTableWriteInfo(this.locationHandle, false);
                } else {
                    writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
                    if (!writeInfo.writeMode().isWritePathSameAsTargetPath()) {
                        Location writeInfoTargetPath = writeInfo.targetPath();
                        try {
                            if (this.fileSystem.directoryExists(writeInfoTargetPath).orElse(false).booleanValue()) {
                                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for new partition '%s' of table '%s.%s' already exists: %s", partitionName, this.schemaName, this.tableName, writeInfo.targetPath()));
                            }
                        }
                        catch (IOException e) {
                            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error while accessing: %s", writeInfoTargetPath), (Throwable)e);
                        }
                    }
                }
            } else {
                if (partitionName.isPresent()) {
                    updateMode = PartitionUpdate.UpdateMode.NEW;
                    writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
                } else {
                    writeInfo = switch (this.insertExistingPartitionsBehavior) {
                        case HiveSessionProperties.InsertExistingPartitionsBehavior.APPEND -> {
                            updateMode = PartitionUpdate.UpdateMode.APPEND;
                            yield this.locationService.getTableWriteInfo(this.locationHandle, false);
                        }
                        case HiveSessionProperties.InsertExistingPartitionsBehavior.OVERWRITE -> {
                            updateMode = PartitionUpdate.UpdateMode.OVERWRITE;
                            yield this.locationService.getTableWriteInfo(this.locationHandle, true);
                        }
                        case HiveSessionProperties.InsertExistingPartitionsBehavior.ERROR -> throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_READ_ONLY, "Unpartitioned Hive tables are immutable");
                        default -> throw new IllegalArgumentException("Unsupported insert existing table behavior: " + String.valueOf((Object)this.insertExistingPartitionsBehavior));
                    };
                }
                schema.putAll(MetastoreUtil.getHiveSchema(this.table));
            }
            if (partitionName.isPresent()) {
                outputStorageFormat = this.partitionStorageFormat.toStorageFormat();
                compressionCodec = HiveCompressionCodecs.selectCompressionCodec(this.session, this.partitionStorageFormat);
            } else {
                outputStorageFormat = this.tableStorageFormat.toStorageFormat();
                compressionCodec = HiveCompressionCodecs.selectCompressionCodec(this.session, this.tableStorageFormat);
            }
        } else {
            switch (this.insertExistingPartitionsBehavior) {
                case APPEND: {
                    updateMode = PartitionUpdate.UpdateMode.APPEND;
                    List tableColumns = this.table.getDataColumns();
                    List existingPartitionColumns = ((Partition)partition.get()).getColumns();
                    for (int i = 0; i < Math.min(existingPartitionColumns.size(), tableColumns.size()); ++i) {
                        HiveType partitionType;
                        HiveType tableType = ((Column)tableColumns.get(i)).getType();
                        if (tableType.equals((Object)(partitionType = ((Column)existingPartitionColumns.get(i)).getType()))) continue;
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("You are trying to write into an existing partition in a table. The table schema has changed since the creation of the partition. Inserting rows into such partition is not supported. The column '%s' in table '%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", ((Column)tableColumns.get(i)).getName(), this.tableName, tableType, partitionName, ((Column)existingPartitionColumns.get(i)).getName(), partitionType));
                    }
                    HiveWriteUtils.checkPartitionIsWritable((String)partitionName.get(), (Partition)partition.get());
                    outputStorageFormat = ((Partition)partition.get()).getStorage().getStorageFormat();
                    compressionCodec = HiveCompressionCodecs.selectCompressionCodec(this.session, outputStorageFormat);
                    schema.putAll(MetastoreUtil.getHiveSchema((Partition)partition.get(), this.table));
                    writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
                    break;
                }
                case OVERWRITE: {
                    updateMode = PartitionUpdate.UpdateMode.OVERWRITE;
                    outputStorageFormat = this.partitionStorageFormat.toStorageFormat();
                    compressionCodec = HiveCompressionCodecs.selectCompressionCodec(this.session, this.partitionStorageFormat);
                    schema.putAll(MetastoreUtil.getHiveSchema(this.table));
                    writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, Optional.empty(), (String)partitionName.get());
                    break;
                }
                case ERROR: {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Cannot insert into an existing partition of Hive table: " + (String)partitionName.get());
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported insert existing partitions behavior: %s", new Object[]{this.insertExistingPartitionsBehavior}));
                }
            }
        }
        schema.putAll(this.additionalTableParameters);
        this.validateSchema(partitionName, schema);
        int bucketToUse = bucketNumber.isEmpty() ? 0 : bucketNumber.getAsInt();
        Location path = writeInfo.writePath();
        if (this.transaction.isAcidTransactionRunning() && this.transaction.getOperation() != AcidOperation.CREATE_TABLE) {
            String subdir = this.computeAcidSubdir(this.transaction);
            String nameFormat = this.table != null && AcidTables.isInsertOnlyTable(this.table.getParameters()) ? "%05d_0" : "bucket_%05d";
            path = path.appendPath(subdir).appendPath(nameFormat.formatted(bucketToUse));
        } else {
            path = path.appendPath(this.computeFileName(bucketNumber) + HiveWriterFactory.getFileExtension(compressionCodec, outputStorageFormat));
        }
        boolean useAcidSchema = this.isCreateTransactionalTable || this.table != null && AcidTables.isFullAcidTable(this.table.getParameters());
        FileWriter hiveFileWriter = null;
        if (this.transaction.isMerge()) {
            OrcFileWriterFactory orcFileWriterFactory = (OrcFileWriterFactory)this.fileWriterFactories.stream().filter(factory -> factory instanceof OrcFileWriterFactory).collect(MoreCollectors.onlyElement());
            Preconditions.checkArgument((boolean)this.hiveRowtype.isPresent(), (Object)"rowTypes not present");
            hiveFileWriter = new MergeFileWriter(this.transaction, 0, bucketNumber, this::makeRowIdSortingWriter, path.toString(), orcFileWriterFactory, compressionCodec, this.inputColumns, this.session, this.typeManager, this.hiveRowtype.get());
        } else {
            for (HiveFileWriterFactory fileWriterFactory : this.fileWriterFactories) {
                Optional<FileWriter> fileWriter = fileWriterFactory.createFileWriter(path, this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.toList()), outputStorageFormat, compressionCodec, schema, this.session, bucketNumber, this.transaction, useAcidSchema, WriterKind.INSERT);
                if (!fileWriter.isPresent()) continue;
                hiveFileWriter = fileWriter.get();
                break;
            }
        }
        if (hiveFileWriter == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Writing not supported for " + String.valueOf(outputStorageFormat));
        }
        if (!this.sortedBy.isEmpty()) {
            Location tempFilePath;
            if (this.sortedWritingTempStagingPathEnabled) {
                String stagingPath = this.sortedWritingTempStagingPath.replace("${USER}", this.session.getIdentity().getUser());
                Location tempPrefix = HiveWriterFactory.setSchemeToFileIfAbsent(Location.of((String)stagingPath));
                tempFilePath = tempPrefix.appendPath(".tmp-sort.%s.%s".formatted(path.parentDirectory().fileName(), path.fileName()));
            } else {
                tempFilePath = path.parentDirectory().appendPath(".tmp-sort." + path.fileName());
            }
            List types = (List)this.dataColumns.stream().map(column -> HiveTypeUtil.getType(column.getHiveType(), this.typeManager, HiveSessionProperties.getTimestampPrecision(this.session))).collect(ImmutableList.toImmutableList());
            HashMap<String, Integer> columnIndexes = new HashMap<String, Integer>();
            for (int i = 0; i < this.dataColumns.size(); ++i) {
                columnIndexes.put(this.dataColumns.get(i).getName(), i);
            }
            ArrayList<Integer> sortFields = new ArrayList<Integer>();
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            for (SortingColumn column2 : this.sortedBy) {
                Integer index = (Integer)columnIndexes.get(column2.columnName());
                if (index == null) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Sorting column '%s' does exist in table '%s.%s'", column2.columnName(), this.schemaName, this.tableName));
                }
                sortFields.add(index);
                sortOrders.add(column2.order().getSortOrder());
            }
            hiveFileWriter = new SortingFileWriter(this.fileSystem, tempFilePath, hiveFileWriter, this.sortBufferSize, this.maxOpenSortFiles, types, sortFields, sortOrders, this.pageSorter, this.typeManager.getTypeOperators(), OrcFileWriterFactory::createOrcDataSink);
        }
        return new HiveWriter(hiveFileWriter, partitionName, updateMode, path.fileName(), writeInfo.writePath().toString(), writeInfo.targetPath().toString(), this.hiveWriterStats);
    }

    public SortingFileWriter makeRowIdSortingWriter(FileWriter deleteFileWriter, Location path) {
        Location parentPath = HiveWriterFactory.setSchemeToFileIfAbsent(path.parentDirectory());
        Location tempFilePath = parentPath.appendPath(".tmp-sort." + path.fileName());
        ImmutableList sortFields = ImmutableList.of((Object)1, (Object)3);
        ImmutableList sortOrders = ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST, (Object)SortOrder.ASC_NULLS_FIRST);
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)this.rowType.get());
        return new SortingFileWriter(this.fileSystem, tempFilePath, deleteFileWriter, this.sortBufferSize, this.maxOpenSortFiles, (List<Type>)types, (List<Integer>)sortFields, (List<SortOrder>)sortOrders, this.pageSorter, this.typeManager.getTypeOperators(), OrcFileWriterFactory::createOrcDataSink);
    }

    private void validateSchema(Optional<String> partitionName, Map<String, String> schema) {
        List<String> fileColumnNames = HiveUtil.getColumnNames(schema);
        List<HiveType> fileColumnHiveTypes = HiveUtil.getColumnTypes(schema);
        Map inputColumnMap = this.dataColumns.stream().collect(Collectors.toMap(DataColumn::getName, Function.identity()));
        Sets.SetView missingColumns = Sets.difference(inputColumnMap.keySet(), new HashSet<String>(fileColumnNames));
        if (!missingColumns.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table '%s.%s' does not have columns %s", this.schemaName, this.tableName, missingColumns));
        }
        if (fileColumnNames.size() != fileColumnHiveTypes.size()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Partition '%s' in table '%s.%s' has mismatched metadata for column names and types", partitionName.orElse(""), this.schemaName, this.tableName));
        }
        for (int fileIndex = 0; fileIndex < fileColumnNames.size(); ++fileIndex) {
            HiveType inputHiveType;
            String columnName = fileColumnNames.get(fileIndex);
            HiveType fileColumnHiveType = fileColumnHiveTypes.get(fileIndex);
            if (fileColumnHiveType.equals((Object)(inputHiveType = ((DataColumn)inputColumnMap.get(columnName)).getHiveType()))) continue;
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The column '%s' in table '%s.%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", columnName, this.schemaName, this.tableName, inputHiveType, partitionName.orElse(""), columnName, fileColumnHiveType));
        }
    }

    private String computeAcidSubdir(AcidTransaction transaction) {
        long writeId = transaction.getWriteId();
        switch (transaction.getOperation()) {
            case INSERT: 
            case CREATE_TABLE: 
            case MERGE: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("transaction operation is " + String.valueOf(transaction.getOperation()));
            }
        }
        return AcidTables.deltaSubdir(writeId, 0);
    }

    private String computeFileName(OptionalInt bucketNumber) {
        if (bucketNumber.isPresent()) {
            if (this.isCreateTransactionalTable) {
                return HiveWriterFactory.computeTransactionalBucketedFilename(bucketNumber.getAsInt());
            }
            return HiveWriterFactory.computeNonTransactionalBucketedFilename(this.queryId, bucketNumber.getAsInt());
        }
        if (this.isCreateTransactionalTable) {
            String paddedBucket = Strings.padStart((String)"0", (int)BUCKET_NUMBER_PADDING, (char)'0');
            UUID uuid = UUID.randomUUID();
            return String.format("0%s_%s%s", paddedBucket, Long.toUnsignedString(uuid.getLeastSignificantBits()), Long.toUnsignedString(uuid.getMostSignificantBits()));
        }
        return this.queryId + "_" + String.valueOf(UUID.randomUUID());
    }

    public static String computeNonTransactionalBucketedFilename(String queryId, int bucket) {
        return HiveWriterFactory.computeBucketedFileName(Optional.of(String.valueOf(UUID.randomUUID()) + "_" + queryId), bucket);
    }

    public static String computeTransactionalBucketedFilename(int bucket) {
        return HiveWriterFactory.computeBucketedFileName(Optional.empty(), bucket);
    }

    private static String computeBucketedFileName(Optional<String> suffix, int bucket) {
        String paddedBucket = Strings.padStart((String)Integer.toString(bucket), (int)BUCKET_NUMBER_PADDING, (char)'0');
        if (suffix.isPresent()) {
            return String.format("0%s_0_%s", paddedBucket, suffix.get());
        }
        return String.format("0%s_0", paddedBucket);
    }

    public static int getBucketFromFileName(String fileName) {
        Matcher matcher = BUCKET_FROM_FILENAME_PATTERN.matcher(fileName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"filename %s does not match pattern %s", (Object)fileName, (Object)BUCKET_FROM_FILENAME_PATTERN);
        return Integer.parseInt(matcher.group(1));
    }

    public static String getFileExtension(HiveCompressionCodec compression, StorageFormat format) {
        return compression.getHiveCompressionKind().filter(compressionKind -> format.getOutputFormat().equals("org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat")).map(CompressionKind::getFileExtension).orElse("");
    }

    @VisibleForTesting
    static Location setSchemeToFileIfAbsent(Location location) {
        if (location.scheme().isPresent()) {
            return location;
        }
        return Location.of((String)("file:///" + location.path()));
    }

    private static class DataColumn {
        private final String name;
        private final HiveType hiveType;

        public DataColumn(String name, HiveType hiveType) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        }

        public String getName() {
            return this.name;
        }

        public HiveType getHiveType() {
            return this.hiveType;
        }
    }

    public static interface RowIdSortingFileWriterMaker {
        public SortingFileWriter makeFileWriter(FileWriter var1, Location var2);
    }
}

