/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CountingOutputStream;
import io.airlift.slice.SizeOf;
import io.trino.filesystem.TrinoInputFile;
import io.trino.hive.formats.compression.CompressionKind;
import io.trino.hive.formats.encodings.ColumnEncodingFactory;
import io.trino.hive.formats.rcfile.RcFileWriter;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public final class RcFileFileWriter
implements FileWriter {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(RcFileFileWriter.class);
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private final CountingOutputStream outputStream;
    private final AggregatedMemoryContext outputStreamMemoryContext;
    private final RcFileWriter rcFileWriter;
    private final Closeable rollbackAction;
    private final int[] fileInputColumnIndexes;
    private final List<Block> nullBlocks;
    private final Optional<Supplier<TrinoInputFile>> validationInputFactory;
    private long validationCpuNanos;

    public RcFileFileWriter(OutputStream outputStream, AggregatedMemoryContext outputStreamMemoryContext, Closeable rollbackAction, ColumnEncodingFactory columnEncodingFactory, List<Type> fileColumnTypes, Optional<CompressionKind> compressionKind, int[] fileInputColumnIndexes, Map<String, String> metadata, Optional<Supplier<TrinoInputFile>> validationInputFactory) throws IOException {
        this.outputStream = new CountingOutputStream(outputStream);
        this.outputStreamMemoryContext = outputStreamMemoryContext;
        this.rcFileWriter = new RcFileWriter((OutputStream)this.outputStream, fileColumnTypes, columnEncodingFactory, compressionKind, metadata, validationInputFactory.isPresent());
        this.rollbackAction = Objects.requireNonNull(rollbackAction, "rollbackAction is null");
        this.fileInputColumnIndexes = Objects.requireNonNull(fileInputColumnIndexes, "fileInputColumnIndexes is null");
        ImmutableList.Builder nullBlocks = ImmutableList.builder();
        for (Type fileColumnType : fileColumnTypes) {
            nullBlocks.add((Object)fileColumnType.createNullBlock());
        }
        this.nullBlocks = nullBlocks.build();
        this.validationInputFactory = validationInputFactory;
    }

    @Override
    public long getWrittenBytes() {
        return this.outputStream.getCount();
    }

    @Override
    public long getMemoryUsage() {
        return (long)INSTANCE_SIZE + this.rcFileWriter.getRetainedSizeInBytes() + this.outputStreamMemoryContext.getBytes();
    }

    @Override
    public void appendRows(Page dataPage) {
        Block[] blocks = new Block[this.fileInputColumnIndexes.length];
        for (int i = 0; i < this.fileInputColumnIndexes.length; ++i) {
            int inputColumnIndex = this.fileInputColumnIndexes[i];
            blocks[i] = inputColumnIndex < 0 ? RunLengthEncodedBlock.create((Block)this.nullBlocks.get(i), (int)dataPage.getPositionCount()) : dataPage.getBlock(inputColumnIndex);
        }
        Page page = new Page(dataPage.getPositionCount(), blocks);
        try {
            this.rcFileWriter.write(page);
        }
        catch (IOException | UncheckedIOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, (Throwable)e);
        }
    }

    @Override
    public Closeable commit() {
        try {
            this.rcFileWriter.close();
        }
        catch (IOException | UncheckedIOException e) {
            try {
                this.rollbackAction.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write to Hive", (Throwable)e);
        }
        if (this.validationInputFactory.isPresent()) {
            try {
                TrinoInputFile inputFile = this.validationInputFactory.get().get();
                long startThreadCpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
                this.rcFileWriter.validate(inputFile);
                this.validationCpuNanos += THREAD_MX_BEAN.getCurrentThreadCpuTime() - startThreadCpuTime;
            }
            catch (IOException | UncheckedIOException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITE_VALIDATION_FAILED, (Throwable)e);
            }
        }
        return this.rollbackAction;
    }

    @Override
    public void rollback() {
        try (Closeable closeable = this.rollbackAction;){
            this.rcFileWriter.close();
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)e);
        }
    }

    @Override
    public long getValidationCpuNanos() {
        return this.validationCpuNanos;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("writer", (Object)this.rcFileWriter).toString();
    }
}

