/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Strings;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;

public class TableOfflineException
extends TrinoException {
    public TableOfflineException(SchemaTableName tableName, boolean forPresto, String offlineMessage) {
        super((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_OFFLINE, TableOfflineException.formatMessage(tableName, forPresto, offlineMessage));
    }

    private static String formatMessage(SchemaTableName tableName, boolean forPresto, String offlineMessage) {
        StringBuilder resultBuilder = new StringBuilder().append("Table '").append(tableName).append("'").append(" is offline");
        if (forPresto) {
            resultBuilder.append(" for Presto");
        }
        if (!Strings.isNullOrEmpty((String)offlineMessage)) {
            resultBuilder.append(": ").append(offlineMessage);
        }
        return resultBuilder.toString();
    }
}

