/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.avro;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CountingOutputStream;
import io.airlift.slice.SizeOf;
import io.trino.hive.formats.avro.AvroCompressionKind;
import io.trino.hive.formats.avro.AvroFileWriter;
import io.trino.hive.formats.avro.AvroTypeBlockHandler;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.AvroTypeManager;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.avro.AvroHiveFileUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;

public final class AvroHiveFileWriter
implements FileWriter {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(AvroHiveFileWriter.class);
    private final AvroFileWriter fileWriter;
    private final List<Block> typeCorrectNullBlocks;
    private final CountingOutputStream countingOutputStream;
    private final AggregatedMemoryContext outputStreamMemoryContext;
    private final Closeable rollbackAction;

    public AvroHiveFileWriter(OutputStream outputStream, AggregatedMemoryContext outputStreamMemoryContext, Schema fileSchema, AvroTypeManager typeManager, AvroTypeBlockHandler avroTypeBlockHandler, Closeable rollbackAction, List<String> inputColumnNames, List<Type> inputColumnTypes, AvroCompressionKind compressionKind, Map<String, String> metadata) throws IOException, AvroTypeException {
        this.countingOutputStream = new CountingOutputStream(Objects.requireNonNull(outputStream, "outputStream is null"));
        this.outputStreamMemoryContext = Objects.requireNonNull(outputStreamMemoryContext, "outputStreamMemoryContext is null");
        Verify.verify((Objects.requireNonNull(fileSchema, "fileSchema is null").getType() == Schema.Type.RECORD ? 1 : 0) != 0, (String)"file schema must be record schema", (Object[])new Object[0]);
        Verify.verify((inputColumnNames.size() == inputColumnTypes.size() ? 1 : 0) != 0, (String)"column names must be equal to column types", (Object[])new Object[0]);
        ImmutableList.Builder outputColumnNames = ImmutableList.builder();
        ImmutableList.Builder outputColumnTypes = ImmutableList.builder().addAll(inputColumnTypes);
        Map<String, String> canonicalToGivenFieldName = AvroHiveFileUtils.getCanonicalToGivenFieldName(fileSchema);
        Map fields = fileSchema.getFields().stream().collect(Collectors.toMap(Schema.Field::name, Function.identity()));
        for (String inputColumnName : inputColumnNames) {
            Schema.Field field = (Schema.Field)fields.remove(canonicalToGivenFieldName.get(inputColumnName));
            if (field == null) {
                throw new AvroTypeException("File schema doesn't have input field " + inputColumnName);
            }
            outputColumnNames.add((Object)field.name().toLowerCase(Locale.ENGLISH));
        }
        ImmutableList.Builder blocks = ImmutableList.builder();
        for (Map.Entry entry : fields.entrySet()) {
            outputColumnNames.add((Object)entry.getKey().toLowerCase(Locale.ENGLISH));
            Type type = avroTypeBlockHandler.typeFor(((Schema.Field)entry.getValue()).schema());
            outputColumnTypes.add((Object)type);
            blocks.add((Object)type.createNullBlock());
        }
        this.typeCorrectNullBlocks = blocks.build();
        this.fileWriter = new AvroFileWriter((OutputStream)this.countingOutputStream, fileSchema, typeManager, compressionKind, metadata, (List)outputColumnNames.build(), (List)outputColumnTypes.build(), true);
        this.rollbackAction = Objects.requireNonNull(rollbackAction, "rollbackAction is null");
    }

    @Override
    public long getWrittenBytes() {
        return this.countingOutputStream.getCount();
    }

    @Override
    public long getMemoryUsage() {
        return (long)INSTANCE_SIZE + this.fileWriter.getRetainedSize() + this.outputStreamMemoryContext.getBytes();
    }

    @Override
    public void appendRows(Page dataPage) {
        try {
            int i;
            Block[] blocks = new Block[dataPage.getChannelCount() + this.typeCorrectNullBlocks.size()];
            for (i = 0; i < dataPage.getChannelCount(); ++i) {
                blocks[i] = dataPage.getBlock(i);
            }
            for (i = 0; i < this.typeCorrectNullBlocks.size(); ++i) {
                blocks[i + dataPage.getChannelCount()] = RunLengthEncodedBlock.create((Block)this.typeCorrectNullBlocks.get(i), (int)dataPage.getPositionCount());
            }
            this.fileWriter.write(new Page(blocks));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, "Failed to write data page to Avro file", (Throwable)e);
        }
    }

    @Override
    public Closeable commit() {
        try {
            this.fileWriter.close();
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Failed to close AvroFileWriter", (Throwable)e);
        }
        return this.rollbackAction;
    }

    @Override
    public void rollback() {
        try (Closeable closeable = this.rollbackAction;){
            this.fileWriter.close();
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)e);
        }
    }

    @Override
    public long getValidationCpuNanos() {
        return 0L;
    }
}

