/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.RealType;
import io.trino.spi.type.VarcharType;

public final class FloatToVarcharCoercers {
    private FloatToVarcharCoercers() {
    }

    public static TypeCoercer<RealType, VarcharType> createFloatToVarcharCoercer(VarcharType toType, boolean isOrcFile) {
        return isOrcFile ? new OrcFloatToVarcharCoercer(toType) : new FloatToVarcharCoercer(toType);
    }

    private static void writeFloatAsSlice(float value, BlockBuilder blockBuilder, VarcharType varcharType) {
        Slice converted = Slices.utf8Slice((String)Float.toString(value));
        if (!varcharType.isUnbounded() && SliceUtf8.countCodePoints((Slice)converted) > varcharType.getBoundedLength()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Varchar representation of %s exceeds %s bounds", Float.valueOf(value), varcharType));
        }
        varcharType.writeSlice(blockBuilder, converted);
    }

    public static class OrcFloatToVarcharCoercer
    extends TypeCoercer<RealType, VarcharType> {
        public OrcFloatToVarcharCoercer(VarcharType toType) {
            super(RealType.REAL, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            float floatValue = RealType.REAL.getFloat(block, position);
            if (Float.isNaN(floatValue)) {
                blockBuilder.appendNull();
                return;
            }
            FloatToVarcharCoercers.writeFloatAsSlice(floatValue, blockBuilder, (VarcharType)this.toType);
        }
    }

    public static class FloatToVarcharCoercer
    extends TypeCoercer<RealType, VarcharType> {
        public FloatToVarcharCoercer(VarcharType toType) {
            super(RealType.REAL, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            FloatToVarcharCoercers.writeFloatAsSlice(RealType.REAL.getFloat(block, position), blockBuilder, (VarcharType)this.toType);
        }
    }
}

