/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.RawHiveMetastoreFactory;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.metastore.cache.CachingHiveMetastoreConfig;
import io.trino.metastore.cache.ImpersonationCachingConfig;
import io.trino.metastore.cache.SharedHiveMetastoreCache;
import java.util.Optional;
import org.weakref.jmx.guice.ExportBinder;

public final class CachingHiveMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CachingHiveMetastoreConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ImpersonationCachingConfig.class);
        binder.bind(SharedHiveMetastoreCache.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(HiveMetastoreFactory.class).as(generator -> generator.generatedNameOf(CachingHiveMetastore.class));
    }

    public boolean equals(Object obj) {
        return obj instanceof CachingHiveMetastoreModule;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    @Provides
    @Singleton
    public static HiveMetastoreFactory createHiveMetastore(@RawHiveMetastoreFactory HiveMetastoreFactory metastoreFactory, SharedHiveMetastoreCache sharedHiveMetastoreCache) {
        return sharedHiveMetastoreCache.createCachingHiveMetastoreFactory(metastoreFactory);
    }

    @Provides
    @Singleton
    public static Optional<CachingHiveMetastore> createHiveMetastore(HiveMetastoreFactory metastoreFactory) {
        if (metastoreFactory instanceof SharedHiveMetastoreCache.CachingHiveMetastoreFactory) {
            SharedHiveMetastoreCache.CachingHiveMetastoreFactory cachingHiveMetastoreFactory = (SharedHiveMetastoreCache.CachingHiveMetastoreFactory)metastoreFactory;
            return Optional.of(cachingHiveMetastoreFactory.getMetastore());
        }
        return Optional.empty();
    }
}

