/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.RawHiveMetastoreFactory;
import io.trino.plugin.hive.AllowHiveTableRename;
import io.trino.plugin.hive.metastore.CachingHiveMetastoreModule;
import io.trino.plugin.hive.metastore.MetastoreTypeConfig;
import io.trino.plugin.hive.metastore.file.FileMetastoreModule;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreModule;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreModule;
import java.util.Optional;

public class HiveMetastoreModule
extends AbstractConfigurationAwareModule {
    private final Optional<HiveMetastore> metastore;

    public HiveMetastoreModule(Optional<HiveMetastore> metastore) {
        this.metastore = metastore;
    }

    protected void setup(Binder binder) {
        if (this.metastore.isPresent()) {
            binder.bind(HiveMetastoreFactory.class).annotatedWith(RawHiveMetastoreFactory.class).toInstance((Object)HiveMetastoreFactory.ofInstance((HiveMetastore)this.metastore.get()));
            binder.bind(Key.get(Boolean.TYPE, AllowHiveTableRename.class)).toInstance((Object)true);
        } else {
            this.install((Module)(switch (((MetastoreTypeConfig)this.buildConfigObject(MetastoreTypeConfig.class)).getMetastoreType()) {
                default -> throw new MatchException(null, null);
                case MetastoreTypeConfig.MetastoreType.THRIFT -> new ThriftMetastoreModule();
                case MetastoreTypeConfig.MetastoreType.FILE -> new FileMetastoreModule();
                case MetastoreTypeConfig.MetastoreType.GLUE -> new GlueMetastoreModule();
            }));
        }
        this.install((Module)new CachingHiveMetastoreModule());
    }
}

