/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.file;

import com.google.inject.Inject;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.tracing.TracingHiveMetastore;
import io.trino.plugin.hive.HideDeltaLakeTables;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastoreConfig;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Optional;

public class FileHiveMetastoreFactory
implements HiveMetastoreFactory {
    private final HiveMetastore metastore;

    @Inject
    public FileHiveMetastoreFactory(NodeVersion nodeVersion, TrinoFileSystemFactory fileSystemFactory, @HideDeltaLakeTables boolean hideDeltaLakeTables, FileHiveMetastoreConfig config, Tracer tracer) {
        this.metastore = new TracingHiveMetastore(tracer, (HiveMetastore)new FileHiveMetastore(nodeVersion, fileSystemFactory, hideDeltaLakeTables, config));
    }

    public boolean isImpersonationEnabled() {
        return false;
    }

    public HiveMetastore createMetastore(Optional<ConnectorIdentity> identity) {
        return this.metastore;
    }
}

