/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.inject.Inject;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionRequest;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.CreateUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.glue.model.DeletePartitionRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.GetDatabaseRequest;
import software.amazon.awssdk.services.glue.model.GetDatabasesRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTablesRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.UpdateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.UpdatePartitionRequest;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;
import software.amazon.awssdk.services.glue.model.UpdateUserDefinedFunctionRequest;

public class GlueCatalogIdInterceptor
implements ExecutionInterceptor {
    private final Optional<String> catalogId;

    @Inject
    GlueCatalogIdInterceptor(GlueHiveMetastoreConfig config) {
        this.catalogId = config.getCatalogId();
    }

    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest.Builder builder = context.request().toBuilder();
        this.catalogId.ifPresent(id -> GlueCatalogIdInterceptor.setCatalogId(builder, id));
        return builder.build();
    }

    private static void setCatalogId(SdkRequest.Builder request, String catalogId) {
        SdkRequest.Builder builder = request;
        Objects.requireNonNull(builder);
        SdkRequest.Builder builder2 = builder;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GetDatabasesRequest.Builder.class, GetDatabaseRequest.Builder.class, CreateDatabaseRequest.Builder.class, UpdateDatabaseRequest.Builder.class, DeleteDatabaseRequest.Builder.class, GetTablesRequest.Builder.class, GetTableRequest.Builder.class, CreateTableRequest.Builder.class, UpdateTableRequest.Builder.class, DeleteTableRequest.Builder.class, GetPartitionsRequest.Builder.class, GetPartitionRequest.Builder.class, UpdatePartitionRequest.Builder.class, DeletePartitionRequest.Builder.class, BatchGetPartitionRequest.Builder.class, BatchCreatePartitionRequest.Builder.class, BatchUpdatePartitionRequest.Builder.class, GetColumnStatisticsForTableRequest.Builder.class, UpdateColumnStatisticsForTableRequest.Builder.class, DeleteColumnStatisticsForTableRequest.Builder.class, GetColumnStatisticsForPartitionRequest.Builder.class, UpdateColumnStatisticsForPartitionRequest.Builder.class, DeleteColumnStatisticsForPartitionRequest.Builder.class, GetUserDefinedFunctionsRequest.Builder.class, GetUserDefinedFunctionRequest.Builder.class, CreateUserDefinedFunctionRequest.Builder.class, UpdateUserDefinedFunctionRequest.Builder.class, DeleteUserDefinedFunctionRequest.Builder.class}, (SdkRequest.Builder)builder2, n)) {
            case 0: {
                GetDatabasesRequest.Builder builder3 = (GetDatabasesRequest.Builder)builder2;
                builder3.catalogId(catalogId);
                break;
            }
            case 1: {
                GetDatabaseRequest.Builder builder4 = (GetDatabaseRequest.Builder)builder2;
                builder4.catalogId(catalogId);
                break;
            }
            case 2: {
                CreateDatabaseRequest.Builder builder5 = (CreateDatabaseRequest.Builder)builder2;
                builder5.catalogId(catalogId);
                break;
            }
            case 3: {
                UpdateDatabaseRequest.Builder builder6 = (UpdateDatabaseRequest.Builder)builder2;
                builder6.catalogId(catalogId);
                break;
            }
            case 4: {
                DeleteDatabaseRequest.Builder builder7 = (DeleteDatabaseRequest.Builder)builder2;
                builder7.catalogId(catalogId);
                break;
            }
            case 5: {
                GetTablesRequest.Builder builder8 = (GetTablesRequest.Builder)builder2;
                builder8.catalogId(catalogId);
                break;
            }
            case 6: {
                GetTableRequest.Builder builder9 = (GetTableRequest.Builder)builder2;
                builder9.catalogId(catalogId);
                break;
            }
            case 7: {
                CreateTableRequest.Builder builder10 = (CreateTableRequest.Builder)builder2;
                builder10.catalogId(catalogId);
                break;
            }
            case 8: {
                UpdateTableRequest.Builder builder11 = (UpdateTableRequest.Builder)builder2;
                builder11.catalogId(catalogId);
                break;
            }
            case 9: {
                DeleteTableRequest.Builder builder12 = (DeleteTableRequest.Builder)builder2;
                builder12.catalogId(catalogId);
                break;
            }
            case 10: {
                GetPartitionsRequest.Builder builder13 = (GetPartitionsRequest.Builder)builder2;
                builder13.catalogId(catalogId);
                break;
            }
            case 11: {
                GetPartitionRequest.Builder builder14 = (GetPartitionRequest.Builder)builder2;
                builder14.catalogId(catalogId);
                break;
            }
            case 12: {
                UpdatePartitionRequest.Builder builder15 = (UpdatePartitionRequest.Builder)builder2;
                builder15.catalogId(catalogId);
                break;
            }
            case 13: {
                DeletePartitionRequest.Builder builder16 = (DeletePartitionRequest.Builder)builder2;
                builder16.catalogId(catalogId);
                break;
            }
            case 14: {
                BatchGetPartitionRequest.Builder builder17 = (BatchGetPartitionRequest.Builder)builder2;
                builder17.catalogId(catalogId);
                break;
            }
            case 15: {
                BatchCreatePartitionRequest.Builder builder18 = (BatchCreatePartitionRequest.Builder)builder2;
                builder18.catalogId(catalogId);
                break;
            }
            case 16: {
                BatchUpdatePartitionRequest.Builder builder19 = (BatchUpdatePartitionRequest.Builder)builder2;
                builder19.catalogId(catalogId);
                break;
            }
            case 17: {
                GetColumnStatisticsForTableRequest.Builder builder20 = (GetColumnStatisticsForTableRequest.Builder)builder2;
                builder20.catalogId(catalogId);
                break;
            }
            case 18: {
                UpdateColumnStatisticsForTableRequest.Builder builder21 = (UpdateColumnStatisticsForTableRequest.Builder)builder2;
                builder21.catalogId(catalogId);
                break;
            }
            case 19: {
                DeleteColumnStatisticsForTableRequest.Builder builder22 = (DeleteColumnStatisticsForTableRequest.Builder)builder2;
                builder22.catalogId(catalogId);
                break;
            }
            case 20: {
                GetColumnStatisticsForPartitionRequest.Builder builder23 = (GetColumnStatisticsForPartitionRequest.Builder)builder2;
                builder23.catalogId(catalogId);
                break;
            }
            case 21: {
                UpdateColumnStatisticsForPartitionRequest.Builder builder24 = (UpdateColumnStatisticsForPartitionRequest.Builder)builder2;
                builder24.catalogId(catalogId);
                break;
            }
            case 22: {
                DeleteColumnStatisticsForPartitionRequest.Builder builder25 = (DeleteColumnStatisticsForPartitionRequest.Builder)builder2;
                builder25.catalogId(catalogId);
                break;
            }
            case 23: {
                GetUserDefinedFunctionsRequest.Builder builder26 = (GetUserDefinedFunctionsRequest.Builder)builder2;
                builder26.catalogId(catalogId);
                break;
            }
            case 24: {
                GetUserDefinedFunctionRequest.Builder builder27 = (GetUserDefinedFunctionRequest.Builder)builder2;
                builder27.catalogId(catalogId);
                break;
            }
            case 25: {
                CreateUserDefinedFunctionRequest.Builder builder28 = (CreateUserDefinedFunctionRequest.Builder)builder2;
                builder28.catalogId(catalogId);
                break;
            }
            case 26: {
                UpdateUserDefinedFunctionRequest.Builder builder29 = (UpdateUserDefinedFunctionRequest.Builder)builder2;
                builder29.catalogId(catalogId);
                break;
            }
            case 27: {
                DeleteUserDefinedFunctionRequest.Builder builder30 = (DeleteUserDefinedFunctionRequest.Builder)builder2;
                builder30.catalogId(catalogId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported request: " + String.valueOf(request));
            }
        }
    }
}

