/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.stats.CounterStat;
import io.airlift.stats.TimeStat;
import io.trino.hive.thrift.metastore.MetaException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class ThriftMetastoreApiStats {
    private final TimeStat time = new TimeStat(TimeUnit.MILLISECONDS);
    private final CounterStat totalFailures = new CounterStat();
    private final CounterStat metastoreExceptions = new CounterStat();
    private final CounterStat thriftExceptions = new CounterStat();

    public <V> Callable<V> wrap(Callable<V> callable) {
        return () -> {
            Object v;
            block12: {
                TimeStat.BlockTimer blockTimer = this.time.time();
                try {
                    v = callable.call();
                    if (blockTimer == null) break block12;
                }
                catch (Throwable t$) {
                    try {
                        if (blockTimer != null) {
                            try {
                                blockTimer.close();
                            }
                            catch (Throwable x2) {
                                t$.addSuppressed(x2);
                            }
                        }
                        throw t$;
                    }
                    catch (Exception e) {
                        if (e instanceof MetaException) {
                            this.metastoreExceptions.update(1L);
                        } else if (e instanceof TException) {
                            if (e instanceof TBase) {
                                throw e;
                            }
                            this.thriftExceptions.update(1L);
                        }
                        this.totalFailures.update(1L);
                        throw e;
                    }
                }
                blockTimer.close();
            }
            return v;
        };
    }

    @Managed
    @Nested
    public TimeStat getTime() {
        return this.time;
    }

    @Managed
    @Nested
    public CounterStat getTotalFailures() {
        return this.totalFailures;
    }

    @Managed
    @Nested
    public CounterStat getThriftExceptions() {
        return this.thriftExceptions;
    }

    @Managed
    @Nested
    public CounterStat getMetastoreExceptions() {
        return this.metastoreExceptions;
    }
}

